/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.datagen.assets;

import com.satherov.crystalix.content.CrystalixRegistry;
import com.satherov.crystalix.content.block.CrystalixGlass;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class CrystalixBlockStateProvider
extends BlockStateProvider {
    public CrystalixBlockStateProvider(PackOutput output, ExistingFileHelper fileHelper) {
        super(output, "crystalix", fileHelper);
    }

    protected void registerStatesAndModels() {
        CrystalixRegistry.BLOCKS_MAP.forEach((color, set) -> set.forEach(this::registerCrystalixBlock));
    }

    private void registerCrystalixBlock(CrystalixRegistry.BlockTypes type, RegistryObject<? extends Block> block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
        String path = "block/" + type.m_7912_() + "/" + block.getId().m_135815_();
        ModelFile.ExistingModelFile shadedModel = this.models().getExistingFile(this.modLoc(path));
        ModelFile.ExistingModelFile noShadedModel = this.models().getExistingFile(this.modLoc(path + "_no_shade"));
        builder.partialState().with((Property)CrystalixGlass.SHADELESS, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)shadedModel).addModel();
        builder.partialState().with((Property)CrystalixGlass.SHADELESS, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)noShadedModel).addModel();
    }
}

