/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.network;

import com.google.common.base.Strings;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import shetiphian.core.common.NameHelper;
import shetiphian.core.common.network.PacketBase;
import shetiphian.core.internal.network.NetworkHandler;

public class PacketNameSync
extends PacketBase {
    private final UUID uuid;
    private final String teamID;
    private final String name;

    public PacketNameSync(UUID uuid, String name) {
        this.uuid = uuid;
        this.teamID = null;
        this.name = name;
    }

    public PacketNameSync(String teamID, String name) {
        this.uuid = null;
        this.teamID = teamID;
        this.name = name;
    }

    public static void writeData(PacketNameSync packet, FriendlyByteBuf buffer) {
        if (packet.uuid != null) {
            buffer.writeBoolean(true);
            PacketNameSync.writeString(buffer, packet.uuid.toString());
        } else {
            buffer.writeBoolean(false);
            PacketNameSync.writeString(buffer, packet.teamID);
        }
        PacketNameSync.writeString(buffer, packet.name);
    }

    public static PacketNameSync readData(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            String id = PacketNameSync.readString(buffer);
            UUID uuid = null;
            try {
                uuid = UUID.fromString(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new PacketNameSync(uuid, PacketNameSync.readString(buffer));
        }
        return new PacketNameSync(PacketNameSync.readString(buffer), PacketNameSync.readString(buffer));
    }

    @Override
    public void handleClientSide(Player player) {
        if (!Strings.isNullOrEmpty((String)this.name)) {
            if (this.uuid != null) {
                NameHelper.setPlayerName(this.uuid, this.name);
            } else if (!Strings.isNullOrEmpty((String)this.teamID)) {
                NameHelper.setTeamName(this.teamID, this.name);
            }
        }
    }

    @Override
    public void handleServerSide(Player player) {
        if (player instanceof ServerPlayer) {
            if (this.uuid != null) {
                String display = NameHelper.getLastKnownUsername(this.uuid);
                if (Strings.isNullOrEmpty((String)this.name) || !display.equalsIgnoreCase(this.name)) {
                    NetworkHandler.sendToPlayer(new PacketNameSync(this.uuid, display), (ServerPlayer)player);
                }
            } else if (!Strings.isNullOrEmpty((String)this.teamID)) {
                String display = NameHelper.getLastKnownTeamName(this.teamID, true);
                if (Strings.isNullOrEmpty((String)this.name) || !display.equalsIgnoreCase(this.name)) {
                    NetworkHandler.sendToPlayer(new PacketNameSync(this.teamID, display), (ServerPlayer)player);
                }
            }
        }
    }
}

