/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.network;

import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.apiimpl.network.node.GridNetworkNode;
import com.refinedmods.refinedstorage.container.GridContainerMenu;
import com.refinedmods.refinedstorage.container.slot.legacy.LegacyFilterSlot;
import com.ultramega.cabletiers.container.slot.TieredFilterSlot;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class TieredSetFilterSlotMessage {
    private final int slotsMultiplier;
    private final int containerSlot;
    private final ItemStack stack;

    public TieredSetFilterSlotMessage(int slotsMultiplier, int containerSlot, Item item, int itemAmount) {
        this.slotsMultiplier = slotsMultiplier;
        this.containerSlot = containerSlot;
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.m_41764_(itemAmount);
        this.stack = stack;
    }

    public TieredSetFilterSlotMessage(int slotsMultiplier, int containerSlot, ItemStack stack, int itemAmount) {
        this.slotsMultiplier = slotsMultiplier;
        this.containerSlot = containerSlot;
        stack.m_41764_(itemAmount);
        this.stack = stack;
    }

    public static TieredSetFilterSlotMessage decode(FriendlyByteBuf buf) {
        return new TieredSetFilterSlotMessage(buf.readInt(), buf.readInt(), buf.m_130267_(), buf.readInt());
    }

    public static void encode(TieredSetFilterSlotMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.slotsMultiplier);
        buf.writeInt(message.containerSlot);
        buf.m_130055_(message.stack);
        buf.writeInt(message.stack.m_41613_());
    }

    public static void handle(TieredSetFilterSlotMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player;
        if (!message.stack.m_41619_() && message.stack.m_41613_() <= message.getTieredStackInteractCount(message.stack) && (player = ctx.get().getSender()) != null) {
            ctx.get().enqueueWork(() -> TieredSetFilterSlotMessage.lambda$handle$0((Player)player, message));
        }
        ctx.get().setPacketHandled(true);
    }

    private static void handle(TieredSetFilterSlotMessage message, AbstractContainerMenu container) {
        Slot slot = container.m_38853_(message.containerSlot);
        if (slot instanceof TieredFilterSlot || slot instanceof LegacyFilterSlot) {
            GridContainerMenu containerMenu;
            IGrid grid;
            Runnable postAction = () -> {};
            if (container instanceof GridContainerMenu && (grid = (containerMenu = (GridContainerMenu)container).getGrid()) instanceof GridNetworkNode) {
                GridNetworkNode networkNode = (GridNetworkNode)grid;
                if (slot.getSlotIndex() < networkNode.getAllowedTagList().getAllowedItemTags().size()) {
                    HashSet list = new HashSet((Collection)networkNode.getAllowedTagList().getAllowedItemTags().get(slot.getSlotIndex()));
                    postAction = () -> {
                        networkNode.getAllowedTagList().setAllowedItemTags(slot.getSlotIndex(), list);
                        networkNode.markDirty();
                    };
                }
            }
            slot.m_5852_(message.stack);
            postAction.run();
        }
    }

    private int getTieredStackInteractCount(ItemStack stack) {
        return (int)((double)stack.m_41741_() * Math.pow(this.slotsMultiplier, 3.0));
    }

    private static /* synthetic */ void lambda$handle$0(Player player, TieredSetFilterSlotMessage message) {
        AbstractContainerMenu container = player.f_36096_;
        if (container != null && message.containerSlot >= 0 && message.containerSlot < container.f_38839_.size()) {
            TieredSetFilterSlotMessage.handle(message, container);
        }
    }
}

