/*
 * Decompiled with CFR 0.152.
 */
package umpaz.nethersdelight.common.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;
import umpaz.nethersdelight.common.registry.NDBlocks;
import umpaz.nethersdelight.common.tag.NDTags;
import vectorwing.farmersdelight.common.block.MushroomColonyBlock;

public class FungusColonyBlock
extends MushroomColonyBlock {
    public static final int PLACING_LIGHT_LEVEL = 13;
    public static final IntegerProperty COLONY_AGE = BlockStateProperties.f_61407_;
    protected static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0)};

    public FungusColonyBlock(BlockBehaviour.Properties properties, Supplier<Item> fungusType) {
        super(properties, fungusType);
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_204336_(BlockTags.f_13077_) || state.m_60713_(Blocks.f_50195_) || state.m_60713_(Blocks.f_50136_) || state.m_60713_((Block)NDBlocks.RICH_SOUL_SOIL.get()) || state.m_204336_(BlockTags.f_144274_) || state.m_60713_(Blocks.f_50093_);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos floorPos = pos.m_7495_();
        BlockState floorState = level.m_8055_(floorPos);
        if (floorState.m_204336_(NDTags.FUNGUS_COLONY_GROWABLE_ON)) {
            return true;
        }
        return level.m_45524_(pos, 0) < 13 && floorState.canSustainPlant((BlockGetter)level, floorPos, Direction.UP, (IPlantable)this);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        int age = (Integer)state.m_61143_((Property)COLONY_AGE);
        ItemStack heldStack = player.m_21120_(handIn);
        if (age > 0 && heldStack.m_204117_(Tags.Items.SHEARS)) {
            FungusColonyBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)this.m_7397_((BlockGetter)worldIn, pos, state));
            worldIn.m_5594_(null, pos, SoundEvents.f_12075_, SoundSource.BLOCKS, 1.0f, 1.0f);
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)COLONY_AGE, (Comparable)Integer.valueOf(age - 1)), 2);
            if (!worldIn.f_46443_) {
                heldStack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7370_(LevelReader p_256559_, BlockPos p_50898_, BlockState p_50899_, boolean p_50900_) {
        return false;
    }

    public int getMaxAge() {
        return 3;
    }

    public boolean m_214167_(Level worldIn, RandomSource random, BlockPos pos, BlockState state) {
        return false;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int age = (Integer)state.m_61143_((Property)COLONY_AGE);
        BlockState groundState = level.m_8055_(pos.m_7495_());
        if (age < this.getMaxAge() && groundState.m_204336_(NDTags.FUNGUS_COLONY_GROWABLE_ON) && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(4) == 0 ? 1 : 0) != 0)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)COLONY_AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }
}

