/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.recipe.TimedRecipeInterface;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;

public class BeeBreedingRecipe
implements Recipe<Container>,
TimedRecipeInterface {
    public final ResourceLocation id;
    public final List<Lazy<BeeIngredient>> ingredients;
    public final Lazy<BeeIngredient> offspring;

    public BeeBreedingRecipe(ResourceLocation id, List<Lazy<BeeIngredient>> ingredients, Lazy<BeeIngredient> offspring) {
        this.id = id;
        this.ingredients = ingredients;
        this.offspring = offspring;
    }

    @Override
    public int getProcessingTime() {
        return (Integer)ProductiveBeesConfig.GENERAL.breedingChamberProcessingTime.get();
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        if (inv instanceof BeeHelper.IdentifierInventory) {
            String beeName1 = ((BeeHelper.IdentifierInventory)inv).getIdentifier(0);
            String beeName2 = ((BeeHelper.IdentifierInventory)inv).getIdentifier(1);
            for (Lazy<BeeIngredient> parent : this.ingredients) {
                if (parent.get() != null) {
                    String parentName = ((BeeIngredient)parent.get()).getBeeType().toString();
                    if (parentName.equals(beeName1) || parentName.equals(beeName2)) continue;
                    return false;
                }
                ProductiveBees.LOGGER.warn("Bee not found in breeding recipe " + this.id);
                return false;
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.BEE_BREEDING.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.BEE_BREEDING_TYPE.get();
    }

    public static class Serializer<T extends BeeBreedingRecipe>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            String parentName1 = GsonHelper.m_13906_((JsonObject)json, (String)"parent1");
            String parentName2 = GsonHelper.m_13906_((JsonObject)json, (String)"parent2");
            Lazy offspringIngredient = null;
            JsonArray offspring = GsonHelper.m_13933_((JsonObject)json, (String)"offspring");
            if (!offspring.isEmpty()) {
                offspringIngredient = Lazy.of(BeeIngredientFactory.getIngredient(offspring.get(0).getAsString()));
            }
            Lazy beeIngredientParent1 = Lazy.of(BeeIngredientFactory.getIngredient(parentName1));
            Lazy beeIngredientParent2 = Lazy.of(BeeIngredientFactory.getIngredient(parentName2));
            return this.factory.create(id, Arrays.asList(beeIngredientParent1, beeIngredientParent2), (Lazy<BeeIngredient>)offspringIngredient);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                ArrayList<Lazy<BeeIngredient>> ingredients = new ArrayList<Lazy<BeeIngredient>>();
                BeeIngredient ing1 = BeeIngredient.fromNetwork(buffer);
                BeeIngredient ing2 = BeeIngredient.fromNetwork(buffer);
                ingredients.add(Lazy.of(() -> ing1));
                ingredients.add(Lazy.of(() -> ing2));
                BeeIngredient offspring = BeeIngredient.fromNetwork(buffer);
                return this.factory.create(id, ingredients, (Lazy<BeeIngredient>)Lazy.of(() -> offspring));
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee breeding recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                for (Lazy<BeeIngredient> ingredient : ((BeeBreedingRecipe)recipe).ingredients) {
                    if (ingredient.get() != null) {
                        ((BeeIngredient)ingredient.get()).toNetwork(buffer);
                        continue;
                    }
                    throw new RuntimeException("Bee breeding recipe ingredient missing " + ((BeeBreedingRecipe)recipe).m_6423_() + " - " + ingredient);
                }
                if (((BeeBreedingRecipe)recipe).offspring.get() == null) {
                    throw new RuntimeException("Bee breeding recipe child missing " + ((BeeBreedingRecipe)recipe).m_6423_() + " - " + ((BeeBreedingRecipe)recipe).offspring.get());
                }
                ((BeeIngredient)((BeeBreedingRecipe)recipe).offspring.get()).toNetwork(buffer);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee breeding recipe to packet. " + ((BeeBreedingRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends BeeBreedingRecipe> {
            public T create(ResourceLocation var1, List<Lazy<BeeIngredient>> var2, Lazy<BeeIngredient> var3);
        }
    }
}

