/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.wood;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.CompatHandler;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoodType
extends BlockType {
    public static final Codec<WoodType> CODEC = ResourceLocation.f_135803_.flatXmap(r -> {
        WoodType w = (WoodType)WoodTypeRegistry.INSTANCE.get((ResourceLocation)r);
        if (w == null) {
            return DataResult.error(() -> "No such wood type: " + String.valueOf(r));
        }
        return DataResult.success((Object)w);
    }, t -> DataResult.success((Object)t.id));
    public final Block planks;
    public final Block log;
    private final Supplier<net.minecraft.world.level.block.state.properties.WoodType> vanillaType = Suppliers.memoize(this::detectVanillaWood);

    @Nullable
    private net.minecraft.world.level.block.state.properties.WoodType detectVanillaWood() {
        Object object = this.getChild("hanging_sign");
        if (object instanceof CeilingHangingSignBlock) {
            CeilingHangingSignBlock c = (CeilingHangingSignBlock)object;
            return c.m_56297_();
        }
        object = this.getChild("sign");
        if (object instanceof SignBlock) {
            SignBlock f = (SignBlock)object;
            return f.m_56297_();
        }
        String i = this.id.m_135827_().equals("minecraft") ? this.id.m_135815_() : this.id.toString();
        Stream values = net.minecraft.world.level.block.state.properties.WoodType.m_61843_();
        Optional<net.minecraft.world.level.block.state.properties.WoodType> o = values.filter(v -> v.f_61839_().equals(i)).findAny();
        return o.orElse(null);
    }

    public WoodType(ResourceLocation id, Block baseBlock, Block logBlock) {
        super(id);
        this.planks = baseBlock;
        this.log = logBlock;
    }

    @Override
    public ItemLike mainChild() {
        return this.planks;
    }

    @Nullable
    public net.minecraft.world.level.block.state.properties.WoodType toVanilla() {
        return this.vanillaType.get();
    }

    @NotNull
    public net.minecraft.world.level.block.state.properties.WoodType toVanillaOrOak() {
        net.minecraft.world.level.block.state.properties.WoodType v = this.toVanilla();
        if (v != null) {
            return v;
        }
        return net.minecraft.world.level.block.state.properties.WoodType.f_61830_;
    }

    public String getTexturePath() {
        String namespace = this.getNamespace();
        if (namespace.equals("minecraft")) {
            return this.getTypeName();
        }
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public boolean canBurn() {
        return this.planks.m_49966_().m_278200_();
    }

    public MapColor getColor() {
        return this.planks.m_284356_();
    }

    @Override
    public String getTranslationKey() {
        return "wood_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    public void initializeChildrenBlocks() {
        this.addChild("planks", this.planks);
        this.addChild("log", this.log);
        this.addChild("leaves", this.findRelatedEntry("leaves", BuiltInRegistries.f_256975_));
        this.addChild("wood", this.findLogRelatedBlock("", "wood", "hyphae", "bark"));
        this.addChild("stripped_log", this.findStrippedLog("log", "stem", "stalk"));
        this.addChild("stripped_wood", this.findStrippedLog("wood", "hyphae", "bark"));
        this.addChild("slab", this.findRelatedEntry("slab", BuiltInRegistries.f_256975_));
        this.addChild("stairs", this.findRelatedEntry("stairs", BuiltInRegistries.f_256975_));
        Block fence = (Block)this.findRelatedEntry("fence", BuiltInRegistries.f_256975_);
        this.addChild("fence", fence);
        this.addChild("fence_gate", this.findRelatedEntry("fence_gate", BuiltInRegistries.f_256975_));
        this.addChild("door", this.findRelatedEntry("door", BuiltInRegistries.f_256975_));
        this.addChild("trapdoor", this.findRelatedEntry("trapdoor", BuiltInRegistries.f_256975_));
        this.addChild("button", this.findRelatedEntry("button", BuiltInRegistries.f_256975_));
        this.addChild("pressure_plate", this.findRelatedEntry("pressure_plate", BuiltInRegistries.f_256975_));
        this.addChild("hanging_sign", this.findRelatedEntry("hanging_sign", BuiltInRegistries.f_256975_));
        this.addChild("wall_hanging_sign", this.findRelatedEntry("wall_hanging_sign", BuiltInRegistries.f_256975_));
        this.addChild("sign", this.findRelatedEntry("sign", BuiltInRegistries.f_256975_));
        this.addChild("wall_sign", this.findRelatedEntry("wall_sign", BuiltInRegistries.f_256975_));
        if (this.id.m_135827_().matches("tfc|afc")) {
            this.addChild("sign", this.findRelatedEntry("sign", "", (Registry)BuiltInRegistries.f_256975_));
            this.addChild("hanging_sign", this.findRelatedEntry("hanging_sign/wrought_sign", "", (Registry)BuiltInRegistries.f_256975_));
        }
        if (fence != null && CompatHandler.DIAGONALFENCES) {
            Optional diagonalFence = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation("diagonalfences", Utils.getID(fence).toString().replace(":", "/")));
            diagonalFence.ifPresent(block -> this.addChild("diagonalfences:fence", block));
        }
    }

    @Override
    public void initializeChildrenItems() {
        this.addChild("boat", this.findRelatedItem("boat", "raft"));
        this.addChild("chest_boat", this.findRelatedItem("chest_boat", "chest_raft"));
        this.addChild("sapling", this.findRelatedEntry("sapling", BuiltInRegistries.f_257033_));
        if (this.id.m_135827_().matches("tfc|afc")) {
            this.addChild("stick", this.findRelatedEntry("twig", BuiltInRegistries.f_256975_));
            this.addChild("boat", this.findRelatedEntry("boat", "", (Registry)BuiltInRegistries.f_256975_));
        }
    }

    @Override
    @Nullable
    protected <V> V findRelatedEntry(String prefixOrInfix, String suffix, Registry<V> reg) {
        if (!((String)suffix).isEmpty()) {
            suffix = "_" + (String)suffix;
        }
        ResourceLocation[] targets = new ResourceLocation[]{new ResourceLocation(this.id.m_135827_(), this.id.m_135815_() + "_" + prefixOrInfix + (String)suffix), new ResourceLocation(this.id.m_135827_(), prefixOrInfix + "_" + this.id.m_135815_() + (String)suffix), new ResourceLocation(this.id.m_135827_(), this.id.m_135815_() + "_planks_" + prefixOrInfix + (String)suffix), new ResourceLocation(this.id.m_135827_(), "wood/planks/" + this.id.m_135815_() + "_" + prefixOrInfix), new ResourceLocation(this.id.m_135827_(), "wood/" + prefixOrInfix + (String)suffix + "/" + this.id.m_135815_())};
        return Utils.findFirstInRegistry(reg, targets);
    }

    @Nullable
    protected Block findStrippedLog(String ... possibleNames) {
        for (String v : possibleNames) {
            Block stripped;
            Block b = this.getBlockOfThis(v);
            if (v == null || (stripped = (Block)AxeItem.f_150683_.get(b)) == null || stripped == b) continue;
            return stripped;
        }
        return this.findLogRelatedBlock("stripped", possibleNames);
    }

    @Nullable
    protected Item findRelatedItem(String ... names) {
        for (String n : names) {
            Item b = (Item)this.findRelatedEntry(n, BuiltInRegistries.f_257033_);
            if (b == null) continue;
            return b;
        }
        return null;
    }

    @Nullable
    protected Block findLogRelatedBlock(String prefix, String ... possibleSuffix) {
        for (String n : possibleSuffix) {
            Block b = this.findLogWithAffix(prefix, n);
            if (b == null) continue;
            return b;
        }
        return null;
    }

    @Nullable
    protected Block findLogWithAffix(String prefix, String suffix) {
        if (this.id.m_135827_().matches("tfc|afc")) {
            Object prefix_ = prefix.isEmpty() ? "" : prefix + "_";
            Optional o = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(this.getNamespace(), "wood/" + (String)prefix_ + suffix + "/" + this.id.m_135815_()));
            if (o.isPresent()) {
                return (Block)o.get();
            }
        }
        List<ResourceLocation> targets = WoodType.makeKnownIDConventionsAffix(this.id.m_135827_(), this.id.m_135815_(), prefix, suffix, Utils.getID(this.log).m_135815_());
        return (Block)Utils.findFirstInRegistry(BuiltInRegistries.f_256975_, targets);
    }

    @NotNull
    private static List<ResourceLocation> makeKnownIDConventionsAffix(String myNamespace, String myPath, String prefixOrInfix, String suffix, @Nullable String alternateNamespace) {
        boolean noneEmpty = !prefixOrInfix.isEmpty() && !suffix.isEmpty();
        Object prefix_ = prefixOrInfix.isEmpty() ? "" : prefixOrInfix + "_";
        Object _infix = prefixOrInfix.isEmpty() ? "" : "_" + prefixOrInfix;
        Object _suffix = suffix.isEmpty() ? "" : "_" + prefixOrInfix;
        ArrayList<ResourceLocation> targets = new ArrayList<ResourceLocation>();
        targets.add(new ResourceLocation(myNamespace, myPath + (String)_infix + (String)_suffix));
        targets.add(new ResourceLocation(myNamespace, (String)prefix_ + myPath));
        if (alternateNamespace != null) {
            targets.add(new ResourceLocation(myNamespace, alternateNamespace + (String)_infix + (String)_suffix));
        }
        if (noneEmpty) {
            targets.add(new ResourceLocation(myNamespace, (String)prefix_ + myPath + (String)_suffix));
            if (alternateNamespace != null) {
                targets.add(new ResourceLocation(myNamespace, (String)prefix_ + alternateNamespace + (String)_suffix));
            }
        }
        if (myPath.endsWith(suffix)) {
            targets.add(new ResourceLocation(myNamespace, (String)prefix_ + myPath));
        }
        return targets;
    }

    static List<ResourceLocation> makeKnownIDConventions(ResourceLocation id, String ... affixKeyword) {
        String myPath = id.m_135815_();
        String myNamespace = id.m_135827_();
        ArrayList<ResourceLocation> possibleTargets = new ArrayList<ResourceLocation>();
        for (String affix : affixKeyword) {
            possibleTargets.addAll(WoodType.makeKnownIDConventionsAffix(myNamespace, myPath, "", affix, null));
            possibleTargets.addAll(WoodType.makeKnownIDConventionsAffix(myNamespace, myPath, affix, "", null));
        }
        return possibleTargets;
    }

    @Nullable
    static Block findLog(ResourceLocation id) {
        List<ResourceLocation> tests = WoodType.makeKnownIDConventions(id, "log", "stem", "stalk", "hyphae");
        return (Block)Utils.findFirstInRegistry(BuiltInRegistries.f_256975_, tests);
    }

    @Nullable
    static Block findPlanks(ResourceLocation id) {
        List<ResourceLocation> tests = WoodType.makeKnownIDConventions(id, "planks", "plank");
        return (Block)Utils.findFirstInRegistry(BuiltInRegistries.f_256975_, tests);
    }

    public BlockBehaviour.Properties copyProperties() {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.m_284310_();
        p.m_284180_(this.getColor());
        if (this.canBurn()) {
            p.m_278183_();
        }
        p.m_60918_(this.getSound());
        return p;
    }

    public static class Finder
    extends BlockType.SetFinderBuilder<WoodType> {
        private Supplier<Block> planksFinder;
        private Supplier<Block> logFinder;

        public Finder(ResourceLocation id) {
            super(id, WoodTypeRegistry.INSTANCE);
            this.log(() -> WoodType.findLog(id));
            this.planks(() -> WoodType.findPlanks(id));
        }

        public Finder planks(Supplier<Block> planksFinder) {
            this.planksFinder = planksFinder;
            return this;
        }

        public Finder planks(ResourceLocation id) {
            return this.planks(() -> (Block)BuiltInRegistries.f_256975_.m_6612_(id).orElseThrow(() -> new IllegalStateException("Failed to find planks block: " + String.valueOf(id))));
        }

        public Finder planks(String planksName) {
            return this.planks(Utils.idWithOptionalNamespace(planksName, this.id.m_135827_()));
        }

        public Finder planksAffix(String prefix, String suffix) {
            return this.planks(prefix + this.id.m_135815_() + suffix);
        }

        public Finder planksSuffix(String suffix) {
            return this.planks(this.id.m_135815_() + suffix);
        }

        public Finder log(Supplier<Block> logFinder) {
            this.logFinder = logFinder;
            return this;
        }

        public Finder log(ResourceLocation id) {
            return this.log(() -> (Block)BuiltInRegistries.f_256975_.m_6612_(id).orElseThrow(() -> new IllegalStateException("Failed to find log block: " + String.valueOf(id))));
        }

        public Finder log(String nameLog) {
            return this.log(Utils.idWithOptionalNamespace(nameLog, this.id.m_135827_()));
        }

        public Finder logAffix(String prefix, String suffix) {
            return this.log(prefix + this.id.m_135815_() + suffix);
        }

        public Finder logSuffix(String suffix) {
            return this.log(this.id.m_135815_() + suffix);
        }

        @Override
        @ApiStatus.Internal
        public Optional<WoodType> get() {
            if (PlatHelper.isModLoaded(this.id.m_135827_())) {
                try {
                    Block plank = (Block)Preconditions.checkNotNull((Object)this.planksFinder.get(), (String)"Manual Finder - failed to find a plank block for {}", (Object)this.id);
                    Block log = (Block)Preconditions.checkNotNull((Object)this.logFinder.get(), (String)"Manual Finder - failed to find a log block for {}", (Object)this.id);
                    WoodType woodType = new WoodType(this.id, plank, log);
                    this.childNames.forEach((key, value) -> {
                        try {
                            ItemLike obj = (ItemLike)Preconditions.checkNotNull((Object)((ItemLike)value.get()));
                            woodType.addChild((String)key, obj);
                        }
                        catch (Exception e) {
                            Moonlight.LOGGER.warn("Failed to find child for WoodType: {} - {}. Ignored! ERROR: {}", (Object)this.id, key, (Object)e.getMessage());
                        }
                    });
                    return Optional.of(woodType);
                }
                catch (Exception e) {
                    Moonlight.LOGGER.warn("Failed to find custom WoodType:  {} - ", (Object)this.id, (Object)e);
                }
            }
            return Optional.empty();
        }

        @Deprecated(forRemoval=true)
        public Finder(ResourceLocation id, Supplier<Block> planks, Supplier<Block> log) {
            super(id, WoodTypeRegistry.INSTANCE);
            this.planksFinder = planks;
            this.logFinder = log;
        }

        @Deprecated(forRemoval=true)
        public static Finder simple(String modId, String woodTypeName, String planksName, String logName) {
            return Finder.simple(new ResourceLocation(modId, woodTypeName), new ResourceLocation(modId, planksName), new ResourceLocation(modId, logName));
        }

        @Deprecated(forRemoval=true)
        public static Finder simple(ResourceLocation woodTypeName, ResourceLocation planksName, ResourceLocation logName) {
            return new Finder(woodTypeName, () -> (Block)BuiltInRegistries.f_256975_.m_7745_(planksName), () -> (Block)BuiltInRegistries.f_256975_.m_7745_(logName));
        }

        @Deprecated(forRemoval=true)
        public void addChild(String childType, String childName) {
            this.childBlock(childType, childName);
        }

        @Deprecated(forRemoval=true)
        public void addChild(String childType, ResourceLocation childName) {
            this.childBlock(childType, childName);
        }
    }
}

