/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientReloadShadersEvent;
import dev.architectury.event.events.client.ClientScreenInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.ftb.mods.ftbchunks.ColorMapLoader;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.api.client.FTBChunksClientAPI;
import dev.ftb.mods.ftbchunks.api.client.event.MapIconEvent;
import dev.ftb.mods.ftbchunks.api.client.icon.MapIcon;
import dev.ftb.mods.ftbchunks.api.client.icon.MapType;
import dev.ftb.mods.ftbchunks.api.client.icon.WaypointIcon;
import dev.ftb.mods.ftbchunks.api.client.minimap.MinimapContext;
import dev.ftb.mods.ftbchunks.api.client.minimap.MinimapInfoComponent;
import dev.ftb.mods.ftbchunks.api.client.waypoint.Waypoint;
import dev.ftb.mods.ftbchunks.client.ClientTaskQueue;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientAPIImpl;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.FTBChunksRenderTypes;
import dev.ftb.mods.ftbchunks.client.MinimapBlurMode;
import dev.ftb.mods.ftbchunks.client.MinimapPosition;
import dev.ftb.mods.ftbchunks.client.VisibleClientPlayers;
import dev.ftb.mods.ftbchunks.client.forge.FTBChunksClientImpl;
import dev.ftb.mods.ftbchunks.client.gui.AddWaypointOverlay;
import dev.ftb.mods.ftbchunks.client.gui.ChunkScreen;
import dev.ftb.mods.ftbchunks.client.gui.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.gui.PointerIcon;
import dev.ftb.mods.ftbchunks.client.gui.WaypointEditorScreen;
import dev.ftb.mods.ftbchunks.client.map.ChunkUpdateTask;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.client.map.RegionSyncKey;
import dev.ftb.mods.ftbchunks.client.map.UpdateChunkFromServerTask;
import dev.ftb.mods.ftbchunks.client.map.WaypointImpl;
import dev.ftb.mods.ftbchunks.client.map.WaypointManagerImpl;
import dev.ftb.mods.ftbchunks.client.map.WaypointType;
import dev.ftb.mods.ftbchunks.client.map.color.ColorUtils;
import dev.ftb.mods.ftbchunks.client.mapicon.EntityIcons;
import dev.ftb.mods.ftbchunks.client.mapicon.EntityMapIcon;
import dev.ftb.mods.ftbchunks.client.mapicon.InWorldMapIcon;
import dev.ftb.mods.ftbchunks.client.mapicon.MapIconComparator;
import dev.ftb.mods.ftbchunks.client.mapicon.TrackedPlayerMapIcon;
import dev.ftb.mods.ftbchunks.client.minimap.components.BiomeComponent;
import dev.ftb.mods.ftbchunks.client.minimap.components.DebugComponent;
import dev.ftb.mods.ftbchunks.client.minimap.components.FPSComponent;
import dev.ftb.mods.ftbchunks.client.minimap.components.GameTimeComponent;
import dev.ftb.mods.ftbchunks.client.minimap.components.PlayerPosInfoComponent;
import dev.ftb.mods.ftbchunks.client.minimap.components.RealTimeComponent;
import dev.ftb.mods.ftbchunks.client.minimap.components.ZoneInfoComponent;
import dev.ftb.mods.ftbchunks.net.PartialPackets;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.config.ColorConfig;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.ModalPanel;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftbteams.api.event.ClientTeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public enum FTBChunksClient {
    INSTANCE;

    public static final ExecutorService MAP_EXECUTOR;
    private static final ResourceLocation BUTTON_ID_MAP;
    private static final ResourceLocation BUTTON_ID_CLAIM;
    public static final ResourceLocation CIRCLE_MASK;
    public static final ResourceLocation CIRCLE_BORDER;
    public static final ResourceLocation SQUARE_MASK;
    public static final ResourceLocation SQUARE_BORDER;
    public static final ResourceLocation PLAYER;
    public static final ResourceLocation[] COMPASS;
    public KeyMapping openMapKey;
    public KeyMapping toggleMinimapKey;
    public KeyMapping openClaimManagerKey;
    public KeyMapping zoomInKey;
    public KeyMapping zoomOutKey;
    public KeyMapping addWaypointKey;
    public KeyMapping waypointManagerKey;
    private final Map<UUID, TrackedPlayerMapIcon> longRangePlayerTracker = new HashMap<UUID, TrackedPlayerMapIcon>();
    private long taskQueueTicks = 0L;
    private final Map<ChunkPos, IntOpenHashSet> rerenderCache = new HashMap<ChunkPos, IntOpenHashSet>();
    private int minimapTextureId = -1;
    private int currentPlayerChunkX;
    private int currentPlayerChunkZ;
    private double currentPlayerX;
    private double currentPlayerY;
    private double currentPlayerZ;
    private double prevPlayerX;
    private double prevPlayerY;
    private double prevPlayerZ;
    private int renderedDebugCount = 0;
    private boolean updateMinimapScheduled = false;
    private SendGeneralDataPacket.GeneralChunkData generalChunkData;
    private long nextRegionSave = 0L;
    private double prevZoom = (Double)FTBChunksClientConfig.MINIMAP_ZOOM.get();
    private long lastZoomTime = 0L;
    private final List<MapIcon> mapIcons = new ArrayList<MapIcon>();
    private final List<InWorldMapIcon> inWorldMapIcons = new ArrayList<InWorldMapIcon>();
    private long lastMapIconUpdate = 0L;
    private Matrix4f worldMatrix;
    private Vec3 cameraPos;
    private final List<MinimapInfoComponent> sortedComponents = new LinkedList<MinimapInfoComponent>();
    private static double vanillaEffectsOffsetX;

    public void init() {
        if (Minecraft.m_91087_() == null) {
            return;
        }
        FTBChunksAPI._initClient(new FTBChunksClientAPIImpl());
        FTBChunksClientConfig.init();
        this.registerKeys();
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new EntityIcons());
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new ColorMapLoader());
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(this::loggedOut);
        CustomClickEvent.EVENT.register(this::customClick);
        ClientRawInputEvent.KEY_PRESSED.register(this::keyPressed);
        ClientScreenInputEvent.KEY_PRESSED_PRE.register(this::keyPressed);
        ClientGuiEvent.RENDER_HUD.register(this::renderHud);
        ClientGuiEvent.INIT_PRE.register(this::screenOpened);
        ClientTickEvent.CLIENT_PRE.register(this::clientTick);
        TeamEvent.CLIENT_PROPERTIES_CHANGED.register(this::teamPropertiesChanged);
        MapIconEvent.LARGE_MAP.register(this::mapIcons);
        MapIconEvent.MINIMAP.register(this::mapIcons);
        ClientReloadShadersEvent.EVENT.register(this::reloadShaders);
        FTBChunksClient.registerPlatform();
        FTBChunksClientAPI clientApi = FTBChunksAPI.clientApi();
        clientApi.registerMinimapComponent(new PlayerPosInfoComponent());
        clientApi.registerMinimapComponent(new ZoneInfoComponent());
        clientApi.registerMinimapComponent(new BiomeComponent());
        clientApi.registerMinimapComponent(new GameTimeComponent());
        clientApi.registerMinimapComponent(new RealTimeComponent());
        clientApi.registerMinimapComponent(new FPSComponent());
        clientApi.registerMinimapComponent(new DebugComponent());
        ClientLifecycleEvent.CLIENT_STARTED.register(this::clientStarted);
    }

    private void clientStarted(Minecraft minecraft) {
        this.setupComponents();
    }

    private void registerKeys() {
        this.openMapKey = new KeyMapping("key.ftbchunks.map", InputConstants.Type.KEYSYM, 77, "key.categories.ftbchunks");
        KeyMappingRegistry.register((KeyMapping)this.openMapKey);
        this.toggleMinimapKey = new KeyMapping("key.ftbchunks.toggle_minimap", InputConstants.Type.KEYSYM, -1, "key.categories.ftbchunks");
        KeyMappingRegistry.register((KeyMapping)this.toggleMinimapKey);
        this.openClaimManagerKey = new KeyMapping("key.ftbchunks.claim_manager", InputConstants.Type.KEYSYM, -1, "key.categories.ftbchunks");
        KeyMappingRegistry.register((KeyMapping)this.openClaimManagerKey);
        this.zoomInKey = new KeyMapping("key.ftbchunks.minimap.zoomIn", InputConstants.Type.KEYSYM, 61, "key.categories.ftbchunks");
        KeyMappingRegistry.register((KeyMapping)this.zoomInKey);
        this.zoomOutKey = new KeyMapping("key.ftbchunks.minimap.zoomOut", InputConstants.Type.KEYSYM, 45, "key.categories.ftbchunks");
        KeyMappingRegistry.register((KeyMapping)this.zoomOutKey);
        this.addWaypointKey = new KeyMapping("key.ftbchunks.add_waypoint", InputConstants.Type.KEYSYM, -1, "key.categories.ftbchunks");
        KeyMappingRegistry.register((KeyMapping)this.addWaypointKey);
        this.waypointManagerKey = new KeyMapping("key.ftbchunks.waypoint_manager", InputConstants.Type.KEYSYM, -1, "key.categories.ftbchunks");
        KeyMappingRegistry.register((KeyMapping)this.waypointManagerKey);
    }

    public Set<ChunkPos> getPendingRerender() {
        return this.rerenderCache.keySet();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerPlatform() {
        FTBChunksClientImpl.registerPlatform();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean doesKeybindMatch(KeyMapping keyMapping, int keyCode, int scanCode, int modifiers) {
        void var3_3;
        void var2_2;
        void var1_1;
        return FTBChunksClientImpl.doesKeybindMatch(keyMapping, (int)var1_1, (int)var2_2, (int)var3_3);
    }

    public static boolean doesKeybindMatch(KeyMapping keyMapping, Key key) {
        return FTBChunksClient.doesKeybindMatch(keyMapping, key.keyCode, key.scanCode, key.modifiers.modifiers);
    }

    public void openGui() {
        LargeMapScreen.openMap();
    }

    public void scheduleMinimapUpdate() {
        this.updateMinimapScheduled = true;
    }

    public void handlePlayerLogin(UUID serverId, SNBTCompoundTag config) {
        FTBChunks.LOGGER.info("Loading FTB Chunks client data from world {}", (Object)serverId);
        FTBChunksWorldConfig.CONFIG.read(config);
        MapManager.startUp(serverId);
        this.scheduleMinimapUpdate();
        this.renderedDebugCount = 0;
        ChunkUpdateTask.init();
    }

    public void loggedOut(@Nullable LocalPlayer player) {
        MapManager.shutdown();
    }

    public void updateGeneralData(SendGeneralDataPacket.GeneralChunkData chunkData) {
        this.generalChunkData = chunkData;
    }

    public void updateChunksFromServer(ResourceKey<Level> dimId, UUID teamId, Collection<SendChunkPacket.SingleChunk> chunks) {
        MapManager.getInstance().ifPresent(manager -> {
            MapDimension dimension = manager.getDimension(dimId);
            Date now = new Date();
            chunks.forEach(c -> ClientTaskQueue.queue(new UpdateChunkFromServerTask(dimension, (SendChunkPacket.SingleChunk)c, teamId, now)));
        });
    }

    public void syncRegionFromServer(RegionSyncKey key, int offset, int total, byte[] data) {
        PartialPackets.REGION.read(key, offset, total, data);
    }

    public void handlePlayerDeath(GlobalPos pos, int deathNumber) {
        if (((Boolean)FTBChunksClientConfig.DEATH_WAYPOINTS.get()).booleanValue() && FTBChunksWorldConfig.playerHasMapStage((Player)Minecraft.m_91087_().f_91074_)) {
            MapManager.getInstance().ifPresent(manager -> {
                MapDimension dimension = manager.getDimension((ResourceKey<Level>)pos.m_122640_());
                for (WaypointImpl w : dimension.getWaypointManager()) {
                    if (!w.isDeathpoint()) continue;
                    w.setHidden(true);
                    w.refreshIcon();
                }
                WaypointImpl deathPoint = new WaypointImpl(WaypointType.DEATH, dimension, pos.m_122646_()).setName("Death #" + deathNumber).setColor(0xFF0000);
                dimension.getWaypointManager().add(deathPoint);
            });
        }
    }

    public void handleBlockColorRequest() {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_18707_(() -> {
            mc.m_91152_(null);
            new Thread(() -> {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                mc.m_18707_(() -> {
                    HitResult patt13309$temp = mc.f_91077_;
                    if (patt13309$temp instanceof BlockHitResult) {
                        BlockHitResult hitResult = (BlockHitResult)patt13309$temp;
                        if (mc.f_91073_ != null && mc.f_91074_ != null) {
                            ResourceLocation id = FTBChunks.BLOCK_REGISTRY.getId((Object)mc.f_91073_.m_8055_(hitResult.m_82425_()).m_60734_());
                            Window window = mc.m_91268_();
                            try (NativeImage image = Screenshot.m_92279_((RenderTarget)mc.m_91385_());){
                                int col = image.m_84985_(image.m_84982_() / 2 - (int)(2.0 * window.m_85449_()), image.m_85084_() / 2 - (int)(2.0 * window.m_85449_()));
                                String s = String.format("\"%s\": \"#%06X\"", id.m_135815_(), ColorUtils.convertFromNative(col) & 0xFFFFFF);
                                mc.f_91074_.m_5661_((Component)Component.m_237113_((String)(id.m_135827_() + " - " + s)).m_130948_(Style.f_131099_.m_131157_(ChatFormatting.GOLD).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, s)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to copy")))), false);
                            }
                        }
                    }
                });
            }, "Color getter").start();
        });
    }

    public void syncLoadedChunkViewFromServer(ResourceKey<Level> dimension, Long2IntMap chunks) {
        MapManager.getInstance().ifPresent(manager -> {
            manager.getDimension(dimension).updateLoadedChunkView(chunks);
            manager.updateAllRegions(false);
        });
    }

    public boolean skipBlock(BlockState state) {
        ResourceLocation id = FTBChunks.BLOCK_REGISTRY.getId((Object)state.m_60734_());
        return id == null || ColorMapLoader.getBlockColor(id).isIgnored();
    }

    public EventResult customClick(CustomClickEvent event) {
        if (FTBChunksWorldConfig.playerHasMapStage((Player)Minecraft.m_91087_().f_91074_)) {
            if (event.id().equals((Object)BUTTON_ID_MAP)) {
                this.openGui();
                return EventResult.interruptTrue();
            }
            if (event.id().equals((Object)BUTTON_ID_CLAIM)) {
                ChunkScreen.openChunkScreen();
                return EventResult.interruptTrue();
            }
        }
        return EventResult.pass();
    }

    public EventResult keyPressed(Minecraft client, int keyCode, int scanCode, int action, int modifiers) {
        if (action != 1 || client.f_91080_ != null || !FTBChunksWorldConfig.playerHasMapStage((Player)client.f_91074_) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)292)) {
            return EventResult.pass();
        }
        if (FTBChunksClient.doesKeybindMatch(this.openMapKey, keyCode, scanCode, modifiers)) {
            this.openGui();
            return EventResult.interruptTrue();
        }
        if (FTBChunksClient.doesKeybindMatch(this.toggleMinimapKey, keyCode, scanCode, modifiers)) {
            FTBChunksClientConfig.MINIMAP_ENABLED.set((Object)((Boolean)FTBChunksClientConfig.MINIMAP_ENABLED.get() == false ? 1 : 0));
            FTBChunksClientConfig.saveConfig();
            return EventResult.interruptTrue();
        }
        if (FTBChunksClient.doesKeybindMatch(this.openClaimManagerKey, keyCode, scanCode, modifiers)) {
            ChunkScreen.openChunkScreen();
            return EventResult.interruptTrue();
        }
        if (FTBChunksClient.doesKeybindMatch(this.zoomInKey, keyCode, scanCode, modifiers)) {
            return this.changeZoom(true);
        }
        if (FTBChunksClient.doesKeybindMatch(this.zoomOutKey, keyCode, scanCode, modifiers)) {
            return this.changeZoom(false);
        }
        if (FTBChunksClient.doesKeybindMatch(this.addWaypointKey, keyCode, scanCode, modifiers)) {
            return this.addQuickWaypoint();
        }
        if (FTBChunksClient.doesKeybindMatch(this.waypointManagerKey, keyCode, scanCode, modifiers)) {
            new WaypointEditorScreen().openGui();
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    public EventResult keyPressed(Minecraft client, Screen screen, int keyCode, int scanCode, int modifiers) {
        LargeMapScreen gui;
        if (FTBChunksClient.doesKeybindMatch(this.openMapKey, keyCode, scanCode, modifiers) && Platform.isFabric() && (gui = (LargeMapScreen)((Object)ClientUtils.getCurrentGuiAs(LargeMapScreen.class))) != null && !gui.anyModalPanelOpen()) {
            gui.closeGui(false);
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    private EventResult addQuickWaypoint() {
        StringConfig name = new StringConfig();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return EventResult.pass();
        }
        return MapManager.getInstance().map(arg_0 -> FTBChunksClient.lambda$addQuickWaypoint$7(name, (Player)player, arg_0)).orElse(EventResult.pass());
    }

    private EventResult changeZoom(boolean zoomIn) {
        double zoomFactor;
        double zoom = this.prevZoom = ((Double)FTBChunksClientConfig.MINIMAP_ZOOM.get()).doubleValue();
        double d = zoomFactor = zoomIn ? 1.0 : -1.0;
        zoom = zoom + zoomFactor > 4.0 ? 4.0 : (zoom + zoomFactor < 1.0 ? 1.0 : (zoom += zoomFactor));
        this.lastZoomTime = System.currentTimeMillis();
        FTBChunksClientConfig.MINIMAP_ZOOM.set(Double.valueOf(zoom));
        return EventResult.interruptTrue();
    }

    private static long clamp(long val, long min, long max) {
        return Math.min(Math.max(val, min), max);
    }

    public float getZoom() {
        double z = (Double)FTBChunksClientConfig.MINIMAP_ZOOM.get();
        if (this.prevZoom != z) {
            long max = (long)(400.0 / z);
            long t = FTBChunksClient.clamp(System.currentTimeMillis() - this.lastZoomTime, 0L, max);
            if (t == max) {
                this.lastZoomTime = 0L;
                return (float)z;
            }
            return (float)Mth.m_14139_((double)((double)t / (double)max), (double)this.prevZoom, (double)z);
        }
        return (float)z;
    }

    public int generateTextureId(int w, int h) {
        int textureId = TextureUtil.generateTextureId();
        TextureUtil.prepareImage((int)textureId, (int)w, (int)h);
        return textureId;
    }

    public void renderHud(GuiGraphics graphics, float tickDelta) {
        float scale;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null || MapManager.getInstance().isEmpty() || MapDimension.getCurrent().isEmpty()) {
            return;
        }
        double playerX = Mth.m_14139_((double)tickDelta, (double)this.prevPlayerX, (double)this.currentPlayerX);
        double playerY = Mth.m_14139_((double)tickDelta, (double)this.prevPlayerY, (double)this.currentPlayerY);
        double playerZ = Mth.m_14139_((double)tickDelta, (double)this.prevPlayerZ, (double)this.currentPlayerZ);
        double guiScale = mc.m_91268_().m_85449_();
        int scaledWidth = mc.m_91268_().m_85445_();
        int scaledHeight = mc.m_91268_().m_85446_();
        MapDimension dim = MapDimension.getCurrent().get();
        if (dim.dimension != mc.f_91073_.m_46472_()) {
            MapDimension.clearCurrentDimension();
            dim = MapDimension.getCurrent().orElseThrow();
            this.longRangePlayerTracker.clear();
        }
        long now = System.currentTimeMillis();
        if (this.nextRegionSave == 0L || now >= this.nextRegionSave) {
            this.nextRegionSave = now + 60000L;
            MapManager.getInstance().ifPresent(MapManager::saveAllRegions);
        }
        if (this.minimapTextureId == -1) {
            this.minimapTextureId = this.generateTextureId(240, 240);
            this.scheduleMinimapUpdate();
        }
        float zoom0 = this.getZoom();
        float zoom = zoom0 / 3.5f;
        MinimapBlurMode blurMode = (MinimapBlurMode)((Object)FTBChunksClientConfig.MINIMAP_BLUR_MODE.get());
        boolean minimapBlur = blurMode == MinimapBlurMode.AUTO ? zoom0 < 1.5f : blurMode == MinimapBlurMode.ON;
        int filter = minimapBlur ? 9729 : 9728;
        RenderSystem.bindTextureForSetup((int)this.minimapTextureId);
        RenderSystem.texParameter((int)3553, (int)10241, (int)filter);
        RenderSystem.texParameter((int)3553, (int)10240, (int)filter);
        int cx = Mth.m_14107_((double)playerX) >> 4;
        int cz = Mth.m_14107_((double)playerZ) >> 4;
        if (cx != this.currentPlayerChunkX || cz != this.currentPlayerChunkZ) {
            this.scheduleMinimapUpdate();
        }
        if (this.updateMinimapScheduled) {
            this.updateMinimapScheduled = false;
            for (int mz = 0; mz < 15; ++mz) {
                for (int mx = 0; mx < 15; ++mx) {
                    int ox = cx + mx - 7;
                    int oz = cz + mz - 7;
                    MapRegion region = dim.getRegion(XZ.regionFromChunk((int)ox, (int)oz));
                    region.getRenderedMapImage().m_85013_(0, mx * 16, mz * 16, (ox & 0x1F) * 16, (oz & 0x1F) * 16, 16, 16, minimapBlur, false, false, false);
                }
            }
            this.currentPlayerChunkX = cx;
            this.currentPlayerChunkZ = cz;
        }
        if (mc.f_91066_.f_92063_ || !((Boolean)FTBChunksClientConfig.MINIMAP_ENABLED.get()).booleanValue() || (Integer)FTBChunksClientConfig.MINIMAP_VISIBILITY.get() == 0 || !FTBChunksWorldConfig.shouldShowMinimap((Player)mc.f_91074_)) {
            return;
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_PROPORTIONAL.get()).booleanValue()) {
            scale = (float)(4.0 / guiScale);
            scale = (float)((double)scale * ((double)((float)scaledWidth / 10.0f) / ((double)scale * 64.0) * (Double)FTBChunksClientConfig.MINIMAP_SCALE.get()));
        } else {
            scale = (float)((Double)FTBChunksClientConfig.MINIMAP_SCALE.get() * 4.0 / guiScale);
        }
        boolean rotationLocked = (Boolean)FTBChunksClientConfig.MINIMAP_LOCKED_NORTH.get() != false || (Boolean)FTBChunksClientConfig.SQUARE_MINIMAP.get() != false;
        float minimapRotation = (rotationLocked ? 180.0f : -mc.f_91074_.m_146908_()) % 360.0f;
        int size = (int)(64.0 * (double)scale);
        double halfSizeD = (double)size / 2.0;
        float halfSizeF = (float)size / 2.0f;
        MinimapPosition minimapPosition = (MinimapPosition)((Object)FTBChunksClientConfig.MINIMAP_POSITION.get());
        int x = minimapPosition.getX(scaledWidth, size);
        int y = minimapPosition.getY(scaledHeight, size);
        int offsetX = (Integer)FTBChunksClientConfig.MINIMAP_OFFSET_X.get();
        int offsetY = (Integer)FTBChunksClientConfig.MINIMAP_OFFSET_Y.get();
        MinimapPosition.MinimapOffsetConditional offsetConditional = (MinimapPosition.MinimapOffsetConditional)FTBChunksClientConfig.MINIMAP_POSITION_OFFSET_CONDITION.get();
        if (offsetConditional.test(minimapPosition)) {
            x += minimapPosition.posX == 0 ? offsetX : -offsetX;
            y -= minimapPosition.posY > 1 ? offsetY : -offsetY;
        }
        vanillaEffectsOffsetX = !mc.f_91074_.m_21220_().isEmpty() && y <= 50 && x + size > scaledWidth - 50 ? (double)(-(scaledWidth - x) - 5) : 0.0;
        float border = 0.0f;
        int alpha = (Integer)FTBChunksClientConfig.MINIMAP_VISIBILITY.get();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.enableDepthTest();
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)x + halfSizeD, (double)y + halfSizeD, 490.0);
        Matrix4f m = poseStack.m_85850_().m_252922_();
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)((Boolean)FTBChunksClientConfig.SQUARE_MINIMAP.get() != false ? SQUARE_MASK : CIRCLE_MASK));
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        buffer.m_252986_(m, -halfSizeF + border, -halfSizeF + border, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, -halfSizeF + border, halfSizeF - border, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_252986_(m, halfSizeF - border, halfSizeF - border, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(m, halfSizeF - border, -halfSizeF + border, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_5752_();
        tessellator.m_85914_();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(minimapRotation + 180.0f));
        RenderSystem.depthFunc((int)518);
        float halfSizeBorderF = halfSizeF - border;
        float offX = 0.5f + (float)((MathUtils.mod((double)playerX, (double)16.0) / 16.0 - 0.5) / 15.0);
        float offZ = 0.5f + (float)((MathUtils.mod((double)playerZ, (double)16.0) / 16.0 - 0.5) / 15.0);
        float zws = 2.0f / (15.0f * zoom);
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.setShaderTexture((int)0, (int)this.minimapTextureId);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        buffer.m_252986_(m, -halfSizeBorderF, -halfSizeBorderF, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(offX - zws, offZ - zws).m_5752_();
        buffer.m_252986_(m, -halfSizeBorderF, halfSizeBorderF, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(offX - zws, offZ + zws).m_5752_();
        buffer.m_252986_(m, halfSizeBorderF, halfSizeBorderF, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(offX + zws, offZ + zws).m_5752_();
        buffer.m_252986_(m, halfSizeBorderF, -halfSizeBorderF, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(offX + zws, offZ - zws).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)((Boolean)FTBChunksClientConfig.SQUARE_MINIMAP.get() != false ? SQUARE_BORDER : CIRCLE_BORDER));
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        buffer.m_252986_(m, -halfSizeF, -halfSizeF, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, -halfSizeF, halfSizeF, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_252986_(m, halfSizeF, halfSizeF, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(m, halfSizeF, -halfSizeF, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(1.0f, 0.0f).m_5752_();
        tessellator.m_85914_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(m, -halfSizeF, 0.0f, 0.0f).m_6122_(0, 0, 0, 30).m_5752_();
        buffer.m_252986_(m, halfSizeF, 0.0f, 0.0f).m_6122_(0, 0, 0, 30).m_5752_();
        buffer.m_252986_(m, 0.0f, -halfSizeF, 0.0f).m_6122_(0, 0, 0, 30).m_5752_();
        buffer.m_252986_(m, 0.0f, halfSizeF, 0.0f).m_6122_(0, 0, 0, 30).m_5752_();
        tessellator.m_85914_();
        poseStack.m_85849_();
        m = poseStack.m_85850_().m_252922_();
        if (((Boolean)FTBChunksClientConfig.MINIMAP_COMPASS.get()).booleanValue()) {
            this.drawMinimapCompassPoints(minimapRotation, size, halfSizeD, x, y, tessellator, buffer, m);
        }
        if (this.lastMapIconUpdate == 0L || now - this.lastMapIconUpdate >= (long)((Integer)FTBChunksClientConfig.MINIMAP_ICON_UPDATE_TIMER.get()).intValue()) {
            this.lastMapIconUpdate = now;
            this.mapIcons.clear();
            ((Consumer)MapIconEvent.MINIMAP.invoker()).accept(new MapIconEvent(dim.dimension, this.mapIcons, MapType.MINIMAP));
            if (this.mapIcons.size() >= 2) {
                this.mapIcons.sort(new MapIconComparator(mc.f_91074_.m_20182_(), tickDelta));
            }
        }
        for (MapIcon icon : this.mapIcons) {
            double distance;
            Vec3 pos = icon.getPos(tickDelta);
            double d = (distance = MathUtils.dist((double)playerX, (double)playerZ, (double)pos.f_82479_, (double)pos.f_82481_)) * (double)scale * (double)zoom;
            if (!icon.isVisible(MapType.MINIMAP, distance, d > halfSizeD)) continue;
            if (d > halfSizeD) {
                d = halfSizeD;
            }
            double angle = Math.atan2(playerZ - pos.f_82481_, playerX - pos.f_82479_) + (double)minimapRotation * Math.PI / 180.0;
            double ws = (double)size / (32.0 / icon.getIconScale(MapType.MINIMAP));
            double wx = (double)x + halfSizeD + Math.cos(angle) * d;
            double wy = (double)y + halfSizeD + Math.sin(angle) * d;
            float wsf = (float)(ws * 2.0);
            poseStack.m_85836_();
            poseStack.m_85837_(wx - ws, wy - ws - (icon.isIconOnEdge(MapType.MINIMAP, d >= halfSizeD) ? ws / 2.0 : 0.0), 0.0);
            poseStack.m_85841_(wsf, wsf, 1.0f);
            icon.draw(MapType.MINIMAP, graphics, 0, 0, 1, 1, d >= halfSizeD, 255);
            poseStack.m_85849_();
        }
        if (rotationLocked || ((Boolean)FTBChunksClientConfig.SHOW_PLAYER_WHEN_UNLOCKED.get()).booleanValue()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)PLAYER);
            poseStack.m_85836_();
            poseStack.m_85837_((double)x + halfSizeD, (double)y + halfSizeD, 0.0);
            if (rotationLocked) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(mc.f_91074_.m_146908_() + 180.0f));
            }
            poseStack.m_85841_((float)size / 16.0f, (float)size / 16.0f, 1.0f);
            m = poseStack.m_85850_().m_252922_();
            RenderSystem.setShader(GameRenderer::m_172814_);
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
            buffer.m_252986_(m, -1.0f, -1.0f, 0.0f).m_6122_(255, 255, 255, 200).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(m, -1.0f, 1.0f, 0.0f).m_6122_(255, 255, 255, 200).m_7421_(0.0f, 1.0f).m_5752_();
            buffer.m_252986_(m, 1.0f, 1.0f, 0.0f).m_6122_(255, 255, 255, 200).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_252986_(m, 1.0f, -1.0f, 0.0f).m_6122_(255, 255, 255, 200).m_7421_(1.0f, 0.0f).m_5752_();
            tessellator.m_85914_();
            poseStack.m_85849_();
        }
        MinimapContext context = new MinimapContext(mc, mc.f_91074_, dim, XZ.of((int)this.currentPlayerChunkX, (int)this.currentPlayerChunkZ), new Vec3(playerX, playerY, playerZ), (Map)FTBChunksClientConfig.MINIMAP_SETTINGS.get());
        float fontScale = ((Double)FTBChunksClientConfig.MINIMAP_FONT_SCALE.get()).floatValue();
        int yOffset = 0;
        for (MinimapInfoComponent component : this.sortedComponents) {
            if (!component.shouldRender(context)) continue;
            int height = component.height(context);
            boolean isBottom = y + size + height >= scaledHeight;
            float yOff = isBottom ? (float)(-height - yOffset) : (float)size + 2.0f + (float)yOffset;
            poseStack.m_85836_();
            poseStack.m_85837_((double)x + halfSizeD, (double)((float)y + yOff), 0.0);
            poseStack.m_85841_(fontScale, fontScale, 1.0f);
            component.render(context, graphics, mc.f_91062_);
            poseStack.m_85849_();
            yOffset += height;
        }
        RenderSystem.enableDepthTest();
        if (this.worldMatrix != null && ((Boolean)FTBChunksClientConfig.IN_WORLD_WAYPOINTS.get()).booleanValue()) {
            this.drawInWorldIcons(mc, graphics, tickDelta, playerX, playerY, playerZ, scaledWidth, scaledHeight);
        }
    }

    private void drawMinimapCompassPoints(float minimapRotation, int size, double halfSizeD, int minimapX, int minimapY, Tesselator tessellator, BufferBuilder buffer, Matrix4f m) {
        double d = (double)size / 2.2;
        float ws = (float)size / 32.0f;
        for (int face = 0; face < 4; ++face) {
            double angle = ((double)minimapRotation + 180.0 - (double)face * 90.0) * Math.PI / 180.0;
            float wx = (float)((double)minimapX + halfSizeD + Math.cos(angle) * d);
            float wy = (float)((double)minimapY + halfSizeD + Math.sin(angle) * d);
            RenderSystem.setShader(GameRenderer::m_172814_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)COMPASS[face]);
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
            buffer.m_252986_(m, wx - ws, wy - ws, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(m, wx - ws, wy + ws, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_5752_();
            buffer.m_252986_(m, wx + ws, wy + ws, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_252986_(m, wx + ws, wy - ws, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_5752_();
            tessellator.m_85914_();
        }
    }

    private void drawInWorldIcons(Minecraft mc, GuiGraphics graphics, float tickDelta, double playerX, double playerY, double playerZ, int scaledWidth, int scaledHeight) {
        GuiHelper.setupDrawing();
        float ww2 = (float)scaledWidth / 2.0f;
        float wh2 = (float)scaledHeight / 2.0f;
        InWorldMapIcon focusedIcon = null;
        for (MapIcon icon : this.mapIcons) {
            Vec3 pos = icon.getPos(tickDelta);
            double playerDist = MathUtils.dist((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_, (double)playerX, (double)playerY, (double)playerZ);
            if (!icon.isVisible(MapType.WORLD_ICON, playerDist, false)) continue;
            Vector4f v = new Vector4f((float)(pos.f_82479_ - this.cameraPos.f_82479_), (float)(pos.f_82480_ - this.cameraPos.f_82480_), (float)(pos.f_82481_ - this.cameraPos.f_82481_), 1.0f);
            double lookAngle = mc.f_91074_.m_20154_().m_82526_(new Vec3((double)v.x(), (double)v.y(), (double)v.z()).m_82541_());
            if (!(lookAngle > 0.0)) continue;
            this.worldMatrix.transform(v);
            v.div(v.w());
            float ix = ww2 + v.x() * ww2;
            float iy = wh2 - v.y() * wh2;
            double mouseDist = MathUtils.dist((double)ix, (double)iy, (double)ww2, (double)wh2);
            InWorldMapIcon inWorldMapIcon = new InWorldMapIcon(icon, ix, iy, playerDist, mouseDist);
            if (mouseDist <= 5.0 * (Double)FTBChunksClientConfig.WAYPOINT_FOCUS_DISTANCE.get() && (focusedIcon == null || focusedIcon.distanceToMouse() > mouseDist)) {
                focusedIcon = inWorldMapIcon;
            }
            this.inWorldMapIcons.add(inWorldMapIcon);
        }
        double fadeStart = (Double)FTBChunksClientConfig.WAYPOINT_DOT_FADE_DISTANCE.get();
        double fadeMin = fadeStart * 2.0 / 3.0;
        for (InWorldMapIcon icon : this.inWorldMapIcons) {
            if (!(icon.distanceToPlayer() > fadeMin)) continue;
            int iconAlpha = icon.distanceToPlayer() < fadeStart ? (int)(255.0 * ((icon.distanceToPlayer() - fadeMin) / (fadeStart - fadeMin))) : 255;
            float minSize = 0.25f;
            float maxSize = (float)((double)minSize * (Double)FTBChunksClientConfig.WAYPOINT_FOCUS_SCALE.get());
            if (iconAlpha <= 0) continue;
            float iconScale = Mth.m_14179_((float)((50.0f - Math.min((float)icon.distanceToMouse(), 50.0f)) / 50.0f), (float)minSize, (float)maxSize);
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_(icon.x(), icon.y(), icon == focusedIcon ? 50.0f : -100.0f);
            poseStack.m_85841_(iconScale, iconScale, 1.0f);
            icon.icon().draw(MapType.WORLD_ICON, graphics, -8, -8, 16, 16, icon != focusedIcon, iconAlpha);
            poseStack.m_85849_();
        }
        this.inWorldMapIcons.clear();
    }

    public void renderWorldLast(PoseStack poseStack, Matrix4f projectionMatrix, Camera camera, float tickDelta) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || MapManager.getInstance().isEmpty() || mc.f_91073_ == null || mc.f_91074_ == null || MapDimension.getCurrent().isEmpty() || !FTBChunksWorldConfig.playerHasMapStage((Player)mc.f_91074_)) {
            return;
        }
        this.worldMatrix = new Matrix4f((Matrix4fc)projectionMatrix);
        this.worldMatrix.mul((Matrix4fc)poseStack.m_85850_().m_252922_());
        this.cameraPos = camera.m_90583_();
        if (!((Boolean)FTBChunksClientConfig.IN_WORLD_WAYPOINTS.get()).booleanValue()) {
            return;
        }
        List<WaypointIcon> visibleWaypoints = this.findVisibleWaypoints((Player)mc.f_91074_, tickDelta);
        if (visibleWaypoints.isEmpty()) {
            return;
        }
        Vec3 cameraPos = camera.m_90583_();
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        VertexConsumer depthBuffer = mc.m_91269_().m_110104_().m_6299_(FTBChunksRenderTypes.WAYPOINTS_DEPTH);
        float y1 = (float)(cameraPos.f_82480_ + 30.0);
        float y2 = y1 + 70.0f;
        int yMin = mc.f_91073_.m_141937_();
        for (WaypointIcon waypoint : visibleWaypoints) {
            FTBChunksClient.drawWaypointBeacon(poseStack, cameraPos, depthBuffer, y1, y2, yMin, waypoint);
        }
        poseStack.m_85849_();
        mc.m_91269_().m_110104_().m_109912_(FTBChunksRenderTypes.WAYPOINTS_DEPTH);
    }

    private static void drawWaypointBeacon(PoseStack poseStack, Vec3 cameraPos, VertexConsumer depthBuffer, float y1, float y2, int yMin, WaypointIcon waypoint) {
        Vec3 pos = waypoint.getPos(1.0f);
        int alpha = waypoint.getAlpha();
        double angle = Math.atan2(cameraPos.f_82481_ - pos.f_82481_, cameraPos.f_82479_ - pos.f_82479_) * 180.0 / Math.PI;
        int r = waypoint.getColor().redi();
        int g = waypoint.getColor().greeni();
        int b = waypoint.getColor().bluei();
        poseStack.m_85836_();
        poseStack.m_85837_(pos.f_82479_, 0.0, pos.f_82481_);
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)(-angle - 135.0)));
        float s = 0.6f;
        Matrix4f m = poseStack.m_85850_().m_252922_();
        depthBuffer.m_252986_(m, -s, (float)yMin, s).m_6122_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_5752_();
        depthBuffer.m_252986_(m, -s, y1, s).m_6122_(r, g, b, alpha).m_7421_(0.0f, 0.0f).m_5752_();
        depthBuffer.m_252986_(m, s, y1, -s).m_6122_(r, g, b, alpha).m_7421_(1.0f, 0.0f).m_5752_();
        depthBuffer.m_252986_(m, s, (float)yMin, -s).m_6122_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_5752_();
        depthBuffer.m_252986_(m, -s, y1, s).m_6122_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_5752_();
        depthBuffer.m_252986_(m, -s, y2, s).m_6122_(r, g, b, 0).m_7421_(0.0f, 0.0f).m_5752_();
        depthBuffer.m_252986_(m, s, y2, -s).m_6122_(r, g, b, 0).m_7421_(1.0f, 0.0f).m_5752_();
        depthBuffer.m_252986_(m, s, y1, -s).m_6122_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_5752_();
        poseStack.m_85849_();
    }

    private List<WaypointIcon> findVisibleWaypoints(Player player, float tickDelta) {
        return MapManager.getInstance().map(manager -> {
            ArrayList<MapIcon> visibleWaypoints = new ArrayList<MapIcon>();
            double fadeOutDistance = (Double)FTBChunksClientConfig.WAYPOINT_BEACON_FADE_DISTANCE.get();
            double fadeOutDistanceP = fadeOutDistance * 2.0 / 3.0;
            MapDimension dim = manager.getDimension((ResourceKey<Level>)player.m_9236_().m_46472_());
            for (Waypoint waypoint : dim.getWaypointManager()) {
                double distance;
                if (waypoint.isHidden() || !((distance = Math.sqrt(waypoint.getDistanceSq((Entity)player))) > fadeOutDistanceP) || !(distance <= (Double)FTBChunksClientConfig.WAYPOINT_MAX_DISTANCE.get())) continue;
                int alpha = 150;
                if (distance < fadeOutDistance) {
                    alpha = (int)((double)alpha * ((distance - fadeOutDistanceP) / (fadeOutDistance - fadeOutDistanceP)));
                }
                if (alpha <= 0) continue;
                waypoint.getMapIcon().setAlpha(alpha);
                visibleWaypoints.add(waypoint.getMapIcon());
            }
            visibleWaypoints.sort(new MapIconComparator(player.m_20182_(), tickDelta));
            return visibleWaypoints;
        }).orElse(List.of());
    }

    private EventResult screenOpened(Screen screen, ScreenAccess access) {
        if (screen instanceof PauseScreen) {
            this.nextRegionSave = System.currentTimeMillis() + 60000L;
            MapManager.getInstance().ifPresent(MapManager::saveAllRegions);
        }
        return EventResult.pass();
    }

    private void clientTick(Minecraft mc) {
        if (mc.f_91073_ == null) {
            return;
        }
        MapManager.getInstance().ifPresent(manager -> {
            int releaseInterval;
            if (mc.f_91074_ != null) {
                this.prevPlayerX = this.currentPlayerX;
                this.prevPlayerY = this.currentPlayerY;
                this.prevPlayerZ = this.currentPlayerZ;
                this.currentPlayerX = mc.f_91074_.m_20185_();
                this.currentPlayerY = mc.f_91074_.m_20186_();
                this.currentPlayerZ = mc.f_91074_.m_20189_();
            }
            Level level = (Level)Objects.requireNonNull(mc.f_91073_);
            if (this.taskQueueTicks % (long)((Integer)FTBChunksClientConfig.RERENDER_QUEUE_TICKS.get()).intValue() == 0L) {
                this.runRerenderTasks(level, (MapManager)manager);
            }
            if (this.taskQueueTicks % (long)((Integer)FTBChunksClientConfig.TASK_QUEUE_TICKS.get()).intValue() == 0L) {
                ClientTaskQueue.runQueuedTasks();
            }
            if ((releaseInterval = ((Integer)FTBChunksClientConfig.REGION_RELEASE_TIME.get()).intValue()) > 0 && level.m_46467_() % ((long)releaseInterval * 20L) == 0L) {
                manager.releaseStaleRegionData((long)releaseInterval * 1000L);
            }
            if (mc.f_91080_ == null) {
                manager.checkForRegionPurge();
            }
            ++this.taskQueueTicks;
        });
    }

    private void runRerenderTasks(Level level, MapManager manager) {
        if (!this.rerenderCache.isEmpty()) {
            this.rerenderCache.forEach((chunkPos, blocks) -> {
                ChunkAccess chunkAccess = level.m_6522_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62326_, false);
                if (chunkAccess != null) {
                    this.queueOrExecute(new ChunkUpdateTask(manager, level, chunkAccess, (ChunkPos)chunkPos, blocks.toIntArray()));
                }
            });
            this.rerenderCache.clear();
        }
    }

    private void teamPropertiesChanged(ClientTeamPropertiesChangedEvent event) {
        MapManager.getInstance().ifPresent(manager -> manager.updateAllRegions(false));
    }

    private void mapIcons(MapIconEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_WAYPOINTS.get()).booleanValue()) {
            MapDimension.getCurrent().ifPresent(mapDimension -> {
                for (Waypoint w : mapDimension.getWaypointManager()) {
                    if (w.isHidden() && event.getMapType().isMinimap()) continue;
                    event.add(w.getMapIcon());
                }
            });
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_ENTITIES.get()).booleanValue()) {
            for (Entity entity : mc.f_91073_.m_104735_()) {
                Icon icon2;
                if (entity instanceof AbstractClientPlayer || entity.m_6095_().m_20674_() == MobCategory.MISC || entity.m_20177_((Player)mc.f_91074_) || (icon2 = EntityIcons.get(entity)).isEmpty()) continue;
                if (((Boolean)FTBChunksClientConfig.ONLY_SURFACE_ENTITIES.get()).booleanValue() && !mc.f_91073_.m_6042_().f_63856_()) {
                    MapDimension.getCurrent().ifPresent(mapDimension -> {
                        int z;
                        int x = Mth.m_14107_((double)entity.m_20185_());
                        MapRegion region = mapDimension.getRegion(XZ.regionFromBlock((int)x, (int)(z = Mth.m_14107_((double)entity.m_20189_()))));
                        MapRegionData data = region.getData();
                        if (data != null) {
                            short y = data.height[(x & 0x1FF) + (z & 0x1FF) * 512];
                            if (entity.m_20186_() >= (double)(y - 10)) {
                                event.add(new EntityMapIcon(entity, icon2));
                            }
                        }
                    });
                    continue;
                }
                event.add(new EntityMapIcon(entity, icon2));
            }
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_PLAYER_HEADS.get()).booleanValue()) {
            if (mc.f_91073_.m_6907_().size() > 1) {
                for (AbstractClientPlayer player : mc.f_91073_.m_6907_()) {
                    if (player == mc.f_91074_ || player.m_20177_((Player)mc.f_91074_) || !VisibleClientPlayers.isPlayerVisible((Player)player)) continue;
                    if (this.longRangePlayerTracker.remove(player.m_20148_()) != null) {
                        LargeMapScreen.refreshIconsIfOpen();
                    }
                    event.add(new EntityMapIcon((Entity)player, (Icon)FaceIcon.getFace((GameProfile)player.m_36316_())));
                }
            }
            this.longRangePlayerTracker.forEach((id, icon) -> event.add((MapIcon)icon));
        }
        if (!event.getMapType().isMinimap()) {
            event.add(new EntityMapIcon((Entity)mc.f_91074_, (Icon)FaceIcon.getFace((GameProfile)mc.f_91074_.m_36316_())));
            event.add(new PointerIcon());
        }
    }

    void refreshMinimapIcons() {
        this.lastMapIconUpdate = 0L;
    }

    private void reloadShaders(ResourceProvider resourceProvider, ClientReloadShadersEvent.ShadersSink sink) {
    }

    public void rerender(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        IntOpenHashSet set = this.rerenderCache.get(chunkPos);
        if (set == null) {
            set = new IntOpenHashSet();
            this.rerenderCache.put(chunkPos, set);
        }
        if (set.add((pos.m_123341_() & 0xF) + (pos.m_123343_() & 0xF) * 16) && ((Boolean)FTBChunksClientConfig.DEBUG_INFO.get()).booleanValue()) {
            ++this.renderedDebugCount;
        }
    }

    public void handlePacket(ClientboundSectionBlocksUpdatePacket p) {
        short[] positions;
        SectionPos sectionPos = p.f_132980_;
        for (short position : positions = p.f_132981_) {
            this.rerender(sectionPos.m_123245_(position));
        }
    }

    public void handlePacket(ClientboundLevelChunkWithLightPacket p) {
        ChunkAccess chunkAccess;
        MapManager manager = MapManager.getInstance().orElse(null);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (chunkAccess = level.m_6522_(p.m_195717_(), p.m_195718_(), ChunkStatus.f_62326_, false)) != null) {
            this.queueOrExecute(new ChunkUpdateTask(manager, (Level)level, chunkAccess, new ChunkPos(p.m_195717_(), p.m_195718_())));
        }
    }

    public void queueOrExecute(MapTask task) {
        MAP_EXECUTOR.execute(task);
    }

    public void handlePacket(ClientboundBlockUpdatePacket p) {
        this.rerender(p.m_131749_());
    }

    public void maybeClearDeathpoint(Player player) {
        int maxDist = (Integer)FTBChunksClientConfig.DEATH_WAYPOINT_AUTOREMOVE_DISTANCE.get();
        MapManager.getInstance().ifPresent(manager -> {
            if (maxDist > 0 && Minecraft.m_91087_().f_91080_ == null) {
                WaypointManagerImpl wpm = manager.getDimension((ResourceKey<Level>)player.m_9236_().m_46472_()).getWaypointManager();
                wpm.getNearestDeathpoint(player).ifPresent(wp -> {
                    if (wp.getDistanceSq((Entity)player) < (double)(maxDist * maxDist)) {
                        wpm.remove((WaypointImpl)wp);
                        wpm.getNearestDeathpoint(player).ifPresent(wp1 -> wp1.setHidden(false));
                        player.m_5661_((Component)Component.m_237110_((String)"ftbchunks.deathpoint_removed", (Object[])new Object[]{wp.getName()}).m_130940_(ChatFormatting.YELLOW), true);
                    }
                });
            }
        });
    }

    public void updateTrackedPlayerPos(GameProfile profile, BlockPos pos, boolean valid) {
        boolean changed = false;
        if (!valid) {
            changed = this.longRangePlayerTracker.remove(profile.getId()) != null;
        } else {
            TrackedPlayerMapIcon icon = this.longRangePlayerTracker.get(profile.getId());
            if (icon == null) {
                this.longRangePlayerTracker.put(profile.getId(), new TrackedPlayerMapIcon(profile, Vec3.m_82512_((Vec3i)pos), FaceIcon.getFace((GameProfile)profile)));
                changed = true;
            } else {
                icon.setPos(Vec3.m_82512_((Vec3i)pos));
            }
        }
        if (changed) {
            LargeMapScreen.refreshIconsIfOpen();
        }
    }

    public List<Component> getChunkSummary() {
        if (this.generalChunkData == null) {
            return List.of();
        }
        ArrayList<Component> list = new ArrayList<Component>(4);
        list.add((Component)Component.m_237115_((String)"ftbchunks.gui.claimed"));
        int claimed = this.generalChunkData.claimed();
        int maxClaim = this.generalChunkData.maxClaimChunks();
        list.add((Component)Component.m_237113_((String)(claimed + " / " + maxClaim)).m_130940_(claimed > maxClaim ? ChatFormatting.RED : (claimed == maxClaim ? ChatFormatting.YELLOW : ChatFormatting.GREEN)));
        list.add((Component)Component.m_237115_((String)"ftbchunks.gui.force_loaded"));
        int loaded = this.generalChunkData.loaded();
        int maxLoaded = this.generalChunkData.maxForceLoadChunks();
        list.add((Component)Component.m_237113_((String)(loaded + " / " + maxLoaded)).m_130940_(loaded > maxLoaded ? ChatFormatting.RED : (loaded == maxLoaded ? ChatFormatting.YELLOW : ChatFormatting.GREEN)));
        return list;
    }

    public int getMinimapTextureId() {
        return this.minimapTextureId;
    }

    public static Waypoint addWaypoint(String name, GlobalPos globalPos, int color) {
        return FTBChunksAPI.clientApi().getWaypointManager((ResourceKey<Level>)globalPos.m_122640_()).map(mgr -> {
            Waypoint wp = mgr.addWaypointAt(globalPos.m_122646_(), name);
            wp.setColor(color);
            return wp;
        }).orElse(null);
    }

    public void setupComponents() {
        this.sortedComponents.clear();
        this.computeOrderedComponents();
    }

    private void computeOrderedComponents() {
        Map componentMap = FTBChunksAPI.clientApi().getMinimapComponents().stream().collect(Collectors.toMap(MinimapInfoComponent::id, Function.identity()));
        List order = ((List)FTBChunksClientConfig.MINIMAP_INFO_ORDER.get()).stream().map(ResourceLocation::new).collect(Collectors.toList());
        boolean save = false;
        for (ResourceLocation location : componentMap.keySet()) {
            if (order.contains(location)) continue;
            order.add(location);
            save = true;
        }
        if (save) {
            FTBChunksClientConfig.MINIMAP_INFO_ORDER.set(order.stream().map(ResourceLocation::toString).collect(Collectors.toList()));
            FTBChunksClientConfig.saveConfig();
        }
        for (ResourceLocation id : order) {
            MinimapInfoComponent minimapInfoComponent = (MinimapInfoComponent)componentMap.get(id);
            if (minimapInfoComponent == null || !FTBChunksAPI.clientApi().isMinimapComponentEnabled(minimapInfoComponent)) continue;
            this.sortedComponents.add(minimapInfoComponent);
        }
    }

    public static double getVanillaEffectsOffsetX() {
        return vanillaEffectsOffsetX;
    }

    public int getRenderedDebugCount() {
        return this.renderedDebugCount;
    }

    private static /* synthetic */ EventResult lambda$addQuickWaypoint$7(StringConfig name, Player player, MapManager manager) {
        WaypointAddScreen screen = new WaypointAddScreen(name, player);
        screen.openGuiLater();
        return EventResult.interruptTrue();
    }

    static {
        MAP_EXECUTOR = Executors.newSingleThreadExecutor();
        BUTTON_ID_MAP = new ResourceLocation("ftbchunks:open_gui");
        BUTTON_ID_CLAIM = new ResourceLocation("ftbchunks:open_claim_gui");
        CIRCLE_MASK = new ResourceLocation("ftbchunks:textures/circle_mask.png");
        CIRCLE_BORDER = new ResourceLocation("ftbchunks:textures/circle_border.png");
        SQUARE_MASK = new ResourceLocation("ftbchunks:textures/square_mask.png");
        SQUARE_BORDER = new ResourceLocation("ftbchunks:textures/square_border.png");
        PLAYER = new ResourceLocation("ftbchunks:textures/player.png");
        COMPASS = new ResourceLocation[]{new ResourceLocation("ftbchunks:textures/compass_e.png"), new ResourceLocation("ftbchunks:textures/compass_n.png"), new ResourceLocation("ftbchunks:textures/compass_w.png"), new ResourceLocation("ftbchunks:textures/compass_s.png")};
    }

    public static class WaypointAddScreen
    extends BaseScreen {
        private final StringConfig name;
        private final GlobalPos waypointLocation;

        public WaypointAddScreen(StringConfig name, GlobalPos waypointLocation) {
            this.name = name;
            this.waypointLocation = waypointLocation;
            this.setHeight(35);
        }

        public WaypointAddScreen(StringConfig name, Player player) {
            this(name, GlobalPos.m_122643_((ResourceKey)player.m_9236_().m_46472_(), (BlockPos)player.m_20183_()));
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        }

        public void addWidgets() {
            ColorConfig col = new ColorConfig();
            col.setValue((Object)Color4I.hsb((float)MathUtils.RAND.nextFloat(), (float)1.0f, (float)1.0f));
            AddWaypointOverlay overlay = new AddWaypointOverlay((Panel)this, (ConfigFromString)this.name, col, set -> {
                if (set && !((String)this.name.getValue()).isEmpty()) {
                    Waypoint wp = FTBChunksClient.addWaypoint((String)this.name.getValue(), this.waypointLocation, ((Color4I)col.getValue()).rgba());
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237110_((String)"ftbchunks.waypoint_added", (Object[])new Object[]{Component.m_237113_((String)wp.getName()).m_130940_(ChatFormatting.YELLOW)}), true);
                }
            }){

                public void onClosed() {
                    this.closeGui();
                }
            };
            overlay.setWidth(this.width);
            this.pushModalPanel((ModalPanel)overlay);
        }
    }
}

