/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.block;

import com.lothrazar.library.util.ChatUtil;
import com.lothrazar.library.util.ItemStackUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class BlockFlib
extends Block {
    private static final int MAX_CONNECTED_UPDATE = 18;
    public static final EnumProperty<DyeColor> COLOUR = EnumProperty.m_61587_((String)"color", DyeColor.class);
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    Settings me;

    public BlockFlib(BlockBehaviour.Properties prop) {
        this(prop, new Settings());
    }

    public BlockFlib(BlockBehaviour.Properties prop, Settings custom) {
        super(prop);
        this.me = custom;
        BlockState def = this.m_49966_();
        if (this.me.rotateColour) {
            def = (BlockState)def.m_61124_(COLOUR, (Comparable)DyeColor.WHITE);
        }
        if (this.me.litWhenPowered) {
            def = (BlockState)def.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        this.m_49959_(def);
    }

    public static Boolean never(BlockState s, BlockGetter w, BlockPos pos, EntityType<?> t) {
        return false;
    }

    public static boolean never(BlockState s, BlockGetter w, BlockPos pos) {
        return false;
    }

    public boolean m_7898_(BlockState bs, LevelReader level, BlockPos pos) {
        if (this.me.facingAttachment) {
            Direction dir = (Direction)bs.m_61143_((Property)BlockStateProperties.f_61372_);
            return Block.m_49863_((LevelReader)level, (BlockPos)pos.m_121945_(dir), (Direction)dir.m_122424_());
        }
        return super.m_7898_(bs, level, pos);
    }

    public BlockState m_7417_(BlockState bs, Direction face, BlockState bsOp, LevelAccessor level, BlockPos pos, BlockPos posOther) {
        if (this.me.facingAttachment) {
            return !bs.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(bs, face, bsOp, level, pos, posOther);
        }
        return super.m_7417_(bs, face, bsOp, level, pos, posOther);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        if (this.me.litWhenPowered) {
            return (BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(ctx.m_43725_().m_276867_(ctx.m_8083_())));
        }
        return this.m_49966_();
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos posOther, boolean flagIn) {
        boolean flag;
        if (this.me.litWhenPowered && !level.f_46443_ && (flag = ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) != level.m_276867_(pos)) {
            if (flag) {
                level.m_186460_(pos, (Block)this, 4);
            } else {
                level.m_7731_(pos, (BlockState)state.m_61122_((Property)LIT), 2);
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (this.me.litWhenPowered && ((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !world.m_276867_(pos)) {
            world.m_7731_(pos, (BlockState)state.m_61122_((Property)LIT), 2);
        }
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return super.m_6376_(blockState, blockAccess, pos, side);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event, BlockState state) {
        Item item;
        if (this.me.rotateColour && (item = event.getItemStack().m_41720_()) instanceof DyeItem) {
            DyeItem newColor = (DyeItem)item;
            boolean doConnected = event.getEntity().m_6047_();
            this.rotateDye(state, event.getLevel(), event.getPos(), event.getEntity(), event.getItemStack(), newColor.m_41089_(), doConnected);
        }
    }

    public void rotateDye(BlockState state, Level world, BlockPos pos, Player player, ItemStack heldStack, DyeColor newColour, boolean doConnected) {
        DyeColor oldColour = (DyeColor)state.m_61143_(COLOUR);
        if (newColour != oldColour) {
            world.m_46597_(pos, (BlockState)state.m_61124_(COLOUR, (Comparable)newColour));
            if (this.me.rotateColourConsume) {
                ItemStackUtil.shrink(player, heldStack);
            }
            if (doConnected) {
                this.setConnectedColour(world, pos, oldColour, newColour, 0);
            }
        }
    }

    public void setConnectedColour(Level world, BlockPos pos, DyeColor oldColour, DyeColor newColor, int rec) {
        if (rec > 18) {
            return;
        }
        for (Direction d : Direction.values()) {
            BlockPos offset = pos.m_121945_(d);
            BlockState here = world.m_8055_(offset);
            if (here.m_60734_() != this || oldColour != here.m_61143_(COLOUR)) continue;
            world.m_46597_(offset, (BlockState)here.m_61124_(COLOUR, (Comparable)newColor));
            this.setConnectedColour(world, offset, oldColour, newColor, ++rec);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.me.tooltip) {
            this.me.tooltipApply(this, tooltip);
        }
        super.m_5871_(stack, worldIn, tooltip, flagIn);
    }

    public static class Settings {
        boolean tooltip = false;
        boolean rotateColour = false;
        boolean rotateColourConsume = false;
        boolean litWhenPowered;
        private boolean facingAttachment;

        public Settings rotateColour(boolean consume) {
            this.rotateColour = true;
            this.rotateColourConsume = consume;
            return this;
        }

        public Settings litWhenPowered() {
            this.litWhenPowered = true;
            return this;
        }

        public Settings facingAttachment() {
            this.facingAttachment = true;
            return this;
        }

        public Settings tooltip() {
            this.tooltip = true;
            return this;
        }

        public Settings noTooltip() {
            this.tooltip = false;
            return this;
        }

        public void tooltipApply(Block block, List<Component> tooltipList) {
            tooltipList.add((Component)ChatUtil.ilang(block.m_7705_() + ".tooltip").m_130940_(ChatFormatting.GRAY));
        }
    }
}

