/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.annotation.processor.onlyin;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.moddingx.libx.annotation.processor.Classes;
import org.moddingx.libx.annotation.processor.Processor;

public class OnlyInProcessor
extends Processor {
    @Override
    public Class<?>[] getTypes() {
        return new Class[0];
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> set = new HashSet<String>(super.getSupportedAnnotationTypes());
        set.add(Classes.sourceName("net.minecraftforge.api.distmarker.OnlyIn"));
        set.add(Classes.sourceName("net.minecraftforge.api.distmarker.OnlyIns"));
        return set;
    }

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> set = new HashSet<String>(super.getSupportedAnnotationTypes());
        set.add("mod.properties.strict_onlyin");
        return set;
    }

    @Override
    public void run(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!this.options().containsKey("mod.properties.strict_onlyin") || !Boolean.parseBoolean(this.options().get("mod.properties.strict_onlyin"))) {
            return;
        }
        for (Element element : roundEnv.getElementsAnnotatedWithAny(this.typeElement("net.minecraftforge.api.distmarker.OnlyIn"), this.typeElement("net.minecraftforge.api.distmarker.OnlyIns"))) {
            Set<DistData> data = this.fromElement(element);
            Set specificDists = data.stream().filter(d -> d.iface() == null).map(DistData::dist).collect(Collectors.toUnmodifiableSet());
            if (specificDists.size() > 1) {
                this.messager().printMessage(Diagnostic.Kind.ERROR, "@OnlyIn used with both client and server.", element);
                continue;
            }
            Dist dist = this.distFor(element, true);
            if (!element.getKind().isClass() && !element.getKind().isInterface()) continue;
            for (DistData d2 : data) {
                if (d2.iface() == null) continue;
                if (dist != null) {
                    if (d2.dist() == dist) {
                        this.messager().printMessage(Diagnostic.Kind.WARNING, "Unnecessary interface @OnlyIn, whole element is marked as " + dist.name(), element);
                    } else {
                        this.messager().printMessage(Diagnostic.Kind.ERROR, "Invalid @OnlyIn, element is marked as " + dist.name() + ", interface as " + d2.dist(), element);
                        continue;
                    }
                }
                if (this.types().isSubtype(this.types().erasure(element.asType()), this.types().erasure(d2.iface().asType()))) continue;
                this.messager().printMessage(Diagnostic.Kind.ERROR, "Invalid @OnlyIn, element does not implement interface " + d2.iface().asType(), element);
            }
        }
        for (TypeElement typeElement : this.getAllProcessedTypes()) {
            Map possibleOverrides = this.getPossibleOverrideMap(typeElement, executable -> {
                Dist memberDist = this.distFor((Element)executable, false);
                return memberDist == null ? Optional.empty() : Optional.of(new DistOverride((ExecutableElement)executable, memberDist));
            });
            for (Element element : typeElement.getEnclosedElements()) {
                Set parentDists;
                if (element.getKind() != ElementKind.METHOD || !(element instanceof ExecutableElement)) continue;
                ExecutableElement executable2 = (ExecutableElement)element;
                if (!possibleOverrides.containsKey(element.getSimpleName().toString()) || (parentDists = possibleOverrides.get(element.getSimpleName().toString()).stream().filter(ov -> this.elements().overrides(executable2, ov.element(), type)).map(DistOverride::dist).collect(Collectors.toUnmodifiableSet())).size() != 1 || this.distFor(executable2, true) == parentDists.iterator().next()) continue;
                this.messager().printMessage(Diagnostic.Kind.WARNING, "Not annotated method overrides method annotated with @OnlyIn(" + ((Dist)((Object)parentDists.iterator().next())).name() + ")", element);
            }
        }
    }

    @Nullable
    private Dist distFor(Element element, boolean inherit) {
        HashSet set = new HashSet(this.fromElement(element).stream().filter(d -> d.iface() == null).map(DistData::dist).collect(Collectors.toUnmodifiableSet()));
        if (inherit && (element.getKind().isField() || element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR)) {
            set.addAll(this.fromElement(element.getEnclosingElement()).stream().filter(d -> d.iface() == null).map(DistData::dist).collect(Collectors.toUnmodifiableSet()));
        }
        if (set.size() != 1) {
            return null;
        }
        return (Dist)((Object)set.iterator().next());
    }

    private Set<DistData> fromElement(Element element) {
        HashSet<DistData> allDist = new HashSet<DistData>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (this.sameErasure(annotationMirror.getAnnotationType().asElement().asType(), this.forClass("net.minecraftforge.api.distmarker.OnlyIn"))) {
                DistData data = this.fromAnnotation(element, annotationMirror);
                if (data == null) continue;
                allDist.add(data);
                continue;
            }
            if (!this.sameErasure(annotationMirror.getAnnotationType().asElement().asType(), this.forClass("net.minecraftforge.api.distmarker.OnlyIns"))) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                Iterator iterator;
                if (!entry.getKey().getSimpleName().contentEquals("value") || !((iterator = entry.getValue().getValue()) instanceof List)) continue;
                List list = (List)((Object)iterator);
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    AnnotationMirror subMirror;
                    DistData data;
                    Object elem = iterator.next();
                    if (!(elem instanceof AnnotationMirror) || (data = this.fromAnnotation(element, subMirror = (AnnotationMirror)elem)) == null) continue;
                    allDist.add(data);
                }
            }
        }
        return allDist;
    }

    @Nullable
    private DistData fromAnnotation(Element element, AnnotationMirror mirror) {
        if (!this.sameErasure(mirror.getAnnotationType().asElement().asType(), this.forClass("net.minecraftforge.api.distmarker.OnlyIn"))) {
            return null;
        }
        Dist dist = null;
        TypeElement iface = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
            DeclaredType declared;
            Object object;
            if (entry.getKey().getSimpleName().contentEquals("value")) {
                Object object2 = entry.getValue().getValue();
                if (!(object2 instanceof VariableElement)) continue;
                VariableElement var = (VariableElement)object2;
                if (var.getSimpleName().contentEquals(Dist.CLIENT.name())) {
                    dist = Dist.CLIENT;
                    continue;
                }
                if (!var.getSimpleName().contentEquals(Dist.DEDICATED_SERVER.name())) continue;
                dist = Dist.DEDICATED_SERVER;
                continue;
            }
            if (!entry.getKey().getSimpleName().contentEquals("_interface") || !((object = entry.getValue().getValue()) instanceof TypeMirror)) continue;
            TypeMirror type = (TypeMirror)object;
            object = this.types().erasure(type);
            if (!(object instanceof DeclaredType) || (declared = (DeclaredType)object).getKind() != TypeKind.DECLARED) continue;
            Element declaredElem = declared.asElement();
            if (declaredElem.getKind() == ElementKind.INTERFACE && declaredElem instanceof TypeElement) {
                TypeElement typeElement;
                iface = typeElement = (TypeElement)declaredElem;
                continue;
            }
            this.messager().printMessage(Diagnostic.Kind.ERROR, "Value used in _interface of @OnlyIn is not an interface.", element);
            return null;
        }
        if (dist == null) {
            return null;
        }
        return new DistData(dist, iface);
    }

    private static enum Dist {
        CLIENT,
        DEDICATED_SERVER;

    }

    private record DistData(Dist dist, @Nullable TypeElement iface) {
    }

    private record DistOverride(ExecutableElement element, Dist dist) {
    }
}

