/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.loot;

import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.moddingx.libx.LibX;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.PackTarget;
import org.moddingx.libx.datagen.loot.LootBuilders;
import org.moddingx.libx.datagen.provider.loot.entry.GenericLootModifier;
import org.moddingx.libx.datagen.provider.loot.entry.LootFactory;
import org.moddingx.libx.datagen.provider.loot.entry.LootModifier;
import org.moddingx.libx.datagen.provider.loot.entry.SimpleLootFactory;
import org.moddingx.libx.impl.datagen.loot.LootData;
import org.moddingx.libx.mod.ModX;

public abstract class LootProviderBase<T>
implements DataProvider {
    private static final ExistingFileHelper.IResourceType LOOT_TYPE = new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", "loot_tables");
    protected final ModX mod;
    protected final PackTarget packTarget;
    protected final ExistingFileHelper fileHelper;
    protected final String folder;
    protected final LootContextParamSet params;
    protected final Supplier<Stream<Map.Entry<ResourceLocation, T>>> modElements;
    protected final Function<T, ResourceLocation> idResolver;
    private final Set<T> ignored = new HashSet<T>();
    private final Map<T, Function<T, LootTable.Builder>> functionMap = new HashMap<T, Function<T, LootTable.Builder>>();

    protected LootProviderBase(DatagenContext ctx, String folder, LootContextParamSet params, ResourceKey<? extends Registry<T>> registryKey) {
        this(ctx, folder, params, () -> ctx.registries().registry(registryKey).m_6579_().stream().sorted(Map.Entry.comparingByKey(Comparator.comparing(ResourceKey::m_135782_))).map(entry -> Map.entry(((ResourceKey)entry.getKey()).m_135782_(), entry.getValue())), id -> ctx.registries().registry(registryKey).m_7981_(id));
    }

    protected LootProviderBase(DatagenContext ctx, String folder, LootContextParamSet params, Supplier<Stream<Map.Entry<ResourceLocation, T>>> modElements, Function<T, ResourceLocation> allElementIds) {
        this.mod = ctx.mod();
        this.packTarget = ctx.target();
        this.fileHelper = ctx.fileHelper();
        this.folder = folder;
        this.params = params;
        this.modElements = modElements;
        this.idResolver = value -> {
            ResourceLocation id = (ResourceLocation)allElementIds.apply(value);
            if (id == null) {
                throw new IllegalStateException("Unregistered value: " + value);
            }
            return id;
        };
    }

    protected LootProviderBase(DatagenContext ctx, String folder, LootContextParamSet params, Function<T, ResourceLocation> elementIds) {
        this.mod = ctx.mod();
        this.packTarget = ctx.target();
        this.fileHelper = ctx.fileHelper();
        this.folder = folder;
        this.params = params;
        this.modElements = () -> this.functionMap.keySet().stream().map(element -> Map.entry((ResourceLocation)elementIds.apply(element), element));
        this.idResolver = value -> {
            ResourceLocation id = (ResourceLocation)elementIds.apply(value);
            if (id == null) {
                throw new IllegalStateException("Unregistered value: " + value);
            }
            return id;
        };
    }

    protected abstract void setup();

    protected void customLootTable(T item) {
        this.ignored.add(item);
    }

    protected void customLootTable(T item, LootTable.Builder loot) {
        this.functionMap.put(item, b -> loot);
    }

    protected void customLootTable(T item, Function<T, LootTable.Builder> loot) {
        this.functionMap.put(item, loot);
    }

    protected SimpleLootFactory<T> element() {
        return SimpleLootFactory.from(EmptyLootItem.m_79533_());
    }

    @Nullable
    protected abstract LootTable.Builder defaultBehavior(T var1);

    @Nonnull
    public String m_6055_() {
        ResourceLocation key = LootContextParamSets.m_81426_((LootContextParamSet)this.params);
        String name = key == null ? "generic" : ("minecraft".equals(key.m_135827_()) ? key.m_135815_() : key.toString());
        return this.mod.modid + " " + name + " loot tables";
    }

    @Nonnull
    public CompletableFuture<?> m_213708_(@Nonnull CachedOutput cache) {
        this.setup();
        final Map<ResourceLocation, LootTable> tables = this.modElements.get().filter(entry -> this.mod.modid.equals(((ResourceLocation)entry.getKey()).m_135827_())).filter(entry -> !this.ignored.contains(entry.getValue())).flatMap(this::resolve).map(entry -> Map.entry(new ResourceLocation(((ResourceLocation)entry.getKey()).m_135827_(), this.folder + "/" + ((ResourceLocation)entry.getKey()).m_135815_()), (LootTable)entry.getValue())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        ValidationContext validationContext = new ValidationContext(this.params, new LootDataResolver(){

            @Nullable
            public <A> A m_278667_(@Nonnull LootDataId<A> id) {
                if (id.f_278383_() != LootDataType.f_278413_) {
                    return null;
                }
                if (tables.containsKey(id.f_278500_())) {
                    return (A)tables.get(id.f_278500_());
                }
                if (LootProviderBase.this.fileHelper.exists(id.f_278500_(), LOOT_TYPE)) {
                    return (A)LootTable.m_79147_().m_79167_();
                }
                return null;
            }
        });
        for (Map.Entry<ResourceLocation, LootTable> entry2 : tables.entrySet()) {
            entry2.getValue().m_79136_(validationContext.m_278632_("{" + entry2.getKey() + "}", new LootDataId(LootDataType.f_278413_, entry2.getKey())));
        }
        for (Map.Entry<ResourceLocation, LootTable> entry2 : tables.entrySet()) {
            this.fileHelper.trackGenerated(entry2.getKey(), LOOT_TYPE);
        }
        Multimap multimap = validationContext.m_79352_();
        if (!multimap.isEmpty()) {
            multimap.forEach((where, what) -> LibX.logger.warn("LootTable validation problem in " + where + ": " + what));
            throw new IllegalStateException("There were problems validating the loot tables.");
        }
        return CompletableFuture.allOf((CompletableFuture[])tables.entrySet().stream().map(entry -> {
            Path path = this.packTarget.path(PackType.SERVER_DATA).resolve(((ResourceLocation)entry.getKey()).m_135827_()).resolve("loot_tables").resolve(((ResourceLocation)entry.getKey()).m_135815_() + ".json");
            return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)LootDataType.f_278413_.m_278857_().toJsonTree(entry.getValue()), (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    private Stream<Map.Entry<ResourceLocation, LootTable>> resolve(Map.Entry<ResourceLocation, T> entry) {
        LootTable.Builder builder;
        Function<Object, LootTable.Builder> loot = this.functionMap.containsKey(entry.getValue()) ? this.functionMap.get(entry.getValue()) : ((builder = this.defaultBehavior(entry.getValue())) == null ? null : b -> builder);
        return loot == null ? Stream.empty() : Stream.of(Map.entry(entry.getKey(), loot.apply(entry.getValue()).m_79165_(this.params).m_79167_()));
    }

    protected final LootModifier<T> modifier(BiFunction<T, LootPoolSingletonContainer.Builder<?>, LootPoolSingletonContainer.Builder<?>> function) {
        return LootModifier.of(this.element(), function);
    }

    protected final GenericLootModifier<T> genericModifier(BiFunction<T, LootPoolSingletonContainer.Builder<?>, LootPoolEntryContainer.Builder<?>> function) {
        return GenericLootModifier.of(this.element(), function);
    }

    protected final LootModifier<T> identity() {
        return LootModifier.identity(this.element());
    }

    public void drops(T item, ItemStack ... drops) {
        this.drops(item, Arrays.stream(drops).map(this::stack).toList());
    }

    @SafeVarargs
    public final void drops(T item, LootFactory<T> ... loot) {
        this.drops(item, Arrays.stream(loot).toList());
    }

    public void drops(T item, List<LootFactory<T>> loot) {
        this.generateBaseTable(item, this.combine(loot).build(item));
    }

    public void generateBaseTable(T item, LootPoolEntryContainer.Builder<?> entry) {
        LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(entry);
        this.customLootTable(item, LootTable.m_79147_().m_79161_(pool));
    }

    public SimpleLootFactory<T> from(LootPoolSingletonContainer.Builder<?> entry) {
        return SimpleLootFactory.from(entry);
    }

    public LootFactory<T> from(LootPoolEntryContainer.Builder<?> entry) {
        return LootFactory.from(entry);
    }

    public LootModifier<T> from(LootItemConditionalFunction.Builder<?> function) {
        return this.modifier((item, entry) -> entry.m_79078_((LootItemFunction.Builder)function));
    }

    public SimpleLootFactory<T> reference(T value) {
        ResourceLocation elementId = this.idResolver.apply(value);
        return this.reference(new ResourceLocation(elementId.m_135827_(), this.folder + "/" + elementId.m_135815_()));
    }

    public SimpleLootFactory<T> reference(ResourceLocation lootTable) {
        return SimpleLootFactory.from(LootTableReference.m_79776_((ResourceLocation)lootTable));
    }

    public LootItemCondition.Builder random(float chance) {
        return LootItemRandomChanceCondition.m_81927_((float)chance);
    }

    public LootModifier<T> count(int count) {
        return this.from(SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)count)));
    }

    public LootModifier<T> count(int min, int max) {
        if (min == max) {
            return this.from(SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)min)));
        }
        return this.from(SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
    }

    public LootModifier<T> countBinomial(float chance, int num) {
        return this.from(SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)num, (float)chance)));
    }

    public LootItemCondition.Builder not(LootItemCondition.Builder condition) {
        return InvertedLootItemCondition.m_81694_((LootItemCondition.Builder)condition);
    }

    public LootItemCondition.Builder and(LootItemCondition.Builder ... conditions) {
        return AllOfCondition.m_285871_((LootItemCondition.Builder[])conditions);
    }

    public LootItemCondition.Builder or(LootItemCondition.Builder ... conditions) {
        return AnyOfCondition.m_285758_((LootItemCondition.Builder[])conditions);
    }

    public SimpleLootFactory<T> stack(ItemLike item) {
        return this.from(LootItem.m_79579_((ItemLike)item));
    }

    public SimpleLootFactory<T> stack(ItemStack stack) {
        return this.from(LootData.stack(stack));
    }

    @SafeVarargs
    public final LootFactory<T> combine(LootFactory<T> ... loot) {
        return this.combine(Arrays.stream(loot).toList());
    }

    public final LootFactory<T> combine(List<LootFactory<T>> loot) {
        return e -> LootData.combineBy(LootBuilders::all, l -> l.build(e), loot);
    }

    @SafeVarargs
    public final LootFactory<T> random(LootFactory<T> ... loot) {
        return this.random(Arrays.stream(loot).toList());
    }

    public final LootFactory<T> random(List<LootFactory<T>> loot) {
        return e -> LootData.combineBy(LootBuilders::group, l -> l.build(e), loot);
    }

    @SafeVarargs
    public final LootFactory<T> first(LootFactory<T> ... loot) {
        return this.first(Arrays.stream(loot).toList());
    }

    public final LootFactory<T> first(List<LootFactory<T>> loot) {
        return e -> LootData.combineBy(LootBuilders::alternative, l -> l.build(e), loot);
    }

    @SafeVarargs
    public final LootFactory<T> whileMatch(LootFactory<T> ... loot) {
        return this.whileMatch(Arrays.stream(loot).toList());
    }

    public final LootFactory<T> whileMatch(List<LootFactory<T>> loot) {
        return e -> LootData.combineBy(LootBuilders::sequence, l -> l.build(e), loot);
    }
}

