/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.config.mappers.generic;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.moddingx.libx.config.correct.ConfigCorrection;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.mapper.GenericValueMapper;
import org.moddingx.libx.config.mapper.ValueMapper;
import org.moddingx.libx.config.validator.ValidatorInfo;
import org.moddingx.libx.impl.config.gui.screen.content.CollectionContent;

public class SetValueMapper<T>
implements GenericValueMapper<Set<T>, JsonArray, T> {
    public static final SetValueMapper<?> INSTANCE = new SetValueMapper();
    private static final Comparator<Object> COMPARATOR = (o1, o2) -> {
        try {
            if (o1 instanceof Comparable) {
                Comparable cmp = (Comparable)o1;
                if (o1.getClass().isAssignableFrom(o2.getClass())) {
                    return cmp.compareTo(o2);
                }
            }
            if (o2 instanceof Comparable) {
                Comparable cmp = (Comparable)o2;
                if (o2.getClass().isAssignableFrom(o1.getClass())) {
                    return -cmp.compareTo(o1);
                }
            }
        }
        catch (Exception | NoClassDefFoundError throwable) {
            // empty catch block
        }
        return o1.toString().compareTo(o2.toString());
    };

    private SetValueMapper() {
    }

    @Override
    public Class<Set<T>> type() {
        return Set.class;
    }

    @Override
    public Class<JsonArray> element() {
        return JsonArray.class;
    }

    @Override
    public int getGenericElementPosition() {
        return 0;
    }

    @Override
    public Set<T> fromJson(JsonArray json, ValueMapper<T, JsonElement> mapper) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = 0; i < json.size(); ++i) {
            JsonElement element = json.get(i);
            builder.add(mapper.fromJson(element));
        }
        return builder.build();
    }

    @Override
    public JsonArray toJson(Set<T> value, ValueMapper<T, JsonElement> mapper) {
        JsonArray array = new JsonArray();
        for (T element : this.getSortedElements(value)) {
            array.add(mapper.toJson(element));
        }
        return array;
    }

    @Override
    public Set<T> fromNetwork(FriendlyByteBuf buffer, ValueMapper<T, JsonElement> mapper) {
        int size = buffer.m_130242_();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = 0; i < size; ++i) {
            builder.add(mapper.fromNetwork(buffer));
        }
        return builder.build();
    }

    @Override
    public void toNetwork(Set<T> value, FriendlyByteBuf buffer, ValueMapper<T, JsonElement> mapper) {
        buffer.m_130130_(value.size());
        for (T element : value) {
            mapper.toNetwork(element, buffer);
        }
    }

    @Override
    public Optional<Set<T>> correct(JsonElement json, ValueMapper<T, JsonElement> mapper, ConfigCorrection<Set<T>> correction) {
        if (json.isJsonArray()) {
            ImmutableSet.Builder set = ImmutableSet.builder();
            for (int i = 0; i < json.getAsJsonArray().size(); ++i) {
                correction.tryCorrect(json.getAsJsonArray().get(i), mapper, value -> Optional.empty()).ifPresent(arg_0 -> ((ImmutableSet.Builder)set).add(arg_0));
            }
            ImmutableSet result = set.build();
            if (result.isEmpty() && json.getAsJsonArray().size() > 0) {
                return Optional.empty();
            }
            return Optional.of(result);
        }
        return correction.tryCorrect(json, mapper, ConfigCorrection.check(value -> value.size() == 1, value -> value.iterator().next())).map(Set::of);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ConfigEditor<Set<T>> createEditor(ValueMapper<T, JsonElement> mapper, ValidatorInfo<?> validator) {
        return ConfigEditor.custom(Set.of(), set -> new CollectionContent<T, Set>(this.getSortedElements((Set<T>)set), mapper.createEditor(ValidatorInfo.empty()), Set::copyOf, false));
    }

    private List<T> getSortedElements(Set<T> set) {
        return set.stream().sorted(COMPARATOR).toList();
    }
}

