/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import javax.annotation.Nullable;

public class ClassUtil {
    private static final StackWalker STACK = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private static final BiMap<Class<?>, Class<?>> BOXED = ImmutableBiMap.of(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Void.TYPE, Void.class);

    public static Class<?> boxed(Class<?> cls) {
        return (Class)BOXED.getOrDefault(cls, cls);
    }

    public static Class<?> unboxed(Class<?> cls) {
        return (Class)BOXED.inverse().getOrDefault(cls, cls);
    }

    @Nullable
    public static Class<?> forName(String cls) {
        Class<?> caller = STACK.getCallerClass();
        try {
            return Class.forName(cls, true, caller.getClassLoader());
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }

    @Nullable
    public static Class<?> callerClass(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("Negative stack frame index");
        }
        return STACK.walk(frames -> frames.map(StackWalker.StackFrame::getDeclaringClass).skip(level + 1).findFirst()).orElse(null);
    }
}

