/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.crafting;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.StatsUtil;
import com.minecolonies.core.Network;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingSifter;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.JobSifter;
import com.minecolonies.core.entity.ai.workers.crafting.AbstractEntityAICrafting;
import com.minecolonies.core.network.messages.client.LocalizedParticleEffectMessage;
import com.minecolonies.core.util.WorkerUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkSifter
extends AbstractEntityAICrafting<JobSifter, BuildingSifter> {
    private static final int MAX_LEVEL = 50;
    private static final int TICK_DELAY = 10;
    private static final int CHANCE_TO_DUMP_INV = 10;
    private static final int NO_MESH_DELAY = 100;
    protected int progress = 0;

    public EntityAIWorkSifter(@NotNull JobSifter job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.SIFT, this::sift, 10));
        this.worker.m_21553_(true);
    }

    @Override
    public Class<BuildingSifter> getExpectedBuildingClass() {
        return BuildingSifter.class;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    @Override
    protected IAIState decide() {
        return AIWorkerState.SIFT;
    }

    @Override
    public boolean hasWorkToDo() {
        return super.hasWorkToDo() || ((BuildingSifter)this.building).getCurrentDailyQuantity() < ((BuildingSifter)this.building).getMaxDailyQuantity();
    }

    protected IAIState sift() {
        if (((BuildingSifter)this.building).getCurrentDailyQuantity() >= ((BuildingSifter)this.building).getMaxDailyQuantity()) {
            return AIWorkerState.IDLE;
        }
        if (!this.walkToBuilding()) {
            return this.getState();
        }
        if (!this.worker.getInventoryCitizen().hasSpace()) {
            return AIWorkerState.INVENTORY_FULL;
        }
        if (this.currentRecipeStorage == null) {
            ICraftingBuildingModule module = (ICraftingBuildingModule)((BuildingSifter)this.building).getFirstModuleOccurance(BuildingSifter.CraftingModule.class);
            this.currentRecipeStorage = module.getFirstFulfillableRecipe(ItemStackUtils::isEmpty, 1, false);
        }
        if (this.currentRecipeStorage == null) {
            if (InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, i -> i.m_204117_(ModTags.meshes), 1) == 0) {
                if (InventoryUtils.getItemCountInProvider((ICapabilityProvider)this.worker, i -> i.m_204117_(ModTags.meshes)) > 0) {
                    this.incrementActionsDone();
                    return AIWorkerState.INVENTORY_FULL;
                }
                if (this.worker.getCitizenData() != null) {
                    this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.sifter.nomesh"), ChatPriority.IMPORTANT));
                    this.setDelay(100);
                }
            }
            if (!ItemStackUtils.isEmpty(this.worker.m_21205_())) {
                this.worker.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
            if (!ItemStackUtils.isEmpty(this.worker.m_21206_())) {
                this.worker.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
            }
            this.progress = 0;
            return AIWorkerState.START_WORKING;
        }
        ItemStack meshItem = this.currentRecipeStorage.getCraftingTools().get(0);
        ItemStack inputItem = this.currentRecipeStorage.getCleanedInput().stream().map(ItemStorage::getItemStack).filter(item -> !ItemStackUtils.compareItemStacksIgnoreStackSize(item, meshItem, false, true)).findFirst().orElse(ItemStack.f_41583_);
        if (meshItem.m_41619_() || inputItem.m_41619_()) {
            this.currentRecipeStorage = null;
            return this.getState();
        }
        if (!inputItem.m_41619_() && (ItemStackUtils.isEmpty(this.worker.m_21205_()) || ItemStackUtils.compareItemStacksIgnoreStackSize(this.worker.m_21205_(), inputItem).booleanValue())) {
            this.worker.m_21008_(InteractionHand.MAIN_HAND, inputItem);
        }
        if (!meshItem.m_41619_() && (ItemStackUtils.isEmpty(this.worker.m_21206_()) || ItemStackUtils.compareItemStacksIgnoreStackSize(this.worker.m_21206_(), meshItem, false, true))) {
            this.worker.m_21008_(InteractionHand.OFF_HAND, meshItem);
        }
        WorkerUtil.faceBlock(((BuildingSifter)this.building).getPosition(), this.worker);
        ++this.progress;
        if (this.progress > 50 - EntityAIWorkSifter.getEffectiveSkillLevel(this.getSecondarySkillLevel()) / 2) {
            this.progress = 0;
            ((BuildingSifter)this.building).setCurrentDailyQuantity(((BuildingSifter)this.building).getCurrentDailyQuantity() + 1);
            if (((BuildingSifter)this.building).getCurrentDailyQuantity() >= ((BuildingSifter)this.building).getMaxDailyQuantity() || this.worker.m_217043_().m_188503_(100) < 10) {
                this.incrementActionsDoneAndDecSaturation();
            }
            StatsUtil.trackStatByName((IBuilding)this.building, "item_used", inputItem.m_41786_(), inputItem.m_41613_());
            List<ItemStack> outputs = this.currentRecipeStorage.fullfillRecipeAndCopy(this.getLootContext(), ((BuildingSifter)this.building).getHandlers(), true);
            if (outputs == null) {
                this.currentRecipeStorage = null;
                return this.getState();
            }
            for (ItemStack stackForStats : outputs) {
                StatsUtil.trackStatByName((IBuilding)this.building, "item_obtained", stackForStats.m_41786_(), stackForStats.m_41613_());
            }
            this.worker.decreaseSaturationForContinuousAction();
            this.worker.getCitizenExperienceHandler().addExperience(0.2);
        }
        Network.getNetwork().sendToTrackingEntity(new LocalizedParticleEffectMessage(meshItem, ((BuildingSifter)this.building).getID()), (Entity)this.worker);
        Network.getNetwork().sendToTrackingEntity(new LocalizedParticleEffectMessage(inputItem, ((BuildingSifter)this.building).getID().m_7495_()), (Entity)this.worker);
        this.worker.m_6674_(InteractionHand.MAIN_HAND);
        SoundUtils.playSoundAtCitizen(this.world, ((BuildingSifter)this.building).getID(), SoundEvents.f_12033_);
        return this.getState();
    }
}

