/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.guard;

import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.jobs.JobRanger;
import com.minecolonies.core.entity.ai.workers.guard.AbstractEntityAIGuard;
import com.minecolonies.core.entity.ai.workers.guard.RangerCombatAI;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.pathfinding.navigation.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobWalkRandomEdge;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIRanger
extends AbstractEntityAIGuard<JobRanger, AbstractBuildingGuards> {
    public static final String RENDER_META_ARROW = "arrow";

    public EntityAIRanger(@NotNull JobRanger job) {
        super(job);
        this.toolsNeeded.add((EquipmentTypeEntry)ModEquipmentTypes.bow.get());
        new RangerCombatAI((EntityCitizen)this.worker, this.getStateAI(), this);
    }

    @Override
    protected void updateRenderMetaData() {
        Object renderMeta;
        Object object = renderMeta = this.getState() == AIWorkerState.IDLE ? "" : "working";
        if (this.worker.getCitizenInventoryHandler().hasItemInInventory(Items.f_42412_)) {
            renderMeta = (String)renderMeta + RENDER_META_ARROW;
        }
        this.worker.setRenderMetadata((String)renderMeta);
    }

    @Override
    protected void atBuildingActions() {
        super.atBuildingActions();
        if (this.worker.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARCHER_USE_ARROWS) > 0.0) {
            InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler(this.building, item -> item.m_41720_() instanceof ArrowItem, 64, (IItemHandler)this.worker.getInventoryCitizen());
            if (InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), item -> item.m_41720_() instanceof ArrowItem) < 16) {
                this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((ItemLike)Items.f_42412_), 64, 16);
            }
        }
    }

    @Override
    public void guardMovement() {
        if (this.worker.m_217043_().m_188503_(3) < 1) {
            this.walkToSafePos(this.buildingGuards.getGuardPos(this.worker));
            return;
        }
        if (BlockPosUtil.dist(this.buildingGuards.getGuardPos(this.worker), this.worker.m_20183_()) <= 10.0 || this.walkToSafePos(this.buildingGuards.getGuardPos(this.worker)) || Math.abs(this.buildingGuards.getGuardPos(this.worker).m_123342_() - this.worker.m_20183_().m_123342_()) > 3) {
            ((MinecoloniesAdvancedPathNavigate)this.worker.getNavigation()).setPathJob(new PathJobWalkRandomEdge(this.world, this.buildingGuards.getGuardPos(this.worker), 20, (Mob)this.worker), null, 1.0, true);
        }
    }
}

