/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.connections.DiplomacyStatus;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import com.minecolonies.core.util.TeleportHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class TeleportToColonyMessage
extends AbstractColonyServerMessage {
    private int originColonyId;
    private BlockPos pos;

    public TeleportToColonyMessage() {
    }

    public TeleportToColonyMessage(ResourceKey<Level> dimensionId, int colonyId, BlockPos pos, int originColonyId) {
        super(dimensionId, colonyId);
        this.pos = pos;
        this.originColonyId = originColonyId;
    }

    @Override
    @Nullable
    public Action permissionNeeded() {
        return null;
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        if (ctxIn.getSender() == null) {
            return;
        }
        IColony originColony = IColonyManager.getInstance().getColonyByDimension(this.originColonyId, (ResourceKey<Level>)ctxIn.getSender().f_19853_.m_46472_());
        if (originColony == null) {
            return;
        }
        if (originColony.getConnectionManager().getColonyDiplomacyStatus(colony.getID()) != DiplomacyStatus.ALLIES) {
            return;
        }
        if (originColony.getPermissions().hasPermission((Player)ctxIn.getSender(), Action.ACCESS_HUTS) || colony.getPermissions().hasPermission((Player)ctxIn.getSender(), Action.ACCESS_HUTS)) {
            TeleportHelper.colonyTeleport(ctxIn.getSender(), colony, this.pos);
        }
    }

    @Override
    protected void toBytesOverride(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.originColonyId);
    }

    @Override
    protected void fromBytesOverride(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.originColonyId = buf.readInt();
    }
}

