/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.splitting;

import com.google.common.cache.Cache;
import com.google.common.collect.Maps;
import com.google.common.primitives.Bytes;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.Network;
import com.minecolonies.core.network.NetworkChannel;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SplitPacketMessage
implements IMessage {
    private int communicationId = -1;
    private int packetIndex = -1;
    private boolean terminator = false;
    private int innerMessageId = -1;
    private byte[] payload;

    public SplitPacketMessage() {
    }

    public SplitPacketMessage(int communicationId, int packetIndex, boolean terminator, int innerMessageId, byte[] payload) {
        this.communicationId = communicationId;
        this.packetIndex = packetIndex;
        this.terminator = terminator;
        this.innerMessageId = innerMessageId;
        this.payload = payload;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130130_(this.communicationId);
        buf.m_130130_(this.packetIndex);
        buf.writeBoolean(this.terminator);
        buf.m_130130_(this.innerMessageId);
        buf.m_130087_(this.payload);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.communicationId = buf.m_130242_();
        this.packetIndex = buf.m_130242_();
        this.terminator = buf.readBoolean();
        this.innerMessageId = buf.m_130242_();
        this.payload = buf.m_130052_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        try {
            Cache<Integer, Map<Integer, byte[]>> cache = Network.getNetwork().getMessageCache();
            synchronized (cache) {
                ((Map)Network.getNetwork().getMessageCache().get((Object)this.communicationId, Maps::newConcurrentMap)).put(this.packetIndex, this.payload);
            }
            if (!this.terminator) {
                return;
            }
            byte[] packetData = ((Map)Network.getNetwork().getMessageCache().get((Object)this.communicationId, Maps::newConcurrentMap)).entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).reduce(new byte[0], (xva$0, xva$1) -> Bytes.concat((byte[][])new byte[][]{xva$0, xva$1}));
            NetworkChannel.NetworkingMessageEntry<?> messageEntry = Network.getNetwork().getMessagesTypes().get(this.innerMessageId);
            IMessage message = (IMessage)messageEntry.getCreator().get();
            ByteBuf buffer = Unpooled.wrappedBuffer((byte[])packetData);
            try {
                message.fromBytes(new FriendlyByteBuf(buffer));
            }
            catch (Exception e) {
                Log.getLogger().error("Packet error:", (Throwable)e);
                buffer.release();
                return;
            }
            buffer.release();
            LogicalSide packetOrigin = ctxIn.getDirection().getOriginationSide();
            if (message.getExecutionSide() != null && packetOrigin.equals((Object)message.getExecutionSide())) {
                Log.getLogger().warn("Receving {} at wrong side!", (Object)message.getClass().getName());
                return;
            }
            ctxIn.enqueueWork(() -> {
                try {
                    message.onExecute(ctxIn, packetOrigin.equals((Object)LogicalSide.CLIENT));
                }
                catch (Exception e) {
                    Log.getLogger().error("Packet error:", (Throwable)e);
                }
            });
        }
        catch (ExecutionException e) {
            Log.getLogger().error("Failed to handle split packet.", (Throwable)e);
        }
    }
}

