/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.tileentities;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.connections.ColonyConnectionNode;
import com.minecolonies.api.tileentities.ITickable;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.WorldUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityColonySign
extends BlockEntity
implements ITickable {
    private int colonyId = -1;
    private int targetColonyId = -1;
    private BlockPos anchor = null;
    private String colonyNameCache = "";
    private String targetColonyNameCache = "";
    private float rotation;
    private int distance;
    private int targetColonyDistance;
    private final int tickOffset = MathUtils.RANDOM.nextInt(20);

    public TileEntityColonySign(BlockPos pos, BlockState state) {
        super((BlockEntityType)MinecoloniesTileEntities.COLONY_SIGN.get(), pos, state);
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            WorldUtil.markChunkDirty(this.f_58857_, this.f_58858_);
        }
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.colonyId = compound.m_128451_("colony");
        this.colonyNameCache = compound.m_128461_("name");
        this.anchor = BlockPosUtil.read(compound, "pos");
        this.rotation = compound.m_128457_("rotation");
        this.targetColonyId = compound.m_128451_("targetcolony");
        this.targetColonyNameCache = compound.m_128461_("targetname");
        this.distance = compound.m_128451_("distance");
        this.targetColonyDistance = compound.m_128451_("targetdistance");
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("colony", this.colonyId);
        compound.m_128359_("name", this.colonyNameCache);
        BlockPosUtil.write(compound, "pos", this.anchor);
        compound.m_128350_("rotation", this.rotation);
        compound.m_128405_("targetcolony", this.targetColonyId);
        compound.m_128359_("targetname", this.targetColonyNameCache);
        compound.m_128405_("distance", this.distance);
        compound.m_128405_("targetdistance", this.targetColonyDistance);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag compound = packet.m_131708_();
        this.m_142466_(compound);
    }

    @Override
    public void tick() {
        IColony colony;
        if (!this.f_58857_.f_46443_ && (this.f_58857_.m_46467_() + (long)this.tickOffset) % 20L * 60L == 0L && (colony = IColonyManager.getInstance().getColonyByDimension(this.colonyId, (ResourceKey<Level>)this.f_58857_.m_46472_())) != null) {
            this.colonyNameCache = colony.getName();
            ColonyConnectionNode node = colony.getConnectionManager().getNode(this.m_58899_());
            if (node != null) {
                BlockPos previousNodePos = node.getPreviousNode();
                if (!previousNodePos.equals((Object)BlockPos.f_121853_) && WorldUtil.isBlockLoaded((LevelAccessor)this.f_58857_, previousNodePos)) {
                    BlockEntity blockEntity = this.f_58857_.m_7702_(previousNodePos);
                    if (blockEntity instanceof TileEntityColonySign) {
                        TileEntityColonySign tileEntityColonySign = (TileEntityColonySign)blockEntity;
                        this.distance = (int)BlockPosUtil.dist(previousNodePos, this.m_58899_()) + tileEntityColonySign.distance;
                    } else {
                        this.distance = (int)BlockPosUtil.dist(previousNodePos, this.m_58899_());
                    }
                    this.m_6596_();
                }
                this.targetColonyId = node.getTargetColonyId();
                if (this.targetColonyId != -1) {
                    IColony targetColony;
                    BlockPos nextNodePos = node.getNextNode();
                    if (!nextNodePos.equals((Object)BlockPos.f_121853_) && WorldUtil.isBlockLoaded((LevelAccessor)this.f_58857_, nextNodePos)) {
                        BlockEntity blockEntity = this.f_58857_.m_7702_(nextNodePos);
                        if (blockEntity instanceof TileEntityColonySign) {
                            TileEntityColonySign tileEntityColonySign = (TileEntityColonySign)blockEntity;
                            this.targetColonyDistance = (int)BlockPosUtil.dist(nextNodePos, this.m_58899_()) + tileEntityColonySign.targetColonyDistance;
                        } else {
                            this.targetColonyDistance = (int)BlockPosUtil.dist(nextNodePos, this.m_58899_());
                        }
                        this.m_6596_();
                    }
                    if ((targetColony = IColonyManager.getInstance().getColonyByDimension(this.targetColonyId, (ResourceKey<Level>)this.f_58857_.m_46472_())) != null) {
                        this.targetColonyNameCache = targetColony.getName();
                        this.m_6596_();
                    }
                }
            }
            this.m_6596_();
        }
    }

    public void setColonyAndAnchor(IColony colony, @Nullable BlockPos anchor) {
        this.colonyId = colony.getID();
        this.anchor = anchor == null ? colony.getCenter() : anchor;
        this.distance = (int)BlockPosUtil.dist(colony.getCenter(), this.m_58899_());
        this.colonyNameCache = colony.getName();
        double dx = (double)this.anchor.m_123341_() + 0.5 - ((double)this.m_58899_().m_123341_() + 0.5);
        double dz = (double)this.anchor.m_123343_() + 0.5 - ((double)this.m_58899_().m_123343_() + 0.5);
        double angleRad = Math.atan2(-dz, dx);
        float angleDeg = (float)Math.toDegrees(angleRad);
        this.rotation = (angleDeg + 360.0f) % 360.0f;
    }

    public String getColonyName() {
        return this.colonyNameCache;
    }

    public float getRelativeRotation() {
        return this.rotation;
    }

    public int getColonyDistance() {
        return this.distance;
    }

    public int getColonyId() {
        return this.colonyId;
    }

    public int getTargetColonyId() {
        return this.targetColonyId;
    }

    public String getTargetColonyName() {
        return this.targetColonyNameCache;
    }

    public int getTargetColonyDistance() {
        return this.targetColonyDistance;
    }
}

