/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.registry.MaterialRegistry;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public interface IMaterialRegistryManager {
    @NotNull
    public MaterialRegistry createRegistry(@NotNull String var1);

    @NotNull
    public MaterialRegistry getRegistry(@NotNull String var1);

    @NotNull
    public MaterialRegistry getRegistry(int var1);

    @NotNull
    public Collection<MaterialRegistry> getRegistries();

    @NotNull
    public Collection<Material> getRegisteredMaterials();

    public Material getMaterial(String var1);

    public ResourceLocation getKey(Material var1);

    @NotNull
    public Phase getPhase();

    default public boolean canModifyMaterials() {
        return this.getPhase() != Phase.FROZEN && this.getPhase() != Phase.PRE;
    }

    default public Codec<Material> codec() {
        return ResourceLocation.f_135803_.flatXmap(id -> Optional.ofNullable((Material)this.getRegistry(id.m_135827_()).get(id.m_135815_())).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in material registry: " + String.valueOf(id))), obj -> DataResult.success((Object)obj.getResourceLocation()));
    }

    public static enum Phase {
        PRE,
        OPEN,
        CLOSED,
        FROZEN;

    }
}

