/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material.stack;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;

public record MaterialStack(@NotNull Material material, long amount) {
    public static final MaterialStack EMPTY = new MaterialStack(GTMaterials.NULL, 0L);
    private static final Map<String, MaterialStack> PARSE_CACHE = new WeakHashMap<String, MaterialStack>();

    public MaterialStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new MaterialStack(this.material, this.amount);
    }

    public MaterialStack add(long amount) {
        return new MaterialStack(this.material, this.amount + amount);
    }

    public MaterialStack multiply(long amount) {
        return new MaterialStack(this.material, this.amount * amount);
    }

    public MaterialStack divide(long amount) {
        return new MaterialStack(this.material, this.amount / amount);
    }

    public static MaterialStack fromString(CharSequence str) {
        String trimmed;
        String copy = trimmed = str.toString().trim();
        MaterialStack cached = PARSE_CACHE.get(trimmed);
        if (cached != null) {
            return cached;
        }
        int count = 1;
        int spaceIndex = copy.indexOf(32);
        if (spaceIndex >= 2 && copy.indexOf(120) == spaceIndex - 1) {
            count = Integer.parseInt(copy.substring(0, spaceIndex - 1));
            copy = copy.substring(spaceIndex + 1);
        }
        cached = new MaterialStack(GTMaterials.get(copy), count);
        PARSE_CACHE.put(trimmed, cached);
        return cached;
    }

    public boolean isEmpty() {
        return this.material == GTMaterials.NULL || this.amount < 1L;
    }

    @Override
    public String toString() {
        Object string = "";
        if (this.isEmpty()) {
            return "";
        }
        string = this.material.getChemicalFormula() == null || this.material.getChemicalFormula().isEmpty() ? (String)string + "?" : (this.material.getMaterialComponents().size() > 1 ? (String)string + "(" + this.material.getChemicalFormula() + ")" : (String)string + this.material.getChemicalFormula());
        if (this.amount > 1L) {
            string = (String)string + FormattingUtil.toSmallDownNumbers(Long.toString(this.amount));
        }
        return string;
    }
}

