/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.armor;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.core.mixins.ServerGamePacketListenerImplAccessor;
import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class ArmorUtils {
    public static final int MIN_NIGHTVISION_CHARGE = 4;
    public static final int NIGHTVISION_DURATION = 400;
    public static final int NIGHT_VISION_RESET = 240;

    public static boolean isPossibleToCharge(ItemStack chargeable) {
        IElectricItem container = GTCapabilityHelper.getElectricItem(chargeable);
        if (container != null) {
            return container.getCharge() < container.getMaxCharge() && container.getCharge() + container.getTransferLimit() <= container.getMaxCharge();
        }
        return false;
    }

    public static List<Pair<NonNullList<ItemStack>, IntList>> getChargeableItem(Player player, int tier) {
        ItemStack offHand;
        IElectricItem offHandItem;
        ArrayList<Pair<NonNullList<ItemStack>, IntList>> inventorySlotMap = new ArrayList<Pair<NonNullList<ItemStack>, IntList>>();
        IntArrayList openMainSlots = new IntArrayList();
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack current = (ItemStack)player.m_150109_().f_35974_.get(i);
            IElectricItem item = GTCapabilityHelper.getElectricItem(current);
            if (item == null || !ArmorUtils.isPossibleToCharge(current) || item.getTier() > tier) continue;
            openMainSlots.add(i);
        }
        if (!openMainSlots.isEmpty()) {
            inventorySlotMap.add(Pair.of((Object)player.m_150109_().f_35974_, (Object)openMainSlots));
        }
        IntArrayList openArmorSlots = new IntArrayList();
        for (int i = 0; i < player.m_150109_().f_35975_.size(); ++i) {
            ItemStack current = (ItemStack)player.m_150109_().f_35975_.get(i);
            IElectricItem item = GTCapabilityHelper.getElectricItem(current);
            if (item == null || !ArmorUtils.isPossibleToCharge(current) || item.getTier() > tier) continue;
            openArmorSlots.add(i);
        }
        if (!openArmorSlots.isEmpty()) {
            inventorySlotMap.add(Pair.of((Object)player.m_150109_().f_35975_, (Object)openArmorSlots));
        }
        if ((offHandItem = GTCapabilityHelper.getElectricItem(offHand = (ItemStack)player.m_150109_().f_35976_.get(0))) == null) {
            return inventorySlotMap;
        }
        if (ArmorUtils.isPossibleToCharge(offHand) && offHandItem.getTier() <= tier) {
            inventorySlotMap.add((Pair<NonNullList<ItemStack>, IntList>)Pair.of((Object)player.m_150109_().f_35976_, (Object)new IntArrayList(new int[]{0})));
        }
        return inventorySlotMap;
    }

    public static void spawnParticle(Level world, Player player, ParticleOptions type, double speedY) {
        if (type != null) {
            Vec3 forward = player.m_20156_();
            world.m_7106_(type, player.m_20185_() - forward.f_82479_, player.m_20186_() + 0.5, player.m_20189_() - forward.f_82481_, 0.0, speedY, 0.0);
        }
    }

    public static void playJetpackSound(@Nonnull Player player) {
        if (player.m_9236_().m_5776_()) {
            float cons = (float)player.m_20184_().f_82480_ + player.f_19788_;
            cons = Mth.m_14036_((float)cons, (float)0.6f, (float)1.0f);
            if (player.m_20184_().f_82480_ > (double)0.05f) {
                cons += 0.1f;
            }
            if (player.m_20184_().f_82480_ < (double)-0.05f) {
                cons -= 0.4f;
            }
            player.m_5496_(GTSoundEntries.JET_ENGINE.getMainEvent(), 0.3f, cons);
        }
    }

    public static void resetPlayerFloatingTime(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ((ServerGamePacketListenerImplAccessor)serverPlayer.f_8906_).setAboveGroundTickCount(0);
        }
    }

    public static InteractionResultHolder<ItemStack> eat(Player player, ItemStack food) {
        if (!food.m_41614_()) {
            return InteractionResultHolder.m_19100_((Object)food);
        }
        FoodProperties foodItem = food.getFoodProperties((LivingEntity)player);
        if (foodItem != null && player.m_36324_().m_38721_()) {
            ItemStack result = ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)food.m_41777_(), (int)player.m_21212_(), (ItemStack)food.m_41671_(player.m_9236_(), (LivingEntity)player));
            return InteractionResultHolder.m_19090_((Object)result);
        }
        return InteractionResultHolder.m_19100_((Object)food);
    }

    public static List<ItemStack> format(List<ItemStack> input) {
        Object2IntOpenCustomHashMap items = new Object2IntOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (ItemStack itemStack : input) {
            if (items.containsKey((Object)itemStack)) {
                int amount = items.getInt((Object)itemStack);
                items.replace((Object)itemStack, ++amount);
                continue;
            }
            items.put((Object)itemStack, 1);
        }
        for (Object2IntMap.Entry entry : items.object2IntEntrySet()) {
            ItemStack stack = ((ItemStack)entry.getKey()).m_41777_();
            stack.m_41764_(entry.getIntValue());
            output.add(stack);
        }
        return output;
    }

    @Nonnull
    public static String format(long value) {
        return new DecimalFormat("###,###.##").format(value);
    }

    public static String format(double value) {
        return new DecimalFormat("###,###.##").format(value);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ModularHUD {
        private byte stringAmount = 0;
        private final List<Component> stringList = new ArrayList<Component>();
        private static final Minecraft mc = Minecraft.m_91087_();

        public void newString(Component string) {
            this.stringAmount = (byte)(this.stringAmount + 1);
            this.stringList.add(string);
        }

        public void draw(GuiGraphics poseStack) {
            for (int i = 0; i < this.stringAmount; ++i) {
                IntIntPair coords = this.getStringCoord(i);
                poseStack.m_280614_(ModularHUD.mc.f_91062_, this.stringList.get(i), coords.firstInt(), coords.secondInt(), 0xFFFFFF, false);
            }
        }

        @Nonnull
        private IntIntPair getStringCoord(int index) {
            int posX;
            Objects.requireNonNull(ModularHUD.mc.f_91062_);
            int fontHeight = 9;
            int windowHeight = mc.m_91268_().m_85446_();
            int windowWidth = mc.m_91268_().m_85445_();
            int stringWidth = ModularHUD.mc.f_91062_.m_92852_((FormattedText)this.stringList.get(index));
            return IntIntPair.of((int)posX, (int)(switch (ConfigHolder.INSTANCE.client.armorHud.hudLocation) {
                case 1 -> {
                    posX = 1 + ConfigHolder.INSTANCE.client.armorHud.hudOffsetX;
                    yield 1 + ConfigHolder.INSTANCE.client.armorHud.hudOffsetY + fontHeight * index;
                }
                case 2 -> {
                    posX = windowWidth - (1 + ConfigHolder.INSTANCE.client.armorHud.hudOffsetX) - stringWidth;
                    yield 1 + ConfigHolder.INSTANCE.client.armorHud.hudOffsetY + fontHeight * index;
                }
                case 3 -> {
                    posX = 1 + ConfigHolder.INSTANCE.client.armorHud.hudOffsetX;
                    yield windowHeight - fontHeight * (this.stringAmount - index) - 1 - ConfigHolder.INSTANCE.client.armorHud.hudOffsetY;
                }
                case 4 -> {
                    posX = windowWidth - (1 + ConfigHolder.INSTANCE.client.armorHud.hudOffsetX) - stringWidth;
                    yield windowHeight - fontHeight * (this.stringAmount - index) - 1 - ConfigHolder.INSTANCE.client.armorHud.hudOffsetY;
                }
                default -> throw new IllegalArgumentException("Armor Hud config hudLocation is improperly configured. Allowed values: [1,2,3,4]");
            }));
        }

        public void reset() {
            this.stringAmount = 0;
            this.stringList.clear();
        }
    }
}

