/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.property.GTMachineModelProperties;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.UpdateListener;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MultiblockPartMachine
extends MetaMachine
implements IMultiPart {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MultiblockPartMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    @DescSynced
    @UpdateListener(methodName="onControllersUpdated")
    protected final Set<BlockPos> controllerPositions = new ObjectOpenHashSet(8);
    protected final SortedSet<IMultiController> controllers = new ReferenceLinkedOpenHashSet(8);
    @Nullable
    private RecipeHandlerList handlerList;

    public MultiblockPartMachine(IMachineBlockEntity holder) {
        super(holder);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public boolean hasController(BlockPos controllerPos) {
        return this.controllerPositions.contains(controllerPos);
    }

    @Override
    public boolean isFormed() {
        return !this.controllerPositions.isEmpty();
    }

    public void onControllersUpdated(Set<BlockPos> newPositions, Set<BlockPos> old) {
        this.controllers.clear();
        for (BlockPos blockPos : newPositions) {
            MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)this.getLevel(), blockPos);
            if (!(metaMachine instanceof IMultiController)) continue;
            IMultiController controller = (IMultiController)((Object)metaMachine);
            this.controllers.add(controller);
        }
    }

    @Override
    public @UnmodifiableView SortedSet<IMultiController> getControllers() {
        if (this.controllers.size() != this.controllerPositions.size()) {
            this.onControllersUpdated(this.controllerPositions, Collections.emptySet());
        }
        return Collections.unmodifiableSortedSet(this.controllers);
    }

    @Override
    public List<RecipeHandlerList> getRecipeHandlers() {
        return List.of(this.getHandlerList());
    }

    protected RecipeHandlerList getHandlerList() {
        if (this.handlerList == null) {
            ArrayList handlers = new ArrayList();
            IO handlerIO = null;
            for (MachineTrait trait : this.traits) {
                if (!(trait instanceof IRecipeHandlerTrait)) continue;
                IRecipeHandlerTrait rht = (IRecipeHandlerTrait)((Object)trait);
                if (handlerIO == null) {
                    handlerIO = rht.getHandlerIO();
                }
                handlers.add(rht);
            }
            this.handlerList = handlers.isEmpty() ? RecipeHandlerList.NO_DATA : RecipeHandlerList.of(handlerIO, this.getPaintingColor(), handlers);
        }
        return this.handlerList;
    }

    @Override
    public void onUnload() {
        super.onUnload();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Object toIter = this.controllers.size() > 1 ? new ObjectOpenHashSet(this.controllers) : this.controllers;
            Iterator iterator = toIter.iterator();
            while (iterator.hasNext()) {
                IMultiController controller = (IMultiController)iterator.next();
                if (!serverLevel.m_46749_(controller.self().getPos())) continue;
                this.removedFromController(controller);
                controller.onPartUnload();
            }
        }
        this.controllerPositions.clear();
        this.controllers.clear();
    }

    @Override
    @MustBeInvokedByOverriders
    public void removedFromController(IMultiController controller) {
        MachineRenderState renderState;
        this.controllerPositions.remove(controller.self().getPos());
        this.controllers.remove(controller);
        if (this.controllers.isEmpty() && (renderState = this.getRenderState()).m_61138_((Property)GTMachineModelProperties.IS_FORMED)) {
            this.setRenderState((MachineRenderState)((Object)renderState.m_61124_((Property)GTMachineModelProperties.IS_FORMED, Boolean.valueOf(false))));
        }
    }

    @Override
    @MustBeInvokedByOverriders
    public void addedToController(IMultiController controller) {
        this.controllerPositions.add(controller.self().getPos());
        this.controllers.add(controller);
        MachineRenderState renderState = this.getRenderState();
        if (renderState.m_61138_((Property)GTMachineModelProperties.IS_FORMED)) {
            this.setRenderState((MachineRenderState)((Object)renderState.m_61124_((Property)GTMachineModelProperties.IS_FORMED, Boolean.valueOf(true))));
        }
    }
}

