/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.ICapabilityTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderFluidIngredient;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class NotifiableFluidTank
extends NotifiableRecipeHandlerTrait<FluidIngredient>
implements ICapabilityTrait,
IFluidHandlerModifiable {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(NotifiableFluidTank.class, NotifiableRecipeHandlerTrait.MANAGED_FIELD_HOLDER);
    public final IO handlerIO;
    public final IO capabilityIO;
    @Persisted
    protected final CustomFluidTank[] storages;
    protected boolean allowSameFluids;
    private Boolean isEmpty;
    @Persisted
    @DescSynced
    protected final CustomFluidTank lockedFluid = new CustomFluidTank(1000);
    protected Predicate<FluidStack> filter = f -> true;

    public NotifiableFluidTank(MetaMachine machine, int slots, int capacity, IO io, IO capabilityIO) {
        super(machine);
        this.handlerIO = io;
        this.storages = new CustomFluidTank[slots];
        this.capabilityIO = capabilityIO;
        for (int i = 0; i < this.storages.length; ++i) {
            this.storages[i] = new CustomFluidTank(capacity);
            this.storages[i].setOnContentsChanged(this::onContentsChanged);
        }
    }

    public NotifiableFluidTank(MetaMachine machine, List<CustomFluidTank> storages, IO io, IO capabilityIO) {
        super(machine);
        this.handlerIO = io;
        this.storages = (CustomFluidTank[])storages.toArray(CustomFluidTank[]::new);
        this.capabilityIO = capabilityIO;
        for (CustomFluidTank storage : this.storages) {
            storage.setOnContentsChanged(this::onContentsChanged);
        }
        if (io == IO.IN) {
            this.allowSameFluids = true;
        }
    }

    public NotifiableFluidTank(MetaMachine machine, int slots, int capacity, IO io) {
        this(machine, slots, capacity, io, io);
    }

    public NotifiableFluidTank(MetaMachine machine, List<CustomFluidTank> storages, IO io) {
        this(machine, storages, io, io);
    }

    public void onContentsChanged() {
        this.isEmpty = null;
        this.notifyListeners();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public List<FluidIngredient> handleRecipeInner(IO io, GTRecipe recipe, List<FluidIngredient> left, boolean simulate) {
        if (io != this.handlerIO) {
            return left;
        }
        if (io != IO.IN && io != IO.OUT) {
            return left.isEmpty() ? null : left;
        }
        Runnable[] listeners = new Runnable[this.storages.length];
        for (int i = 0; i < this.storages.length; ++i) {
            listeners[i] = this.storages[i].getOnContentsChanged();
            this.storages[i].setOnContentsChanged(() -> {});
        }
        boolean changed = false;
        IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
        FluidStack[] visited = new FluidStack[this.storages.length];
        Iterator<FluidIngredient> it = left.iterator();
        while (it.hasNext()) {
            FluidStack[] fluids;
            FluidIngredient ingredient = it.next();
            if (ingredient.isEmpty()) {
                it.remove();
                continue;
            }
            if (io == IO.OUT && ingredient instanceof IntProviderFluidIngredient) {
                IntProviderFluidIngredient provider = (IntProviderFluidIngredient)ingredient;
                provider.setFluidStacks(null);
                provider.setSampledCount(-1);
                fluids = simulate ? new FluidStack[]{provider.getMaxSizeStack()} : provider.getStacks();
            } else {
                fluids = ingredient.getStacks();
            }
            if (fluids.length == 0 || fluids[0].isEmpty()) {
                it.remove();
                continue;
            }
            int amount = fluids[0].getAmount();
            if (io == IO.OUT && !this.allowSameFluids) {
                CustomFluidTank existing = null;
                int tank = 0;
                for (int i = 0; i < this.storages.length; ++i) {
                    CustomFluidTank storage = this.storages[i];
                    if (storage.getFluid().isEmpty() || !storage.getFluid().isFluidEqual(fluids[0])) continue;
                    existing = storage;
                    tank = i;
                    break;
                }
                if (existing != null) {
                    FluidStack output = fluids[0].copy();
                    output.setAmount(amount);
                    int filled = existing.fill(output, action);
                    if (filled > 0) {
                        visited[tank] = output.copy();
                        visited[tank].setAmount(existing.getFluidAmount());
                        changed = true;
                    }
                    if ((amount -= filled) > 0) {
                        ingredient.setAmount(amount);
                        continue;
                    }
                    it.remove();
                    continue;
                }
            }
            for (int tank = 0; tank < this.storages.length; ++tank) {
                FluidStack current = visited[tank] == null ? this.getFluidInTank(tank) : visited[tank];
                int count = current.getAmount();
                if (io == IO.IN) {
                    if (current.isEmpty()) continue;
                    if (ingredient.test(current)) {
                        FluidStack drained = this.storages[tank].drain(Math.min(count, amount), action);
                        if (!drained.isEmpty()) {
                            visited[tank] = drained.copy();
                            visited[tank].setAmount(count - drained.getAmount());
                            changed = true;
                        }
                        amount -= drained.getAmount();
                    }
                } else {
                    int filled;
                    FluidStack output = fluids[0].copy();
                    output.setAmount(amount);
                    if ((visited[tank] == null || visited[tank].isFluidEqual(output)) && count < this.storages[tank].getCapacity() && (filled = this.storages[tank].fill(output, action)) > 0) {
                        visited[tank] = output.copy();
                        visited[tank].setAmount(count + filled);
                        changed = true;
                        amount -= filled;
                        if (!this.allowSameFluids) {
                            if (amount > 0) break;
                            it.remove();
                            break;
                        }
                    }
                }
                if (amount > 0) continue;
                it.remove();
                break;
            }
            if (amount <= 0) continue;
            ingredient.setAmount(amount);
        }
        for (int i = 0; i < this.storages.length; ++i) {
            this.storages[i].setOnContentsChanged(listeners[i]);
            if (!changed || !action.execute()) continue;
            listeners[i].run();
        }
        return left.isEmpty() ? null : left;
    }

    @Override
    public boolean test(FluidIngredient ingredient) {
        return !this.isLocked() || ingredient.test(this.lockedFluid.getFluid());
    }

    @Override
    public int getPriority() {
        return !this.isLocked() || this.lockedFluid.getFluid().isEmpty() ? super.getPriority() : 0x3FFFFFFF - this.getTanks();
    }

    public boolean isLocked() {
        return !this.lockedFluid.getFluid().isEmpty();
    }

    public void setLocked(boolean locked) {
        this.setLocked(locked, this.storages[0].getFluid());
    }

    public void setLocked(boolean locked, FluidStack fluidStack) {
        if (this.isLocked() == locked) {
            return;
        }
        if (locked && !fluidStack.isEmpty()) {
            this.lockedFluid.setFluid(fluidStack.copy());
            this.lockedFluid.getFluid().setAmount(1);
            this.setFilter(stack -> stack.isFluidEqual(this.lockedFluid.getFluid()));
        } else {
            this.lockedFluid.setFluid(FluidStack.EMPTY);
            this.setFilter(stack -> true);
        }
        this.onContentsChanged();
    }

    public NotifiableFluidTank setFilter(Predicate<FluidStack> filter) {
        this.filter = filter;
        for (CustomFluidTank storage : this.storages) {
            storage.setValidator(filter);
        }
        return this;
    }

    @Override
    public RecipeCapability<FluidIngredient> getCapability() {
        return FluidRecipeCapability.CAP;
    }

    public int getTanks() {
        return this.storages.length;
    }

    @Override
    public int getSize() {
        return this.getTanks();
    }

    @Override
    @NotNull
    public List<Object> getContents() {
        ArrayList<FluidStack> ingredients = new ArrayList<FluidStack>();
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidStack stack = this.getFluidInTank(i);
            if (stack.isEmpty()) continue;
            ingredients.add(stack);
        }
        return new ArrayList<Object>(ingredients);
    }

    @Override
    public double getTotalContentAmount() {
        long amount = 0L;
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidStack stack = this.getFluidInTank(i);
            if (stack.isEmpty()) continue;
            amount += (long)stack.getAmount();
        }
        return amount;
    }

    public boolean isEmpty() {
        if (this.isEmpty == null) {
            this.isEmpty = true;
            for (CustomFluidTank storage : this.storages) {
                if (storage.getFluid().isEmpty()) continue;
                this.isEmpty = false;
                break;
            }
        }
        return this.isEmpty;
    }

    public void exportToNearby(Direction ... facings) {
        if (this.isEmpty()) {
            return;
        }
        Level level = this.getMachine().getLevel();
        BlockPos pos = this.getMachine().getPos();
        for (Direction facing : facings) {
            Predicate<FluidStack> filter = this.getMachine().getFluidCapFilter(facing, IO.OUT);
            GTTransferUtils.getAdjacentFluidHandler(level, pos, facing).ifPresent(adj -> GTTransferUtils.transferFluidsFiltered(this, adj, filter));
        }
    }

    public void importFromNearby(Direction ... facings) {
        Level level = this.getMachine().getLevel();
        BlockPos pos = this.getMachine().getPos();
        for (Direction facing : facings) {
            Predicate<FluidStack> filter = this.getMachine().getFluidCapFilter(facing, IO.IN);
            GTTransferUtils.getAdjacentFluidHandler(level, pos, facing).ifPresent(adj -> GTTransferUtils.transferFluidsFiltered(adj, this, filter));
        }
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.storages[tank].getFluid();
    }

    @Override
    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
        this.storages[tank].setFluid(fluidStack);
    }

    public int getTankCapacity(int tank) {
        return this.storages[tank].getCapacity();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.storages[tank].isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.canCapInput()) {
            return 0;
        }
        return this.fillInternal(resource, action);
    }

    public int fillInternal(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        FluidStack copied = resource.copy();
        CustomFluidTank existingStorage = null;
        if (!this.allowSameFluids) {
            for (CustomFluidTank storage : this.storages) {
                if (storage.getFluid().isEmpty() || !storage.getFluid().isFluidEqual(resource)) continue;
                existingStorage = storage;
                break;
            }
        }
        if (existingStorage == null) {
            for (CustomFluidTank storage : this.storages) {
                int filled = storage.fill(copied.copy(), action);
                if (filled > 0) {
                    copied.shrink(filled);
                    if (!this.allowSameFluids) break;
                }
                if (!copied.isEmpty()) {
                    continue;
                }
                break;
            }
        } else {
            copied.shrink(existingStorage.fill(copied.copy(), action));
        }
        return resource.getAmount() - copied.getAmount();
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.canCapOutput()) {
            return this.drainInternal(resource, action);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drainInternal(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack copied = resource.copy();
        for (CustomFluidTank storage : this.storages) {
            FluidStack candidate = copied.copy();
            copied.shrink(storage.drain(candidate, action).getAmount());
            if (copied.isEmpty()) break;
        }
        copied.setAmount(resource.getAmount() - copied.getAmount());
        return copied;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.canCapOutput()) {
            return this.drainInternal(maxDrain, action);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drainInternal(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain == 0) {
            return FluidStack.EMPTY;
        }
        FluidStack totalDrained = null;
        for (CustomFluidTank storage : this.storages) {
            if (totalDrained == null || totalDrained.isEmpty()) {
                totalDrained = storage.drain(maxDrain, action);
                if (totalDrained.isEmpty()) {
                    totalDrained = null;
                } else {
                    maxDrain -= totalDrained.getAmount();
                }
            } else {
                FluidStack copy = totalDrained.copy();
                copy.setAmount(maxDrain);
                FluidStack drain = storage.drain(copy, action);
                totalDrained.grow(drain.getAmount());
                maxDrain -= drain.getAmount();
            }
            if (maxDrain <= 0) break;
        }
        return totalDrained == null ? FluidStack.EMPTY : totalDrained;
    }

    @Override
    public void onMachineLoad() {
        super.onMachineLoad();
        if (this.isLocked()) {
            this.setFilter(stack -> stack.isFluidEqual(this.lockedFluid.getFluid()));
        }
    }

    @Override
    @Generated
    public IO getHandlerIO() {
        return this.handlerIO;
    }

    @Override
    @Generated
    public IO getCapabilityIO() {
        return this.capabilityIO;
    }

    @Generated
    public CustomFluidTank[] getStorages() {
        return this.storages;
    }

    @Generated
    public boolean isAllowSameFluids() {
        return this.allowSameFluids;
    }

    @Generated
    public CustomFluidTank getLockedFluid() {
        return this.lockedFluid;
    }

    @Generated
    public Predicate<FluidStack> getFilter() {
        return this.filter;
    }
}

