/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc;

import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.recipe.ingredient.EnergyStack;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.Direction;

public class EnergyContainerList
implements IEnergyContainer {
    private final List<? extends IEnergyContainer> energyContainerList;
    private final long inputVoltage;
    private final long outputVoltage;
    private final long inputAmperage;
    private final long outputAmperage;
    private final long highestInputVoltage;
    private final int numHighestInputContainers;

    public EnergyContainerList(List<? extends IEnergyContainer> energyContainerList) {
        this.energyContainerList = energyContainerList;
        long totalInputVoltage = 0L;
        long totalOutputVoltage = 0L;
        long inputAmperage = 0L;
        long outputAmperage = 0L;
        long highestInputVoltage = 0L;
        int numHighestInputContainers = 0;
        for (IEnergyContainer iEnergyContainer : energyContainerList) {
            totalInputVoltage += iEnergyContainer.getInputVoltage() * iEnergyContainer.getInputAmperage();
            totalOutputVoltage += iEnergyContainer.getOutputVoltage() * iEnergyContainer.getOutputAmperage();
            inputAmperage += iEnergyContainer.getInputAmperage();
            outputAmperage += iEnergyContainer.getOutputAmperage();
            if (iEnergyContainer.getInputVoltage() <= highestInputVoltage) continue;
            highestInputVoltage = iEnergyContainer.getInputVoltage();
        }
        for (IEnergyContainer iEnergyContainer : energyContainerList) {
            if (iEnergyContainer.getInputVoltage() != highestInputVoltage) continue;
            ++numHighestInputContainers;
        }
        EnergyStack voltageAmperage = EnergyContainerList.calculateVoltageAmperage(totalInputVoltage, inputAmperage);
        this.inputVoltage = voltageAmperage.voltage();
        this.inputAmperage = voltageAmperage.amperage();
        voltageAmperage = EnergyContainerList.calculateVoltageAmperage(totalOutputVoltage, outputAmperage);
        this.outputVoltage = voltageAmperage.voltage();
        this.outputAmperage = voltageAmperage.amperage();
        this.highestInputVoltage = highestInputVoltage;
        this.numHighestInputContainers = numHighestInputContainers;
    }

    public static EnergyStack calculateVoltageAmperage(long voltage, long amperage) {
        if (voltage > 1L && amperage > 1L) {
            if (EnergyContainerList.hasPrimeFactorGreaterThanTwo(amperage)) {
                amperage = 1L;
            } else if (EnergyContainerList.isPowerOfFour(amperage)) {
                amperage = 1L;
            } else if (amperage % 4L == 0L) {
                while (amperage > 4L) {
                    amperage /= 4L;
                }
                voltage /= amperage;
            } else if (amperage == 2L) {
                voltage /= amperage;
            } else {
                amperage = 1L;
            }
        }
        return new EnergyStack(voltage, amperage);
    }

    private static boolean hasPrimeFactorGreaterThanTwo(long l) {
        int i = 2;
        long max = l / 2L;
        while ((long)i <= max) {
            if (l % (long)i == 0L) {
                if (i > 2) {
                    return true;
                }
                l /= (long)i;
                continue;
            }
            ++i;
        }
        return false;
    }

    private static boolean isPowerOfFour(long l) {
        if (l == 0L) {
            return false;
        }
        if ((l & l - 1L) != 0L) {
            return false;
        }
        return (l & 0x55555555L) != 0L;
    }

    @Override
    public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
        long amperesUsed = 0L;
        for (IEnergyContainer iEnergyContainer : this.energyContainerList) {
            if ((amperesUsed += iEnergyContainer.acceptEnergyFromNetwork(null, voltage, amperage)) < amperage) continue;
            return amperesUsed;
        }
        return amperesUsed;
    }

    @Override
    public long changeEnergy(long energyToAdd) {
        long energyAdded = 0L;
        for (IEnergyContainer iEnergyContainer : this.energyContainerList) {
            if ((energyAdded += iEnergyContainer.changeEnergy(energyToAdd - energyAdded)) != energyToAdd) continue;
            return energyAdded;
        }
        return energyAdded;
    }

    @Override
    public long getEnergyStored() {
        long energyStored = 0L;
        for (IEnergyContainer iEnergyContainer : this.energyContainerList) {
            energyStored += iEnergyContainer.getEnergyStored();
        }
        return energyStored;
    }

    @Override
    public long getEnergyCapacity() {
        long energyCapacity = 0L;
        for (IEnergyContainer iEnergyContainer : this.energyContainerList) {
            energyCapacity += iEnergyContainer.getEnergyCapacity();
        }
        return energyCapacity;
    }

    @Override
    public boolean inputsEnergy(Direction side) {
        return true;
    }

    @Override
    public boolean outputsEnergy(Direction side) {
        return true;
    }

    @Override
    public long getInputPerSec() {
        long sum = 0L;
        for (IEnergyContainer iEnergyContainer : this.energyContainerList) {
            sum += iEnergyContainer.getInputPerSec();
        }
        return sum;
    }

    @Override
    public long getOutputPerSec() {
        long sum = 0L;
        for (IEnergyContainer iEnergyContainer : this.energyContainerList) {
            sum += iEnergyContainer.getOutputPerSec();
        }
        return sum;
    }

    public String toString() {
        return "EnergyContainerList{energyContainerList=" + String.valueOf(this.energyContainerList) + ", energyStored=" + this.getEnergyStored() + ", energyCapacity=" + this.getEnergyCapacity() + ", inputVoltage=" + this.inputVoltage + ", inputAmperage=" + this.inputAmperage + ", outputVoltage=" + this.outputVoltage + ", outputAmperage=" + this.outputAmperage + "}";
    }

    @Override
    @Generated
    public long getInputVoltage() {
        return this.inputVoltage;
    }

    @Override
    @Generated
    public long getOutputVoltage() {
        return this.outputVoltage;
    }

    @Override
    @Generated
    public long getInputAmperage() {
        return this.inputAmperage;
    }

    @Override
    @Generated
    public long getOutputAmperage() {
        return this.outputAmperage;
    }

    @Generated
    public long getHighestInputVoltage() {
        return this.highestInputVoltage;
    }

    @Generated
    public int getNumHighestInputContainers() {
        return this.numHighestInputContainers;
    }
}

