/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc.virtualregistry.entries;

import com.gregtechceu.gtceu.api.misc.virtualregistry.EntryTypes;
import com.gregtechceu.gtceu.api.misc.virtualregistry.VirtualEntry;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class VirtualTank
extends VirtualEntry {
    public static final int DEFAULT_CAPACITY = 160000;
    protected static final String CAPACITY_KEY = "capacity";
    protected static final String FLUID_KEY = "fluid";
    @NotNull
    private final FluidTank fluidTank;
    private int capacity;

    public VirtualTank(int capacity) {
        this.capacity = capacity;
        this.fluidTank = new FluidTank(this.capacity);
    }

    public VirtualTank() {
        this(160000);
    }

    public EntryTypes<VirtualTank> getType() {
        return EntryTypes.ENDER_FLUID;
    }

    public void setFluid(FluidStack fluid) {
        this.fluidTank.setFluid(fluid);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof VirtualTank)) {
            return false;
        }
        VirtualTank other = (VirtualTank)o;
        return this.fluidTank == other.fluidTank;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128405_(CAPACITY_KEY, this.capacity);
        if (this.fluidTank.getFluid() != FluidStack.EMPTY) {
            tag.m_128365_(FLUID_KEY, (Tag)this.fluidTank.getFluid().writeToNBT(new CompoundTag()));
        }
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.capacity = nbt.m_128451_(CAPACITY_KEY);
        if (nbt.m_128441_(FLUID_KEY)) {
            this.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_(FLUID_KEY)));
        }
    }

    @Override
    public boolean canRemove() {
        return super.canRemove() && this.fluidTank.isEmpty();
    }

    @NotNull
    @Generated
    public FluidTank getFluidTank() {
        return this.fluidTank;
    }
}

