/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.recipe.ShapedEnergyTransferRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidContainerIngredient;
import com.gregtechceu.gtceu.core.mixins.ShapedRecipeAccessor;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.NotNull;

public class ShapedFluidContainerRecipe
extends ShapedRecipe {
    public static final RecipeSerializer<ShapedFluidContainerRecipe> SERIALIZER = new Serializer();

    public ShapedFluidContainerRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> recipeItems, ItemStack result, boolean showNotification) {
        super(id, group, category, width, height, recipeItems, result, showNotification);
    }

    public ShapedFluidContainerRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> recipeItems, ItemStack result) {
        this(id, group, category, width, height, recipeItems, result, true);
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingContainer inv) {
        NonNullList items = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        int replacedSlot = -1;
        block0: for (int x = 0; x <= inv.m_39347_() - this.m_44220_(); ++x) {
            for (int y = 0; y <= inv.m_39346_() - this.m_44221_(); ++y) {
                IntObjectPair<ItemStack> stack = this.findFluidReplacement(inv, x, y, false);
                if (stack.firstInt() != -1) {
                    items.set(stack.firstInt(), (Object)((ItemStack)stack.second()));
                    replacedSlot = stack.firstInt();
                    break block0;
                }
                stack = this.findFluidReplacement(inv, x, y, true);
                if (stack.firstInt() == -1) continue;
                items.set(stack.firstInt(), (Object)((ItemStack)stack.second()));
                replacedSlot = stack.firstInt();
                break block0;
            }
        }
        for (int i = 0; i < items.size(); ++i) {
            ItemStack item;
            if (i == replacedSlot || !(item = inv.m_8020_(i)).hasCraftingRemainingItem()) continue;
            items.set(i, (Object)item.getCraftingRemainingItem());
        }
        return items;
    }

    private IntObjectPair<ItemStack> findFluidReplacement(CraftingContainer inv, int width, int height, boolean mirrored) {
        for (int x = 0; x < inv.m_39347_(); ++x) {
            for (int y = 0; y < inv.m_39346_(); ++y) {
                int slot;
                ItemStack stack;
                FluidContainerIngredient fluidContainerIngredient;
                int offsetX = x - width;
                int offsetY = y - height;
                Ingredient ingredient = Ingredient.f_43901_;
                if (offsetX >= 0 && offsetY >= 0 && offsetX < this.m_44220_() && offsetY < this.m_44221_()) {
                    ingredient = mirrored ? (Ingredient)this.m_7527_().get(this.m_44220_() - offsetX - 1 + offsetY * this.m_44220_()) : (Ingredient)this.m_7527_().get(offsetX + offsetY * this.m_44220_());
                }
                if (!(ingredient instanceof FluidContainerIngredient) || !(fluidContainerIngredient = (FluidContainerIngredient)ingredient).test(stack = inv.m_8020_(slot = x + y * inv.m_39347_()))) continue;
                return IntObjectPair.of((int)slot, (Object)fluidContainerIngredient.getExtractedStack(stack));
            }
        }
        return IntObjectPair.of((int)-1, (Object)ItemStack.f_41583_);
    }

    public static class Serializer
    implements RecipeSerializer<ShapedFluidContainerRecipe> {
        public ShapedFluidContainerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            Map<String, Ingredient> key = ShapedRecipeAccessor.callKeyFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] pattern = ShapedRecipeAccessor.callShrink(ShapedRecipeAccessor.callPatternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int xSize = pattern[0].length();
            int ySize = pattern.length;
            NonNullList<Ingredient> dissolved = ShapedRecipeAccessor.callDissolvePattern(pattern, key, xSize, ySize);
            ItemStack result = ShapedEnergyTransferRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            boolean showNotification = GsonHelper.m_13855_((JsonObject)json, (String)"show_notification", (boolean)true);
            return new ShapedFluidContainerRecipe(recipeId, group, category, xSize, ySize, dissolved, result, showNotification);
        }

        public ShapedFluidContainerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int xSize = buffer.m_130242_();
            int ySize = buffer.m_130242_();
            CraftingBookCategory category = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            String group = buffer.m_130277_();
            NonNullList ingredients = NonNullList.m_122780_((int)(xSize * ySize), (Object)Ingredient.f_43901_);
            ingredients.replaceAll($ -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            ItemStack result = buffer.m_130267_();
            boolean showNotification = buffer.readBoolean();
            return new ShapedFluidContainerRecipe(recipeId, group, category, xSize, ySize, (NonNullList<Ingredient>)ingredients, result, showNotification);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedFluidContainerRecipe recipe) {
            buffer.m_130130_(recipe.m_44220_());
            buffer.m_130130_(recipe.m_44221_());
            buffer.m_130068_((Enum)recipe.m_245232_());
            buffer.m_130070_(recipe.m_6076_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(((ShapedRecipeAccessor)((Object)recipe)).getResult());
            buffer.writeBoolean(recipe.m_271738_());
        }
    }
}

