/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer;

import com.gregtechceu.gtceu.client.model.IBlockEntityRendererBakedModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockEntityWithBERModelRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final BlockRenderDispatcher blockRenderDispatcher;

    public BlockEntityWithBERModelRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderDispatcher = context.m_173584_();
    }

    public void m_6922_(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockState blockState = blockEntity.m_58900_();
        BakedModel model = this.blockRenderDispatcher.m_110910_(blockState);
        if (model instanceof IBlockEntityRendererBakedModel) {
            IBlockEntityRendererBakedModel berModel = (IBlockEntityRendererBakedModel)model;
            if (berModel.getBlockEntityType() != blockEntity.m_58903_()) {
                return;
            }
            berModel.m_6922_(blockEntity, partialTick, poseStack, buffer, packedLight, packedOverlay);
        } else {
            Level level = blockEntity.m_58904_();
            BlockPos pos = blockEntity.m_58899_();
            ModelData modelData = level.getModelDataManager().getAt(pos);
            if (modelData == null) {
                modelData = ModelData.EMPTY;
            }
            long randomSeed = blockState.m_60726_(pos);
            RandomSource random = RandomSource.m_216327_();
            random.m_188584_(randomSeed);
            for (RenderType renderType : model.getRenderTypes(blockState, random, modelData)) {
                VertexConsumer consumer = buffer.m_6299_(renderType);
                this.blockRenderDispatcher.m_110937_().tesselateBlock((BlockAndTintGetter)level, model, blockState, pos, poseStack, consumer, true, random, randomSeed, OverlayTexture.f_118083_, modelData, renderType);
            }
        }
    }

    public boolean m_5932_(T blockEntity) {
        IBlockEntityRendererBakedModel berModel;
        BlockState blockState = blockEntity.m_58900_();
        BakedModel model = this.blockRenderDispatcher.m_110910_(blockState);
        if (model instanceof IBlockEntityRendererBakedModel && (berModel = (IBlockEntityRendererBakedModel)model).getBlockEntityType() == blockEntity.m_58903_()) {
            return berModel.m_5932_((BlockEntity)blockEntity);
        }
        return super.m_5932_(blockEntity);
    }

    public boolean m_142756_(T blockEntity, Vec3 cameraPos) {
        IBlockEntityRendererBakedModel berModel;
        BlockState blockState = blockEntity.m_58900_();
        BakedModel model = this.blockRenderDispatcher.m_110910_(blockState);
        if (model instanceof IBlockEntityRendererBakedModel && (berModel = (IBlockEntityRendererBakedModel)model).getBlockEntityType() == blockEntity.m_58903_()) {
            return berModel.m_142756_(blockEntity, cameraPos);
        }
        return super.m_142756_(blockEntity, cameraPos);
    }
}

