/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.ender;

import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.cover.filter.FilterHandler;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.ColorBlockWidget;
import com.gregtechceu.gtceu.api.gui.widget.ConfirmTextInputWidget;
import com.gregtechceu.gtceu.api.gui.widget.EnumSelectorWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.MachineCoverContainer;
import com.gregtechceu.gtceu.api.misc.virtualregistry.EntryTypes;
import com.gregtechceu.gtceu.api.misc.virtualregistry.VirtualEnderRegistry;
import com.gregtechceu.gtceu.api.misc.virtualregistry.VirtualEntry;
import com.gregtechceu.gtceu.common.cover.data.ManualIOMode;
import com.gregtechceu.gtceu.common.machine.owner.MachineOwner;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SelectableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.TextBoxWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEnderLinkCover<T extends VirtualEntry>
extends CoverBehavior
implements IUICover,
IControllable {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(AbstractEnderLinkCover.class, CoverBehavior.MANAGED_FIELD_HOLDER);
    public static final Pattern COLOR_INPUT_PATTERN = Pattern.compile("^[0-9a-fA-F]{0,8}$");
    protected final ConditionalSubscriptionHandler subscriptionHandler;
    @Persisted
    @DescSynced
    protected String colorStr = "FFFFFFFF";
    @Persisted
    @DescSynced
    protected Permissions permission = Permissions.PUBLIC;
    @Persisted
    protected boolean isWorkingEnabled = true;
    @Persisted
    @DescSynced
    protected ManualIOMode manualIOMode = ManualIOMode.DISABLED;
    @Persisted
    @DescSynced
    @RequireRerender
    protected IO io = IO.OUT;
    protected VirtualEntryWidget virtualEntryWidget;
    @DescSynced
    boolean isAnyChanged = false;

    public AbstractEnderLinkCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
        this.subscriptionHandler = new ConditionalSubscriptionHandler(coverHolder, this::update, this::isSubscriptionActive);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.subscriptionHandler.initialize(this.coverHolder.getLevel());
    }

    @Override
    public abstract boolean canAttach();

    @Override
    public void onAttached(@NotNull ItemStack itemStack, @NotNull ServerPlayer player) {
        super.onAttached(itemStack, player);
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        this.subscriptionHandler.unsubscribe();
        if (!this.isRemote()) {
            VirtualEnderRegistry.getInstance().deleteEntryIf(this.getOwner(), this.getEntryType(), this.getChannelName(), VirtualEntry::canRemove);
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.subscriptionHandler.unsubscribe();
        if (!this.isRemote()) {
            VirtualEnderRegistry.getInstance().deleteEntryIf(this.getOwner(), this.getEntryType(), this.getChannelName(), VirtualEntry::canRemove);
        }
    }

    @Override
    public void onUIClosed() {
        this.virtualEntryWidget = null;
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        if (this.isWorkingEnabled != isWorkingAllowed) {
            this.isWorkingEnabled = isWorkingAllowed;
            this.subscriptionHandler.updateSubscription();
        }
    }

    @Override
    public Widget createUIWidget() {
        this.virtualEntryWidget = new VirtualEntryWidget(this);
        return this.virtualEntryWidget;
    }

    @Override
    @NotNull
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void setIo(IO io) {
        if (io == IO.IN || io == IO.OUT) {
            this.io = io;
            this.subscriptionHandler.updateSubscription();
        }
    }

    public UUID getOwner() {
        ICoverable iCoverable;
        if (this.permission == Permissions.PRIVATE && (iCoverable = this.coverHolder) instanceof MachineCoverContainer) {
            MachineCoverContainer mcc = (MachineCoverContainer)iCoverable;
            MachineOwner owner = mcc.getMachine().getOwner();
            return owner != null ? owner.getPlayerUUID() : null;
        }
        return null;
    }

    protected boolean isSubscriptionActive() {
        return this.isWorkingEnabled();
    }

    protected abstract String identifier();

    protected abstract VirtualEntry getEntry();

    protected abstract void setEntry(VirtualEntry var1);

    protected final String getChannelName() {
        return this.identifier() + this.colorStr;
    }

    protected void setChannelName(String name) {
        if (this.isRemote()) {
            return;
        }
        VirtualEnderRegistry.getInstance().deleteEntryIf(this.getOwner(), this.getEntryType(), this.getChannelName(), VirtualEntry::canRemove);
        this.colorStr = name;
        this.setVirtualEntry();
    }

    protected final String getChannelName(VirtualEntry entry) {
        return this.identifier() + entry.getColorStr();
    }

    protected void setPermission(Permissions permission) {
        if (this.isRemote()) {
            return;
        }
        VirtualEnderRegistry.getInstance().deleteEntryIf(this.getOwner(), this.getEntryType(), this.getChannelName(), VirtualEntry::canRemove);
        this.permission = permission;
        this.setVirtualEntry();
    }

    protected void setVirtualEntry() {
        this.setEntry((VirtualEntry)VirtualEnderRegistry.getInstance().getOrCreateEntry(this.getOwner(), this.getEntryType(), this.getChannelName()));
        this.getEntry().setColor(this.colorStr);
        this.isAnyChanged = true;
        this.subscriptionHandler.updateSubscription();
    }

    protected abstract EntryTypes<T> getEntryType();

    protected void update() {
        long timer = this.coverHolder.getOffsetTimer();
        if (timer % 5L != 0L) {
            return;
        }
        if (this.isWorkingEnabled() && !this.isRemote()) {
            T entry = VirtualEnderRegistry.getInstance().getOrCreateEntry(this.getOwner(), this.getEntryType(), this.getChannelName());
            if (!((VirtualEntry)entry).getColorStr().equals(this.colorStr)) {
                ((VirtualEntry)entry).setColor(this.colorStr);
            }
            if (!this.getEntry().equals(entry)) {
                this.setEntry((VirtualEntry)entry);
            }
            this.transfer();
        }
        if (this.isAnyChanged) {
            if (this.virtualEntryWidget != null) {
                this.virtualEntryWidget.update();
            }
            this.isAnyChanged = false;
        }
        this.subscriptionHandler.updateSubscription();
    }

    protected abstract void transfer();

    protected void setManualIOMode(ManualIOMode manualIOMode) {
        this.manualIOMode = manualIOMode;
        this.subscriptionHandler.updateSubscription();
    }

    @Nullable
    protected FilterHandler<?, ?> getFilterHandler() {
        return null;
    }

    protected abstract Widget addVirtualEntryWidget(VirtualEntry var1, int var2, int var3, int var4, int var5, boolean var6);

    protected abstract String getUITitle();

    protected int getColor() {
        return VirtualEntry.parseColor(this.colorStr);
    }

    @Generated
    public Permissions getPermission() {
        return this.permission;
    }

    @Override
    @Generated
    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    @Generated
    public ManualIOMode getManualIOMode() {
        return this.manualIOMode;
    }

    @Generated
    public IO getIo() {
        return this.io;
    }

    protected static enum Permissions implements EnumSelectorWidget.SelectableEnum
    {
        PUBLIC("cover.ender_fluid_link.private.tooltip.disabled", (IGuiTexture)GuiTextures.BUTTON_PUBLIC_PRIVATE.getSubTexture(0.0, 0.0, 1.0, 0.5)),
        PRIVATE("cover.ender_fluid_link.private.tooltip.enabled", (IGuiTexture)GuiTextures.BUTTON_PUBLIC_PRIVATE.getSubTexture(0.0, 0.5, 1.0, 0.5));

        private final String tooltip;
        private final IGuiTexture icon;

        private Permissions(String tooltip, IGuiTexture icon) {
            this.tooltip = tooltip;
            this.icon = icon;
        }

        @Override
        @Generated
        public String getTooltip() {
            return this.tooltip;
        }

        @Override
        @Generated
        public IGuiTexture getIcon() {
            return this.icon;
        }
    }

    protected static class VirtualEntryWidget
    extends WidgetGroup {
        private static final int WIDGET_BOARD = 20;
        private static final int GROUP_WIDTH = 176;
        private static final int TOTAL_WIDTH = 156;
        private static final int BUTTON_SIZE = 16;
        private final AbstractEnderLinkCover<?> cover;
        private final MutableBoolean showChannels;
        private final WidgetGroup mainGroup;
        private final WidgetGroup mainChannelGroup;
        private final DraggableScrollableWidgetGroup channelsGroup;

        VirtualEntryWidget(AbstractEnderLinkCover<?> cover) {
            super(0, 0, 176, 137);
            this.cover = cover;
            this.showChannels = new MutableBoolean(false);
            this.mainGroup = new WidgetGroup(0, 0, 176, 137);
            this.channelsGroup = new DraggableScrollableWidgetGroup(0, 20, 170, 110).setYScrollBarWidth(2).setYBarStyle(null, (IGuiTexture)ColorPattern.T_WHITE.rectTexture().setRadius(1.0f));
            this.mainChannelGroup = new WidgetGroup(10, 20, 156, 20);
            this.initWidgets();
        }

        public void update() {
            if (this.isRemote()) {
                return;
            }
            this.widgets.clear();
            this.mainGroup.widgets.clear();
            this.channelsGroup.widgets.clear();
            this.mainChannelGroup.widgets.clear();
            this.initWidgets();
            this.detectAndSendChanges();
        }

        private void initWidgets() {
            int currentX = 0;
            WidgetGroup titleGroup = new WidgetGroup(10, 5, 176, 20);
            this.addWidget((Widget)titleGroup);
            this.addWidget((Widget)this.mainGroup);
            this.addWidget((Widget)this.channelsGroup.setVisible(false));
            titleGroup.addWidget((Widget)this.createToggleButton());
            titleGroup.addWidget((Widget)new LabelWidget(15, 3, this.cover.getUITitle()));
            Widget toggleButtonWidget = this.createToggleButtonForPrivacy(currentX);
            this.mainChannelGroup.addWidget(toggleButtonWidget);
            this.mainChannelGroup.addWidget((Widget)this.createColorBlockWidget(currentX += 22));
            this.mainChannelGroup.addWidget((Widget)this.createConfirmTextInputWidget(currentX += 22));
            this.mainChannelGroup.addWidget((Widget)new ConfirmTextInputWidget(0, 22, 156, 20, this.cover.getEntry().getDescription(), this.cover.getEntry()::setDescription, t -> t == null ? "" : t, null).setTooltip("cover.ender_fluid_link.tooltip.channel_description"));
            this.mainGroup.addWidget((Widget)this.mainChannelGroup);
            this.mainGroup.addWidget((Widget)this.createWorkingEnabledButton());
            this.addEnumSelectorWidgets();
            this.mainGroup.addWidget(this.cover.addVirtualEntryWidget(this.cover.getEntry(), 146, 20, 20, 20, true));
            if (this.cover.getFilterHandler() != null) {
                this.mainGroup.addWidget(this.cover.getFilterHandler().createFilterSlotUI(117, 108));
                this.mainGroup.addWidget(this.cover.getFilterHandler().createFilterConfigUI(10, 72, 156, 60));
            }
        }

        @Contract(value=" -> new")
        @NotNull
        private ToggleButtonWidget createToggleButton() {
            return (ToggleButtonWidget)new ToggleButtonWidget(0, 0, 12, 12, () -> ((MutableBoolean)this.showChannels).getValue(), cd -> {
                this.showChannels.setValue(this.showChannels.getValue() == false);
                this.mainGroup.setVisible(this.showChannels.isFalse());
                this.channelsGroup.setVisible(this.showChannels.isTrue());
                this.requestUpdate();
            }).setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.TOGGLE_BUTTON_BACK.getSubTexture(0.0, 0.0, 1.0, 0.5), GuiTextures.BUTTON_LIST}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.TOGGLE_BUTTON_BACK.getSubTexture(0.0, 0.5, 1.0, 0.5), GuiTextures.BUTTON_LIST})).setHoverTooltips(new String[]{"cover.ender_fluid_link.tooltip.list_button"});
        }

        @Contract(value="_ -> new")
        @NotNull
        private Widget createToggleButtonForPrivacy(int currentX) {
            return new EnumSelectorWidget(currentX, 0, 20, 20, (Enum[])Permissions.values(), (Enum)this.cover.permission, this.cover::setPermission);
        }

        private ColorBlockWidget createColorBlockWidget(int currentX) {
            return new ColorBlockWidget(currentX, 0, 20, 20).setColorSupplier(this.cover::getColor);
        }

        private ConfirmTextInputWidget createConfirmTextInputWidget(int currentX) {
            int GROUP_X = 10;
            int textInputWidth = 176 - GROUP_X * 2 - currentX - 20 - 2;
            return new ConfirmTextInputWidget(currentX, 0, textInputWidth, 20, this.cover.colorStr, this.cover::setChannelName, text -> {
                if (text == null || !COLOR_INPUT_PATTERN.matcher((CharSequence)text).matches()) {
                    return "FFFFFFFF";
                }
                return text;
            }, text -> {
                if (((String)text).length() < 8) {
                    text = (String)text + "F".repeat(8 - ((String)text).length());
                }
                return text;
            }).setTooltip("cover.ender_fluid_link.tooltip.channel_name");
        }

        @Contract(value=" -> new")
        @NotNull
        private ToggleButtonWidget createWorkingEnabledButton() {
            return new ToggleButtonWidget(116, 82, 20, 20, (IGuiTexture)GuiTextures.BUTTON_POWER, this.cover::isWorkingEnabled, this.cover::setWorkingEnabled);
        }

        private void addEnumSelectorWidgets() {
            this.mainGroup.addWidget(new EnumSelectorWidget<IO>(146, 82, 20, 20, List.of(IO.IN, IO.OUT), this.cover.io, this.cover::setIo));
            this.mainGroup.addWidget(new EnumSelectorWidget(146, 107, 20, 20, (Enum[])ManualIOMode.VALUES, (Enum)this.cover.manualIOMode, this.cover::setManualIOMode).setHoverTooltips(new String[]{"cover.universal.manual_import_export.mode.description"}));
        }

        private void addChannelWidgets(List<? extends VirtualEntry> entries) {
            this.channelsGroup.clearAllWidgets();
            int y = 1;
            SelectableWidgetGroup selectedWidget = null;
            for (VirtualEntry entry : entries.stream().sorted(Comparator.comparing(VirtualEntry::getColorStr)).toList()) {
                SelectableWidgetGroup channelWidget = this.createChannelWidget(entry, 10, y);
                if (this.cover.getChannelName(entry).equals(this.cover.getChannelName())) {
                    selectedWidget = channelWidget;
                }
                this.channelsGroup.addWidget((Widget)channelWidget);
                y += 22;
            }
            this.channelsGroup.setSelected(selectedWidget);
            if (selectedWidget != null) {
                selectedWidget.onSelected();
            }
            this.channelsGroup.setClientSideWidget();
        }

        @NotNull
        private SelectableWidgetGroup createChannelWidget(@NotNull VirtualEntry entry, int x, int y) {
            int currentX = 0;
            int MARGIN = 2;
            int availableWidth = 156 - (16 + MARGIN) * 3;
            final MutableBoolean canSelect = new MutableBoolean(false);
            String des = entry.getDescription();
            TextBoxWidget textBoxWidget = new TextBoxWidget(16 + MARGIN, !des.isEmpty() ? 0 : 4, availableWidth, List.of(entry.getColorStr())).setCenter(true);
            SelectableWidgetGroup channelGroup = new SelectableWidgetGroup(x, y, 156, 16){

                public boolean allowSelected(double mouseX, double mouseY, int button) {
                    return canSelect.getValue() != false && super.allowSelected(mouseX, mouseY, button);
                }
            };
            channelGroup.setOnSelected(group -> {
                if (this.cover.getChannelName().equals(this.cover.getChannelName(entry))) {
                    return;
                }
                this.writeClientAction(0, buffer -> {
                    String newChannelColorStr = entry.getColorStr();
                    buffer.m_130070_(newChannelColorStr);
                });
                VirtualEntryWidget.playButtonClickSound();
            }).setSelectedTexture(1, -1);
            ColorBlockWidget colorBlockWidget = new ColorBlockWidget(currentX, 0, 16, 16).setCurrentColor(VirtualEntry.parseColor(entry.getColorStr()));
            channelGroup.addWidget((Widget)colorBlockWidget);
            currentX += 16 + MARGIN;
            channelGroup.addWidget((Widget)textBoxWidget);
            currentX += availableWidth + MARGIN;
            if (!des.isEmpty()) {
                TextTexture desText = new TextTexture(String.valueOf(ChatFormatting.DARK_GRAY) + des).setDropShadow(false);
                desText.setType(TextTexture.TextType.ROLL).setRollSpeed(0.7f);
                channelGroup.addWidget((Widget)new ImageWidget(16 + MARGIN, 10, availableWidth, 8, (IGuiTexture)desText));
            }
            Widget slotWidget = this.cover.addVirtualEntryWidget(entry, currentX, 0, 16, 16, false);
            channelGroup.addWidget(slotWidget);
            channelGroup.addWidget(new ButtonWidget(currentX += 16 + MARGIN, 0, 16, 16, (IGuiTexture)GuiTextures.BUTTON_CLEAR_GRID, press -> {
                this.writeClientAction(200, buffer -> buffer.m_130070_(this.cover.getChannelName(entry)));
                this.requestUpdate();
            }){

                public boolean isMouseOverElement(double mouseX, double mouseY) {
                    boolean isOver = super.isMouseOverElement(mouseX, mouseY);
                    if (canSelect.getValue() == isOver) {
                        canSelect.setValue(!isOver);
                    }
                    return isOver;
                }
            }.appendHoverTooltips(new String[]{"cover.ender_fluid_link.tooltip.clear_button"}));
            return channelGroup;
        }

        private void requestUpdate() {
            this.writeClientAction(100, buffer -> buffer.writeBoolean(this.showChannels.isTrue()));
        }

        public void handleClientAction(int id, FriendlyByteBuf buffer) {
            super.handleClientAction(id, buffer);
            if (id == 0) {
                String newChannelColorStr = buffer.m_130277_();
                this.cover.setChannelName(newChannelColorStr);
            } else if (id == 100) {
                if (!buffer.readBoolean()) {
                    return;
                }
                Stream<VirtualEntry> entries = VirtualEnderRegistry.getInstance().getEntryNames(this.cover.getOwner(), this.cover.getEntryType()).stream().map(name -> VirtualEnderRegistry.getInstance().getEntry(this.cover.getOwner(), this.cover.getEntryType(), (String)name)).sorted(Comparator.comparing(VirtualEntry::getColorStr));
                this.writeUpdateInfo(101, buf -> {
                    List list = entries.toList();
                    buf.m_130130_(list.size());
                    for (VirtualEntry entry : list) {
                        buf.m_130079_(entry.serializeNBT());
                    }
                });
            } else if (id == 200) {
                String channelName = buffer.m_130277_();
                ((VirtualEntry)VirtualEnderRegistry.getInstance().getEntry(this.cover.getOwner(), this.cover.getEntryType(), channelName)).setDescription("");
            }
        }

        public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
            super.readUpdateInfo(id, buffer);
            if (id == 101) {
                int size = buffer.m_130242_();
                ArrayList entries = new ArrayList();
                for (int i = 0; i < size; ++i) {
                    Object entry = this.cover.getEntryType().createInstance();
                    ((VirtualEntry)entry).deserializeNBT(Objects.requireNonNull(buffer.m_130260_()));
                    entries.add(entry);
                }
                this.addChannelWidgets(entries);
            }
        }
    }
}

