/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.block.MaterialBlock;
import com.gregtechceu.gtceu.api.block.MaterialPipeBlock;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.registry.MaterialRegistry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.MaterialBlockItem;
import com.gregtechceu.gtceu.api.item.MaterialPipeBlockItem;
import com.gregtechceu.gtceu.api.item.SurfaceRockBlockItem;
import com.gregtechceu.gtceu.api.registry.registrate.GTRegistrate;
import com.gregtechceu.gtceu.common.block.CableBlock;
import com.gregtechceu.gtceu.common.block.FluidPipeBlock;
import com.gregtechceu.gtceu.common.block.ItemPipeBlock;
import com.gregtechceu.gtceu.common.block.SurfaceRockBlock;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTSoundTypes;
import com.gregtechceu.gtceu.common.pipelike.cable.Insulation;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.FluidPipeType;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeType;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class GTMaterialBlocks {
    static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<? extends Block>> MATERIAL_BLOCKS_BUILDER = ImmutableTable.builder();
    static ImmutableMap.Builder<Material, BlockEntry<SurfaceRockBlock>> SURFACE_ROCK_BLOCKS_BUILDER = ImmutableMap.builder();
    static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<CableBlock>> CABLE_BLOCKS_BUILDER = ImmutableTable.builder();
    static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<FluidPipeBlock>> FLUID_PIPE_BLOCKS_BUILDER = ImmutableTable.builder();
    static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<ItemPipeBlock>> ITEM_PIPE_BLOCKS_BUILDER = ImmutableTable.builder();
    public static Table<TagPrefix, Material, BlockEntry<? extends Block>> MATERIAL_BLOCKS;
    public static Map<Material, BlockEntry<SurfaceRockBlock>> SURFACE_ROCK_BLOCKS;
    public static Table<TagPrefix, Material, BlockEntry<CableBlock>> CABLE_BLOCKS;
    public static Table<TagPrefix, Material, BlockEntry<FluidPipeBlock>> FLUID_PIPE_BLOCKS;
    public static Table<TagPrefix, Material, BlockEntry<ItemPipeBlock>> ITEM_PIPE_BLOCKS;

    public static void generateMaterialBlocks() {
        GTCEu.LOGGER.debug("Generating GTCEu Material Blocks...");
        for (TagPrefix tagPrefix : TagPrefix.values()) {
            if (TagPrefix.ORES.containsKey(tagPrefix) || !tagPrefix.doGenerateBlock()) continue;
            for (MaterialRegistry registry : GTCEuAPI.materialManager.getRegistries()) {
                GTRegistrate registrate = registry.getRegistrate();
                for (Material material : registry.getAllMaterials()) {
                    if (!tagPrefix.doGenerateBlock(material)) continue;
                    GTMaterialBlocks.registerMaterialBlock(tagPrefix, material, registrate);
                }
            }
        }
        GTCEu.LOGGER.debug("Generating GTCEu Material Blocks... Complete!");
    }

    private static void registerMaterialBlock(TagPrefix tagPrefix, Material material, GTRegistrate registrate) {
        MATERIAL_BLOCKS_BUILDER.put((Object)tagPrefix, (Object)material, (Object)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block(tagPrefix.idPattern().formatted(material.getName()), properties -> tagPrefix.blockConstructor().create((BlockBehaviour.Properties)properties, tagPrefix, material)).initialProperties(() -> Blocks.f_50075_).properties(p -> ((BlockBehaviour.Properties)tagPrefix.blockProperties().properties().apply((BlockBehaviour.Properties)p)).m_222994_()).transform(GTBlocks.unificationBlock(tagPrefix, material))).addLayer(tagPrefix.blockProperties().renderType()).setData(ProviderType.BLOCKSTATE, NonNullBiConsumer.noop())).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).color(() -> MaterialBlock::tintedColor).item((b, p) -> tagPrefix.blockItemConstructor().create((Block)b, (Item.Properties)p, tagPrefix, material)).model(NonNullBiConsumer.noop()).color(() -> () -> MaterialBlockItem.tintColor(material)).build()).register());
    }

    public static void generateOreBlocks() {
        GTCEu.LOGGER.debug("Generating GTCEu Ore Blocks...");
        for (MaterialRegistry registry : GTCEuAPI.materialManager.getRegistries()) {
            GTRegistrate registrate = registry.getRegistrate();
            for (Material material : registry.getAllMaterials()) {
                if (!GTMaterialBlocks.allowOreBlock(material)) continue;
                GTMaterialBlocks.registerOreBlock(material, registrate);
            }
        }
        GTCEu.LOGGER.debug("Generating GTCEu Ore Blocks... Complete!");
    }

    private static boolean allowOreBlock(Material material) {
        return material.hasProperty(PropertyKey.ORE);
    }

    private static void registerOreBlock(Material material, GTRegistrate registrate) {
        for (Map.Entry<TagPrefix, TagPrefix.OreType> ore : TagPrefix.ORES.entrySet()) {
            if (ore.getKey().isIgnored(material)) continue;
            TagPrefix oreTag = ore.getKey();
            TagPrefix.OreType oreType = ore.getValue();
            Object typePrefix = "";
            if (oreTag != TagPrefix.ore) {
                typePrefix = FormattingUtil.toLowerCaseUnderscore(oreTag.name) + "_";
            }
            BlockEntry entry = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block("%s%s_ore".formatted(typePrefix, material.getName()), properties -> oreTag.blockConstructor().create((BlockBehaviour.Properties)properties, oreTag, material)).initialProperties(() -> {
                if (oreType.stoneType().get().m_60795_()) {
                    return Blocks.f_49996_;
                }
                return oreType.stoneType().get().m_60734_();
            }).properties(properties -> GTBlocks.copy(oreType.template().get(), properties).m_222994_()).transform(GTBlocks.unificationBlock(oreTag, material))).blockstate(NonNullBiConsumer.noop()).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).color(() -> MaterialBlock::tintedColor).item((b, p) -> oreTag.blockItemConstructor().create((Block)b, (Item.Properties)p, oreTag, material)).model(NonNullBiConsumer.noop()).color(() -> () -> MaterialBlockItem.tintColor(material)).build()).register();
            MATERIAL_BLOCKS_BUILDER.put((Object)oreTag, (Object)material, (Object)entry);
        }
    }

    public static void generateOreIndicators() {
        GTCEu.LOGGER.debug("Generating GTCEu Surface Rock Indicator Blocks...");
        for (MaterialRegistry registry : GTCEuAPI.materialManager.getRegistries()) {
            GTRegistrate registrate = registry.getRegistrate();
            for (Material material : registry.getAllMaterials()) {
                if (!GTMaterialBlocks.allowOreIndicator(material)) continue;
                GTMaterialBlocks.registerOreIndicator(material, registrate);
            }
        }
        SURFACE_ROCK_BLOCKS = SURFACE_ROCK_BLOCKS_BUILDER.build();
        GTCEu.LOGGER.debug("Generating GTCEu Surface Rock Indicator Blocks... Complete!");
    }

    private static boolean allowOreIndicator(Material material) {
        return material.hasProperty(PropertyKey.ORE);
    }

    private static void registerOreIndicator(Material material, GTRegistrate registrate) {
        BlockEntry entry = ((BlockBuilder)((ItemBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block("%s_indicator".formatted(material.getName()), p -> new SurfaceRockBlock((BlockBehaviour.Properties)p, material)).initialProperties(() -> Blocks.f_49994_).properties(p -> p.m_222994_().m_60978_(0.25f)).transform(GTBlocks.unificationBlock(TagPrefix.surfaceRock, material))).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).setData(ProviderType.BLOCKSTATE, NonNullBiConsumer.noop())).addLayer(() -> RenderType::m_110457_).color(() -> SurfaceRockBlock::tintedBlockColor).item((b, p) -> SurfaceRockBlockItem.create(b, p, material)).color(() -> SurfaceRockBlock::tintedItemColor).setData(ProviderType.ITEM_MODEL, NonNullBiConsumer.noop())).build()).register();
        SURFACE_ROCK_BLOCKS_BUILDER.put((Object)material, (Object)entry);
    }

    public static void generateCableBlocks() {
        GTCEu.LOGGER.debug("Generating GTCEu Cable/Wire Blocks...");
        for (Insulation insulation : Insulation.values()) {
            for (MaterialRegistry registry : GTCEuAPI.materialManager.getRegistries()) {
                GTRegistrate registrate = registry.getRegistrate();
                for (Material material : registry.getAllMaterials()) {
                    if (!GTMaterialBlocks.allowCableBlock(material, insulation)) continue;
                    GTMaterialBlocks.registerCableBlock(material, insulation, registrate);
                }
            }
        }
        CABLE_BLOCKS = CABLE_BLOCKS_BUILDER.build();
        GTCEu.LOGGER.debug("Generating GTCEu Cable/Wire Blocks... Complete!");
    }

    private static boolean allowCableBlock(Material material, Insulation insulation) {
        return material.hasProperty(PropertyKey.WIRE) && !insulation.tagPrefix.isIgnored(material) && (!insulation.isCable || !material.getProperty(PropertyKey.WIRE).isSuperconductor());
    }

    private static void registerCableBlock(Material material, Insulation insulation, GTRegistrate registrate) {
        BlockEntry entry = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block("%s_%s".formatted(material.getName(), insulation.name), p -> new CableBlock((BlockBehaviour.Properties)p, insulation, material)).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60988_().m_60955_().m_222994_().m_280606_()).transform(GTBlocks.unificationBlock(insulation.tagPrefix, material))).blockstate(NonNullBiConsumer.noop()).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).addLayer(() -> RenderType::m_110457_).addLayer(() -> RenderType::m_110466_).color(() -> MaterialPipeBlock::tintedColor).item(MaterialPipeBlockItem::new).model(NonNullBiConsumer.noop()).color(() -> MaterialPipeBlockItem::tintColor).build()).register();
        CABLE_BLOCKS_BUILDER.put((Object)insulation.tagPrefix, (Object)material, (Object)entry);
    }

    public static void generateFluidPipeBlocks() {
        GTCEu.LOGGER.debug("Generating GTCEu Fluid Pipe Blocks...");
        for (FluidPipeType fluidPipeType : FluidPipeType.values()) {
            for (MaterialRegistry registry : GTCEuAPI.materialManager.getRegistries()) {
                GTRegistrate registrate = registry.getRegistrate();
                for (Material material : registry.getAllMaterials()) {
                    if (!GTMaterialBlocks.allowFluidPipeBlock(material, fluidPipeType)) continue;
                    GTMaterialBlocks.registerFluidPipeBlock(material, fluidPipeType, registrate);
                }
            }
        }
        FLUID_PIPE_BLOCKS = FLUID_PIPE_BLOCKS_BUILDER.build();
        GTCEu.LOGGER.debug("Generating GTCEu Fluid Pipe Blocks... Complete!");
    }

    private static boolean allowFluidPipeBlock(Material material, FluidPipeType fluidPipeType) {
        return material.hasProperty(PropertyKey.FLUID_PIPE) && !fluidPipeType.tagPrefix.isIgnored(material);
    }

    private static void registerFluidPipeBlock(Material material, FluidPipeType fluidPipeType, GTRegistrate registrate) {
        BlockEntry entry = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block("%s_%s_fluid_pipe".formatted(material.getName(), fluidPipeType.name), p -> new FluidPipeBlock((BlockBehaviour.Properties)p, fluidPipeType, material)).initialProperties(() -> Blocks.f_50075_).properties(p -> {
            if (GTBlocks.doMetalPipe(material)) {
                p.m_60918_(GTSoundTypes.METAL_PIPE);
            }
            return p.m_60988_().m_60955_().m_222994_().m_280606_();
        }).transform(GTBlocks.unificationBlock(fluidPipeType.tagPrefix, material))).blockstate(NonNullBiConsumer.noop()).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).addLayer(() -> RenderType::m_110457_).addLayer(() -> RenderType::m_110466_).color(() -> MaterialPipeBlock::tintedColor).item(MaterialPipeBlockItem::new).model(NonNullBiConsumer.noop()).color(() -> MaterialPipeBlockItem::tintColor).build()).register();
        FLUID_PIPE_BLOCKS_BUILDER.put((Object)fluidPipeType.tagPrefix, (Object)material, (Object)entry);
    }

    public static void generateItemPipeBlocks() {
        GTCEu.LOGGER.debug("Generating GTCEu Item Pipe Blocks...");
        for (ItemPipeType itemPipeType : ItemPipeType.values()) {
            for (MaterialRegistry registry : GTCEuAPI.materialManager.getRegistries()) {
                GTRegistrate registrate = registry.getRegistrate();
                for (Material material : registry.getAllMaterials()) {
                    if (!GTMaterialBlocks.allowItemPipeBlock(material, itemPipeType)) continue;
                    GTMaterialBlocks.registerItemPipeBlock(material, itemPipeType, registrate);
                }
            }
        }
        ITEM_PIPE_BLOCKS = ITEM_PIPE_BLOCKS_BUILDER.build();
        GTCEu.LOGGER.debug("Generating GTCEu Item Pipe Blocks... Complete!");
    }

    private static boolean allowItemPipeBlock(Material material, ItemPipeType itemPipeType) {
        return material.hasProperty(PropertyKey.ITEM_PIPE) && !itemPipeType.getTagPrefix().isIgnored(material);
    }

    private static void registerItemPipeBlock(Material material, ItemPipeType itemPipeType, GTRegistrate registrate) {
        BlockEntry entry = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block("%s_%s_item_pipe".formatted(material.getName(), itemPipeType.name), p -> new ItemPipeBlock((BlockBehaviour.Properties)p, itemPipeType, material)).initialProperties(() -> Blocks.f_50075_).properties(p -> {
            if (GTBlocks.doMetalPipe(material)) {
                p.m_60918_(GTSoundTypes.METAL_PIPE);
            }
            return p.m_60988_().m_60955_().m_222994_().m_280606_();
        }).transform(GTBlocks.unificationBlock(itemPipeType.getTagPrefix(), material))).blockstate(NonNullBiConsumer.noop()).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).addLayer(() -> RenderType::m_110457_).addLayer(() -> RenderType::m_110466_).color(() -> MaterialPipeBlock::tintedColor).item(MaterialPipeBlockItem::new).model(NonNullBiConsumer.noop()).color(() -> MaterialPipeBlockItem::tintColor).build()).register();
        ITEM_PIPE_BLOCKS_BUILDER.put((Object)itemPipeType.getTagPrefix(), (Object)material, (Object)entry);
    }
}

