/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrapeBehavior
implements IToolBehavior {
    public static final ScrapeBehavior INSTANCE = new ScrapeBehavior();

    protected ScrapeBehavior() {
    }

    @Override
    @NotNull
    public InteractionResult onItemUse(UseOnContext context) {
        List<BlockPos> blocks;
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(stack);
        if (ScrapeBehavior.isBlockScrapable(context)) {
            if (aoeDefinition.isZero()) {
                blocks = List.of(pos);
            } else {
                blocks = ScrapeBehavior.getScrapableBlocks(aoeDefinition, context);
                blocks.add(0, context.m_8083_());
            }
        } else {
            return InteractionResult.PASS;
        }
        boolean scraped = false;
        for (BlockPos blockPos : blocks) {
            UseOnContext posContext = new UseOnContext(level, player, context.m_43724_(), stack, context.m_43718_().m_82430_(blockPos));
            BlockState newState = this.getScraped(level.m_8055_(blockPos), posContext);
            scraped |= level.m_7731_(blockPos, newState, 3);
            level.m_5898_(player, 3005, blockPos, 0);
            ToolHelper.damageItem(stack, (LivingEntity)player);
            if (!stack.m_41619_()) continue;
            break;
        }
        if (scraped) {
            level.m_5594_(player, blocks.get(0), SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static List<BlockPos> getScrapableBlocks(AoESymmetrical aoeDefinition, UseOnContext context) {
        return ToolHelper.iterateAoE(aoeDefinition, ScrapeBehavior::isBlockScrapable, context);
    }

    protected static boolean isBlockScrapable(UseOnContext context) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        BlockState newState = state.getToolModifiedState(context, ToolActions.AXE_SCRAPE, true);
        return newState != null && newState != state;
    }

    protected BlockState getScraped(BlockState state, UseOnContext context) {
        return state.getToolModifiedState(context, ToolActions.AXE_SCRAPE, false);
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable Level Level2, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.gtceu.tool.behavior.scrape"));
    }
}

