/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredPartMachine;
import com.gregtechceu.gtceu.api.machine.property.GTMachineModelProperties;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.DoubleSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MaintenanceHatchPartMachine
extends TieredPartMachine
implements IMachineLife,
IMaintenanceMachine,
IInteractedMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MaintenanceHatchPartMachine.class, MultiblockPartMachine.MANAGED_FIELD_HOLDER);
    private static final float MAX_DURATION_MULTIPLIER = 1.1f;
    private static final float MIN_DURATION_MULTIPLIER = 0.9f;
    private static final float DURATION_ACTION_AMOUNT = 0.01f;
    private final boolean isConfigurable;
    @Persisted
    private final NotifiableItemStackHandler itemStackHandler;
    @Persisted
    @DescSynced
    private boolean isTaped;
    @Persisted
    protected int timeActive;
    @Persisted
    @DescSynced
    protected byte maintenanceProblems = this.startProblems();
    @Persisted
    private float durationMultiplier = 1.0f;
    @Nullable
    protected TickableSubscription maintenanceSubs;

    public MaintenanceHatchPartMachine(IMachineBlockEntity holder, boolean isConfigurable) {
        super(holder, isConfigurable ? 3 : 1);
        this.isConfigurable = isConfigurable;
        this.itemStackHandler = this.createInventory();
        this.itemStackHandler.setFilter(itemStack -> itemStack.m_150930_((Item)GTItems.DUCT_TAPE.get()));
    }

    protected NotifiableItemStackHandler createInventory() {
        return new NotifiableItemStackHandler(this, 1, IO.BOTH, IO.BOTH);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onMachineRemoved() {
        this.clearInventory(this.itemStackHandler);
    }

    @Override
    public byte startProblems() {
        return 0;
    }

    @Override
    public void setMaintenanceProblems(byte problems) {
        this.maintenanceProblems = problems;
        this.updateMaintenanceSubscription();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.updateMaintenanceSubscription();
            MachineRenderState renderState = this.getRenderState();
            if (renderState.m_61138_((Property)GTMachineModelProperties.IS_TAPED) && this.isTaped != (Boolean)renderState.m_61143_((Property)GTMachineModelProperties.IS_TAPED)) {
                this.setRenderState((MachineRenderState)((Object)renderState.m_61124_((Property)GTMachineModelProperties.IS_TAPED, Boolean.valueOf(this.isTaped))));
            }
        }
    }

    protected void updateMaintenanceSubscription() {
        if (this.hasMaintenanceProblems()) {
            this.maintenanceSubs = this.subscribeServerTick(this.maintenanceSubs, this::update);
        } else if (this.maintenanceSubs != null) {
            this.maintenanceSubs.unsubscribe();
            this.maintenanceSubs = null;
        }
    }

    public void update() {
        if (this.getOffsetTimer() % 20L == 0L) {
            if (this.hasMaintenanceProblems()) {
                if (this.consumeDuctTape((IItemHandler)this.itemStackHandler, 0)) {
                    this.fixAllMaintenanceProblems();
                    this.setTaped(true);
                }
            } else {
                this.updateMaintenanceSubscription();
            }
        }
    }

    private void fixMaintenanceProblems(@Nullable Player entityPlayer) {
        if (!this.hasMaintenanceProblems()) {
            return;
        }
        if (entityPlayer != null) {
            if (entityPlayer.m_7500_()) {
                this.fixAllMaintenanceProblems();
                return;
            }
            for (int i = 0; i < entityPlayer.m_150109_().f_35974_.size(); ++i) {
                if (!this.consumeDuctTape((IItemHandler)new InvWrapper((Container)entityPlayer.m_150109_()), i)) continue;
                this.fixAllMaintenanceProblems();
                this.setTaped(true);
                return;
            }
            this.fixProblemsWithTools(this.getMaintenanceProblems(), entityPlayer);
        }
    }

    private boolean consumeDuctTape(IItemHandler handler, int slot) {
        ItemStack stored = handler.getStackInSlot(slot);
        if (!stored.m_41619_() && stored.m_150930_((Item)GTItems.DUCT_TAPE.get())) {
            return handler.extractItem(slot, 1, false).m_150930_((Item)GTItems.DUCT_TAPE.get());
        }
        return false;
    }

    private boolean consumeDuctTape(Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        if (!held.m_41619_() && held.m_150930_((Item)GTItems.DUCT_TAPE.get())) {
            if (!player.m_7500_()) {
                held.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    private void fixProblemsWithTools(byte problems, Player entityPlayer) {
        List<GTToolType> toolsToMatch = Arrays.asList(new GTToolType[6]);
        boolean proceed = false;
        block8: for (int index = 0; index < 6; index = (int)((byte)(index + 1))) {
            if ((problems >> index & 1) != 0) continue;
            proceed = true;
            switch (index) {
                case 0: {
                    toolsToMatch.set(0, GTToolType.WRENCH);
                    continue block8;
                }
                case 1: {
                    toolsToMatch.set(1, GTToolType.SCREWDRIVER);
                    continue block8;
                }
                case 2: {
                    toolsToMatch.set(2, GTToolType.SOFT_MALLET);
                    continue block8;
                }
                case 3: {
                    toolsToMatch.set(3, GTToolType.HARD_HAMMER);
                    continue block8;
                }
                case 4: {
                    toolsToMatch.set(4, GTToolType.WIRE_CUTTER);
                    continue block8;
                }
                case 5: {
                    toolsToMatch.set(5, GTToolType.CROWBAR);
                }
            }
        }
        if (!proceed) {
            return;
        }
        for (int i = 0; i < toolsToMatch.size(); ++i) {
            GTToolType toolToMatch = toolsToMatch.get(i);
            if (toolToMatch == null) continue;
            ItemStack heldItem = entityPlayer.f_36096_.m_142621_();
            if (ToolHelper.is(heldItem, toolToMatch)) {
                this.fixProblemWithTool(i, heldItem, entityPlayer);
                if (toolsToMatch.stream().allMatch(Objects::isNull)) {
                    return;
                }
            }
            for (ItemStack itemStack : entityPlayer.m_150109_().f_35974_) {
                if (!ToolHelper.is(itemStack, toolToMatch)) continue;
                this.fixProblemWithTool(i, itemStack, entityPlayer);
                if (!toolsToMatch.stream().allMatch(Objects::isNull)) continue;
                return;
            }
            if (!(entityPlayer instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)entityPlayer;
            for (ItemStack stack : entityPlayer.m_150109_().f_35974_) {
                if (!ToolHelper.is(stack, toolToMatch)) continue;
                this.setMaintenanceFixed(i);
                ToolHelper.damageItem(stack, (LivingEntity)player, 1);
                if (!toolsToMatch.stream().allMatch(Objects::isNull)) continue;
                return;
            }
        }
    }

    private void fixProblemWithTool(int problemIndex, ItemStack stack, Player player) {
        this.setMaintenanceFixed(problemIndex);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ToolHelper.damageItem(stack, (LivingEntity)serverPlayer, 1);
        }
        this.setTaped(false);
    }

    public void fixAllMaintenanceProblems() {
        for (int i = 0; i < 6; ++i) {
            this.setMaintenanceFixed(i);
        }
    }

    @Override
    public boolean isFullAuto() {
        return false;
    }

    @Override
    public void setTaped(boolean isTaped) {
        if (this.isTaped != isTaped) {
            this.isTaped = isTaped;
            this.setRenderState((MachineRenderState)((Object)this.getRenderState().m_61124_((Property)GTMachineModelProperties.IS_TAPED, Boolean.valueOf(isTaped))));
        }
    }

    @Override
    public float getTimeMultiplier() {
        float result = 1.0f;
        result = (double)this.durationMultiplier < 1.0 ? -20.0f * this.durationMultiplier + 21.0f : -8.0f * this.durationMultiplier + 9.0f;
        return BigDecimal.valueOf(result).setScale(2, RoundingMode.HALF_UP).floatValue();
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.hasMaintenanceProblems() && this.consumeDuctTape(player, hand)) {
            this.fixAllMaintenanceProblems();
            this.setTaped(true);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group;
        if (this.isConfigurable) {
            group = new WidgetGroup(0, 0, 150, 70);
            group.addWidget((Widget)new DraggableScrollableWidgetGroup(4, 4, 142, 62).setBackground((IGuiTexture)GuiTextures.DISPLAY).addWidget((Widget)new ComponentPanelWidget(4, 5, list -> {
                list.add(MaintenanceHatchPartMachine.getTextWidgetText("duration", this::getDurationMultiplier));
                list.add(MaintenanceHatchPartMachine.getTextWidgetText("time", this::getTimeMultiplier));
                MutableComponent buttonText = Component.m_237115_((String)"gtceu.maintenance.configurable_duration.modify");
                buttonText.m_130946_(" ");
                buttonText.m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[-]"), (String)"sub"));
                buttonText.m_130946_(" ");
                buttonText.m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[+]"), (String)"add"));
                list.add(buttonText);
            }).setMaxWidthLimit(130).clickHandler((componentData, clickData) -> {
                if (!clickData.isRemote) {
                    if (componentData.equals("sub")) {
                        this.durationMultiplier = Mth.m_14036_((float)(this.durationMultiplier - 0.01f), (float)0.9f, (float)1.1f);
                    } else if (componentData.equals("add")) {
                        this.durationMultiplier = Mth.m_14036_((float)(this.durationMultiplier + 0.01f), (float)0.9f, (float)1.1f);
                    }
                }
            })));
        } else {
            group = new WidgetGroup(0, 0, 26, 46);
        }
        group.addWidget(new SlotWidget(this.itemStackHandler, 0, group.getSize().width - 4 - 18, 4).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.DUCT_TAPE_OVERLAY})).setHoverTooltips(new String[]{"gtceu.machine.maintenance_hatch_tape_slot.tooltip"}));
        group.addWidget(new ButtonWidget(group.getSize().width - 4 - 18, 24, 18, 18, (IGuiTexture)GuiTextures.MAINTENANCE_BUTTON, data -> this.fixMaintenanceProblems(group.getGui().entityPlayer)).setHoverTooltips(new String[]{"gtceu.machine.maintenance_hatch_tool_slot.tooltip"}));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    private static Component getTextWidgetText(String type, DoubleSupplier multiplier) {
        MutableComponent tooltip = multiplier.getAsDouble() == 1.0 ? Component.m_237115_((String)("gtceu.maintenance.configurable_" + type + ".unchanged_description")) : Component.m_237110_((String)("gtceu.maintenance.configurable_" + type + ".changed_description"), (Object[])new Object[]{FormattingUtil.formatNumber2Places(multiplier.getAsDouble())});
        return Component.m_237110_((String)("gtceu.maintenance.configurable_" + type), (Object[])new Object[]{FormattingUtil.formatNumber2Places(multiplier.getAsDouble())}).m_6270_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)tooltip)));
    }

    @Generated
    public boolean isConfigurable() {
        return this.isConfigurable;
    }

    @Override
    @Generated
    public boolean isTaped() {
        return this.isTaped;
    }

    @Override
    @Generated
    public int getTimeActive() {
        return this.timeActive;
    }

    @Override
    @Generated
    public void setTimeActive(int timeActive) {
        this.timeActive = timeActive;
    }

    @Override
    @Generated
    public byte getMaintenanceProblems() {
        return this.maintenanceProblems;
    }

    @Override
    @Generated
    public float getDurationMultiplier() {
        return this.durationMultiplier;
    }
}

