/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.IDataAccessHatch;
import com.gregtechceu.gtceu.api.capability.IOpticalDataAccessHatch;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IWorkableMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.blockentity.OpticalPipeBlockEntity;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class OpticalDataHatchMachine
extends MultiblockPartMachine
implements IOpticalDataAccessHatch {
    private final boolean isTransmitter;

    public OpticalDataHatchMachine(IMachineBlockEntity holder, boolean isTransmitter) {
        super(holder);
        this.isTransmitter = isTransmitter;
    }

    @Override
    public boolean isRecipeAvailable(@NotNull GTRecipe recipe, @NotNull Collection<IDataAccessHatch> seen) {
        seen.add(this);
        if (!this.isFormed()) {
            return false;
        }
        if (this.isTransmitter()) {
            IWorkableMultiController workable;
            IMultiController controller = this.getControllers().first();
            if (!(controller instanceof IWorkableMultiController) || !(workable = (IWorkableMultiController)controller).getRecipeLogic().isWorking()) {
                return false;
            }
            ArrayList<IDataAccessHatch> dataAccesses = new ArrayList<IDataAccessHatch>();
            ArrayList<IDataAccessHatch> transmitters = new ArrayList<IDataAccessHatch>();
            for (IMultiPart part : controller.getParts()) {
                IDataAccessHatch hatch;
                Block block = part.self().getBlockState().m_60734_();
                if (part instanceof IDataAccessHatch) {
                    hatch = (IDataAccessHatch)((Object)part);
                    if (PartAbility.DATA_ACCESS.isApplicable(block)) {
                        dataAccesses.add(hatch);
                    }
                }
                if (!(part instanceof IDataAccessHatch)) continue;
                hatch = (IDataAccessHatch)((Object)part);
                if (!PartAbility.OPTICAL_DATA_RECEPTION.isApplicable(block)) continue;
                transmitters.add(hatch);
            }
            return OpticalDataHatchMachine.isRecipeAvailable(dataAccesses, seen, recipe) || OpticalDataHatchMachine.isRecipeAvailable(transmitters, seen, recipe);
        }
        BlockEntity tileEntity = this.getLevel().m_7702_(this.getPos().m_121945_(this.getFrontFacing()));
        if (tileEntity == null) {
            return false;
        }
        if (tileEntity instanceof OpticalPipeBlockEntity) {
            IDataAccessHatch cap = (IDataAccessHatch)tileEntity.getCapability(GTCapability.CAPABILITY_DATA_ACCESS, this.getFrontFacing().m_122424_()).orElse(null);
            return cap != null && cap.isRecipeAvailable(recipe, seen);
        }
        return false;
    }

    private static boolean isRecipeAvailable(@NotNull Iterable<? extends IDataAccessHatch> hatches, @NotNull Collection<IDataAccessHatch> seen, @NotNull GTRecipe recipe) {
        for (IDataAccessHatch iDataAccessHatch : hatches) {
            if (seen.contains(iDataAccessHatch) || !iDataAccessHatch.isRecipeAvailable(recipe, seen)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCreative() {
        return false;
    }

    @Override
    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        return false;
    }

    @Override
    public boolean canShared() {
        return false;
    }

    @Override
    public GTRecipe modifyRecipe(GTRecipe recipe) {
        return IOpticalDataAccessHatch.super.modifyRecipe(recipe);
    }

    @Override
    @Generated
    public boolean isTransmitter() {
        return this.isTransmitter;
    }
}

