/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.gregtechceu.gtceu.common.machine.multiblock.part.FluidHatchPartMachine;
import java.util.Collections;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ReservoirHatchPartMachine
extends FluidHatchPartMachine {
    protected InfiniteWaterTank waterTank;
    public static final int FLUID_AMOUNT = 2000000000;

    public ReservoirHatchPartMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, 4, IO.IN, 2000000000, 1, args);
    }

    @Override
    protected NotifiableFluidTank createTank(int initialCapacity, int slots, Object ... args) {
        this.waterTank = new InfiniteWaterTank(initialCapacity);
        return new NotifiableFluidTank((MetaMachine)this, Collections.singletonList(this.waterTank), this.io, IO.BOTH);
    }

    @Override
    protected void updateTankSubscription() {
        if (this.isWorkingEnabled() && !this.waterTank.isFull()) {
            this.autoIOSubs = this.subscribeServerTick(this.autoIOSubs, this::autoIO);
        } else if (this.autoIOSubs != null) {
            this.autoIOSubs.unsubscribe();
            this.autoIOSubs = null;
        }
    }

    @Override
    protected void autoIO() {
        if (this.getOffsetTimer() % 20L == 0L) {
            this.waterTank.refillWater();
            this.updateTankSubscription();
        }
    }

    @Override
    public boolean swapIO() {
        return false;
    }

    protected static class InfiniteWaterTank
    extends CustomFluidTank {
        private static final CompoundTag EMPTY = new CompoundTag();
        private static final FluidStack WATER = new FluidStack((Fluid)Fluids.f_76193_, Integer.MAX_VALUE);

        public InfiniteWaterTank(int capacity) {
            super(capacity);
            this.setFluid(new FluidStack((Fluid)Fluids.f_76193_, capacity));
        }

        public void refillWater() {
            super.fill(WATER, IFluidHandler.FluidAction.EXECUTE);
        }

        public boolean isFull() {
            return this.getFluidAmount() >= this.capacity;
        }

        @Override
        public boolean supportsFill(int tank) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Override
        public CompoundTag serializeNBT() {
            return EMPTY;
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
        }
    }
}

