/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.BlockableSlotWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IRotorHolderMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IWorkableMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredPartMachine;
import com.gregtechceu.gtceu.api.machine.property.GTMachineModelProperties;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.gregtechceu.gtceu.common.data.GTDamageTypes;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.item.TurbineRotorBehaviour;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RotorHolderPartMachine
extends TieredPartMachine
implements IMachineLife,
IRotorHolderMachine,
IInteractedMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(RotorHolderPartMachine.class, TieredPartMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    public final NotifiableItemStackHandler inventory;
    public final int maxRotorHolderSpeed;
    @Persisted
    @DescSynced
    public int rotorSpeed;
    @Persisted
    @DescSynced
    @NotNull
    public Material rotorMaterial = GTMaterials.NULL;
    @Nullable
    protected TickableSubscription rotorSpeedSubs;
    @Nullable
    protected ISubscription rotorInvSubs;

    public RotorHolderPartMachine(IMachineBlockEntity holder, int tier) {
        super(holder, tier);
        this.inventory = new NotifiableItemStackHandler(this, 1, IO.NONE, IO.BOTH);
        this.maxRotorHolderSpeed = 2000 + 1000 * tier;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.inventory.storage);
    }

    @Override
    public int tintColor(int index) {
        if (index >= 2) {
            return this.getRotorMaterial().getLayerARGB(index - 2);
        }
        if (index <= -103) {
            return this.getRotorMaterial().getLayerARGB(index + 2);
        }
        return super.tintColor(index);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.updateRotorSubscription();
            this.rotorInvSubs = this.inventory.addChangedListener(this::onRotorInventoryChanged);
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.rotorInvSubs != null) {
            this.rotorInvSubs.unsubscribe();
        }
    }

    @Override
    public boolean canShared() {
        return false;
    }

    @Override
    @NotNull
    public Material getRotorMaterial() {
        if (this.rotorMaterial == null) {
            return GTMaterials.NULL;
        }
        return this.rotorMaterial;
    }

    private void onRotorInventoryChanged() {
        ItemStack stack = this.getRotorStack();
        TurbineRotorBehaviour rotorBehaviour = TurbineRotorBehaviour.getBehaviour(stack);
        if (rotorBehaviour != null) {
            this.rotorMaterial = rotorBehaviour.getPartMaterial(stack);
            boolean emissive = this.rotorMaterial.hasProperty(PropertyKey.ORE) && this.rotorMaterial.getProperty(PropertyKey.ORE).isEmissive();
            this.setRenderState((MachineRenderState)((Object)((MachineRenderState)((Object)this.getRenderState().m_61124_((Property)GTMachineModelProperties.HAS_ROTOR, Boolean.valueOf(true)))).m_61124_((Property)GTMachineModelProperties.IS_EMISSIVE_ROTOR, Boolean.valueOf(emissive))));
        } else {
            this.rotorMaterial = GTMaterials.NULL;
            this.setRenderState((MachineRenderState)((Object)((MachineRenderState)((Object)this.getRenderState().m_61124_((Property)GTMachineModelProperties.HAS_ROTOR, Boolean.valueOf(false)))).m_61124_((Property)GTMachineModelProperties.IS_EMISSIVE_ROTOR, Boolean.valueOf(false))));
        }
    }

    @Override
    public boolean hasRotor() {
        return this.inventory.getStackInSlot(0) != ItemStack.f_41583_;
    }

    protected void updateRotorSubscription() {
        if (this.getRotorSpeed() > 0) {
            this.rotorSpeedSubs = this.subscribeServerTick(this.rotorSpeedSubs, this::updateRotorSpeed);
        } else if (this.rotorSpeedSubs != null) {
            this.rotorSpeedSubs.unsubscribe();
            this.rotorSpeedSubs = null;
        }
    }

    private void updateRotorSpeed() {
        IWorkableMultiController workable;
        IMultiController iMultiController;
        if (this.isFormed() && (iMultiController = this.getControllers().first()) instanceof IWorkableMultiController && (workable = (IWorkableMultiController)iMultiController).getRecipeLogic().isWorking()) {
            return;
        }
        if (!this.hasRotor()) {
            this.setRotorSpeed(0);
        } else if (this.getRotorSpeed() > 0) {
            this.setRotorSpeed(Math.max(0, this.getRotorSpeed() - 3));
        }
        this.updateRotorSubscription();
    }

    @Override
    public void setRotorSpeed(int rotorSpeed) {
        if (this.rotorSpeed > 0 && rotorSpeed <= 0 || this.rotorSpeed <= 0 && rotorSpeed > 0) {
            this.setRenderState((MachineRenderState)((Object)this.getRenderState().m_61124_((Property)GTMachineModelProperties.IS_ROTOR_SPINNING, Boolean.valueOf(rotorSpeed > 0))));
        }
        this.rotorSpeed = rotorSpeed;
    }

    @Override
    public boolean onWorking(IWorkableMultiController controller) {
        if (this.getRotorSpeed() < this.getMaxRotorHolderSpeed()) {
            this.setRotorSpeed(this.getRotorSpeed() + 1);
            this.updateRotorSubscription();
        }
        if (this.self().getOffsetTimer() % 20L == 0L) {
            IMultiController iMultiController;
            int numMaintenanceProblems = 0;
            if (this.isFormed() && (iMultiController = this.getControllers().first()) instanceof IMaintenanceMachine) {
                IMaintenanceMachine maintenance = (IMaintenanceMachine)((Object)iMultiController);
                numMaintenanceProblems = maintenance.getNumMaintenanceProblems();
            }
            this.damageRotor(1 + numMaintenanceProblems);
        }
        return true;
    }

    @Override
    public int getTierDifference() {
        IMultiController iMultiController;
        if (this.isFormed() && (iMultiController = this.getControllers().first()) instanceof ITieredMachine) {
            ITieredMachine tieredMachine = (ITieredMachine)((Object)iMultiController);
            return this.getTier() - tieredMachine.getTier();
        }
        return -1;
    }

    @Override
    public ItemStack getRotorStack() {
        return this.inventory.getStackInSlot(0);
    }

    @Override
    public void setRotorStack(ItemStack rotorStack) {
        this.inventory.setStackInSlot(0, rotorStack);
        this.inventory.onContentsChanged();
    }

    @Override
    public InteractionResult onUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.isRemote() && this.getRotorSpeed() > 0 && !player.m_7500_()) {
            player.m_6469_(GTDamageTypes.TURBINE.source((LevelAccessor)level), TurbineRotorBehaviour.getBehaviour(this.getRotorStack()).getDamage(this.getRotorStack()));
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 34, 34);
        WidgetGroup container = new WidgetGroup(4, 4, 26, 26);
        container.addWidget(new BlockableSlotWidget((IItemHandlerModifiable)this.inventory.storage, 0, 4, 4).setIsBlocked(() -> this.rotorSpeed != 0).setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.TURBINE_OVERLAY}));
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        group.addWidget((Widget)container);
        return group;
    }

    @Override
    @Generated
    public int getMaxRotorHolderSpeed() {
        return this.maxRotorHolderSpeed;
    }

    @Override
    @Generated
    public int getRotorSpeed() {
        return this.rotorSpeed;
    }

    @Generated
    public void setRotorMaterial(@NotNull Material rotorMaterial) {
        if (rotorMaterial == null) {
            throw new NullPointerException("rotorMaterial is marked non-null but is null");
        }
        this.rotorMaterial = rotorMaterial;
    }
}

