/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.network.packets;

import com.gregtechceu.gtceu.client.util.ClientImageCache;
import com.gregtechceu.gtceu.common.network.GTNetwork;
import com.gregtechceu.gtceu.utils.GTMath;
import java.io.IOException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.ArrayUtils;

public class SPacketImageResponse
implements GTNetwork.INetPacket {
    private static final int MAX_BYTES_PER_PACKET = 120000;
    private final byte[] imagePart;
    private final String url;
    private final int index;
    private final int totalSize;

    public SPacketImageResponse(String url, byte[] imagePart, int index, int totalSize) {
        this.url = url;
        this.imagePart = imagePart;
        this.index = index;
        this.totalSize = totalSize;
    }

    public SPacketImageResponse(FriendlyByteBuf buf) {
        this.index = buf.readInt();
        this.totalSize = buf.readInt();
        this.url = buf.m_130277_();
        this.imagePart = buf.m_130052_();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.index);
        buffer.writeInt(this.totalSize);
        buffer.m_130070_(this.url);
        buffer.m_130087_(this.imagePart);
    }

    @Override
    public void execute(NetworkEvent.Context context) {
        if (this.imagePart == null) {
            return;
        }
        try {
            ClientImageCache.receiveImagePart(this.url, this.imagePart, this.index, this.totalSize);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void sendImage(String url, byte[] imageBytes, NetworkEvent.Context context) throws IOException {
        if (imageBytes.length < 120000) {
            GTNetwork.reply(context, new SPacketImageResponse(url, imageBytes, 0, 1));
        } else {
            int remaining;
            int packetCount = GTMath.ceilDiv(imageBytes.length, 120000);
            int arrayIndex = 0;
            for (int i = 0; i < packetCount && (remaining = imageBytes.length - arrayIndex) > 0; ++i) {
                byte[] part = ArrayUtils.subarray((byte[])imageBytes, (int)arrayIndex, (int)(arrayIndex + 120000));
                GTNetwork.reply(context, new SPacketImageResponse(url, part, i, packetCount));
                arrayIndex += 120000;
            }
        }
    }
}

