/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.recipe.condition;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.condition.RecipeConditionType;
import com.gregtechceu.gtceu.common.data.GTRecipeConditions;
import com.gregtechceu.gtceu.common.machine.owner.MachineOwner;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.heracles.common.handlers.progress.QuestProgress;
import earth.terrarium.heracles.common.handlers.progress.QuestProgressHandler;
import earth.terrarium.heracles.common.handlers.progress.QuestsProgress;
import earth.terrarium.heracles.common.handlers.quests.QuestHandler;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class HeraclesQuestCondition
extends RecipeCondition {
    public static final Codec<HeraclesQuestCondition> CODEC = RecordCodecBuilder.create(instance -> RecipeCondition.isReverse(instance).and((App)Codec.STRING.fieldOf("questId").forGetter(val -> val.questId)).apply((Applicative)instance, HeraclesQuestCondition::new));
    public static final HeraclesQuestCondition INSTANCE = new HeraclesQuestCondition();
    private String questId;

    public HeraclesQuestCondition(String questId) {
        this.questId = questId;
    }

    public HeraclesQuestCondition(boolean isReverse, String questId) {
        super(isReverse);
        this.questId = questId;
    }

    @Override
    public RecipeConditionType<?> getType() {
        return GTRecipeConditions.HERACLES_QUEST;
    }

    @Override
    public Component getTooltips() {
        String questTitle = QuestHandler.get((String)this.questId).display().title().toString();
        if (this.isReverse) {
            return Component.m_237110_((String)"recipe.condition.quest.not_completed.tooltip", (Object[])new Object[]{questTitle});
        }
        return Component.m_237110_((String)"recipe.condition.quest.completed.tooltip", (Object[])new Object[]{questTitle});
    }

    @Override
    public boolean testCondition(@NotNull GTRecipe recipe, @NotNull RecipeLogic recipeLogic) {
        MachineOwner owner = recipeLogic.machine.self().getOwner();
        if (owner == null) {
            return false;
        }
        for (UUID player : owner.getMembers()) {
            QuestsProgress questsProgress = QuestProgressHandler.getProgress((MinecraftServer)ServerLifecycleHooks.getCurrentServer(), (UUID)player);
            QuestProgress progress = questsProgress.getProgress(this.questId);
            if (progress == null || !progress.isComplete() && !QuestHandler.get((String)this.questId).tasks().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public RecipeCondition createTemplate() {
        return new HeraclesQuestCondition();
    }

    @Override
    @NotNull
    public JsonObject serialize() {
        JsonObject obj = super.serialize();
        obj.addProperty("questId", this.questId);
        return obj;
    }

    @Override
    public RecipeCondition deserialize(@NotNull JsonObject config) {
        super.deserialize(config);
        this.questId = GsonHelper.m_13906_((JsonObject)config, (String)"questId");
        return this;
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.questId = buf.m_130277_();
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.m_130070_(this.questId);
    }

    @Generated
    public HeraclesQuestCondition() {
    }
}

