/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeCategories;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.item.TurbineRotorBehaviour;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public final class PartsRecipeHandler {
    private PartsRecipeHandler() {
    }

    public static void run(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        PartsRecipeHandler.processRod(provider, material);
        PartsRecipeHandler.processLongRod(provider, material);
        PartsRecipeHandler.processPlate(provider, material);
        PartsRecipeHandler.processPlateDouble(provider, material);
        PartsRecipeHandler.processPlateDense(provider, material);
        PartsRecipeHandler.processTurbine(provider, material);
        PartsRecipeHandler.processRotor(provider, material);
        PartsRecipeHandler.processBolt(provider, material);
        PartsRecipeHandler.processScrew(provider, material);
        PartsRecipeHandler.processFineWire(provider, material);
        PartsRecipeHandler.processFoil(provider, material);
        PartsRecipeHandler.processLens(provider, material);
        PartsRecipeHandler.processGear(provider, TagPrefix.gear, material);
        PartsRecipeHandler.processGear(provider, TagPrefix.gearSmall, material);
        PartsRecipeHandler.processRing(provider, material);
        PartsRecipeHandler.processSpring(provider, TagPrefix.spring, material);
        PartsRecipeHandler.processSpring(provider, TagPrefix.springSmall, material);
        PartsRecipeHandler.processRound(provider, material);
    }

    private static void processBolt(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.bolt) || !material.hasProperty(PropertyKey.DUST)) {
            return;
        }
        ItemStack boltStack = ChemicalHelper.get(TagPrefix.bolt, material.hasFlag(MaterialFlags.IS_MAGNETIC) && material.hasProperty(PropertyKey.INGOT) ? material.getProperty(PropertyKey.INGOT).getMacerateInto() : material);
        ItemStack ingotStack = ChemicalHelper.get(TagPrefix.ingot, material);
        GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + material.getName() + "_screw_to_bolt").inputItems(TagPrefix.screw, material).outputItems(boltStack).duration(20).EUt(24L).save(provider);
        if (!boltStack.m_41619_() && !ingotStack.m_41619_()) {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_bolt").inputItems(TagPrefix.ingot, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_BOLT).outputItems(boltStack.m_255036_(8)).duration(15).EUt(GTValues.VA[2]).save(provider);
            if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_bolt").inputItems(TagPrefix.dust, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_BOLT).outputItems(boltStack.m_255036_(8)).duration(15).EUt(GTValues.VA[2]).save(provider);
            }
        }
    }

    private static void processScrew(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.screw) || !material.hasProperty(PropertyKey.DUST)) {
            return;
        }
        ItemStack screwStack = ChemicalHelper.get(TagPrefix.screw, material.hasFlag(MaterialFlags.IS_MAGNETIC) && material.hasProperty(PropertyKey.INGOT) ? material.getProperty(PropertyKey.INGOT).getMacerateInto() : material);
        GTRecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_" + material.getName() + "_bolt_to_screw").inputItems(TagPrefix.bolt, material).outputItems(screwStack).duration((int)Math.max(1L, material.getMass() / 8L)).EUt(4L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("screw_%s", material.getName()), screwStack, "fX", "X ", Character.valueOf('X'), new MaterialEntry(TagPrefix.bolt, material));
    }

    private static void processFoil(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        Material magMaterial;
        if (!material.shouldGenerateRecipesFor(TagPrefix.foil) || !material.hasProperty(PropertyKey.INGOT)) {
            return;
        }
        Material material2 = magMaterial = material.hasFlag(MaterialFlags.IS_MAGNETIC) ? material.getProperty(PropertyKey.INGOT).getMacerateInto() : material;
        if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("foil_%s", material.getName()), ChemicalHelper.get(TagPrefix.foil, material, 2), "hP ", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, magMaterial));
        }
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_plate_to_foil").inputItems(TagPrefix.plate, material).outputItems(TagPrefix.foil, magMaterial, 4).duration((int)material.getMass()).EUt(24L).circuitMeta(1).save(provider);
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_ingot_to_foil").inputItems(TagPrefix.ingot, material).outputItems(TagPrefix.foil, magMaterial, 4).duration((int)material.getMass()).EUt(24L).circuitMeta(10).save(provider);
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_foil").inputItems(TagPrefix.ingot, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_FOIL).outputItems(TagPrefix.foil, magMaterial, 4).duration((int)material.getMass()).EUt(24L).save(provider);
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_foil").inputItems(TagPrefix.dust, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_FOIL).outputItems(TagPrefix.foil, magMaterial, 4).duration((int)material.getMass()).EUt(24L).save(provider);
        }
    }

    private static void processFineWire(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.wireFine) || !material.hasProperty(PropertyKey.INGOT)) {
            return;
        }
        ItemStack fineWireStack = ChemicalHelper.get(TagPrefix.wireFine, material.hasFlag(MaterialFlags.IS_MAGNETIC) ? material.getProperty(PropertyKey.INGOT).getMacerateInto() : material);
        if (!ChemicalHelper.get(TagPrefix.foil, material).m_41619_()) {
            VanillaRecipeHelper.addShapelessRecipe(provider, String.format("fine_wire_%s", material.getName()), fineWireStack, Character.valueOf('x'), new MaterialEntry(TagPrefix.foil, material));
        }
        if (material.hasProperty(PropertyKey.WIRE)) {
            GTRecipeTypes.WIREMILL_RECIPES.recipeBuilder("mill_" + material.getName() + "_wire_to_fine_wire").inputItems(TagPrefix.wireGtSingle, material).outputItems(fineWireStack.m_255036_(4)).duration((int)material.getMass() * 3 / 2).EUt(GTValues.VA[0]).save(provider);
        } else {
            GTRecipeTypes.WIREMILL_RECIPES.recipeBuilder("mill_" + material.getName() + "ingot_to_fine_wire").inputItems(TagPrefix.ingot, material).outputItems(fineWireStack.m_255036_(8)).duration((int)material.getMass() * 3).EUt(GTValues.VA[0]).save(provider);
        }
    }

    private static void processGear(@NotNull Consumer<FinishedRecipe> provider, @NotNull TagPrefix prefix, @NotNull Material material) {
        FluidStack fluidStack;
        if (!material.shouldGenerateRecipesFor(prefix) || !material.hasProperty(PropertyKey.DUST)) {
            return;
        }
        boolean isSmall = prefix == TagPrefix.gearSmall;
        ItemStack stack = ChemicalHelper.get(prefix, material.hasFlag(MaterialFlags.IS_MAGNETIC) && material.hasProperty(PropertyKey.INGOT) ? material.getProperty(PropertyKey.INGOT).getMacerateInto() : material);
        if (!isSmall && material.hasProperty(PropertyKey.INGOT)) {
            int voltageMultiplier = PartsRecipeHandler.getVoltageMultiplier(material);
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_gear").inputItems(TagPrefix.ingot, material, 4).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_GEAR).outputItems(stack).duration((int)material.getMass() * 5).EUt(8L * (long)voltageMultiplier).save(provider);
            GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("alloy_smelt_" + material.getName() + "_ingot_to_gear").inputItems(TagPrefix.ingot, material, 8).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_GEAR).outputItems(stack).duration((int)material.getMass() * 10).EUt(2L * (long)voltageMultiplier).category(GTRecipeCategories.INGOT_MOLDING).save(provider);
            if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_gear").inputItems(TagPrefix.dust, material, 4).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_GEAR).outputItems(stack).duration((int)material.getMass() * 5).EUt(8L * (long)voltageMultiplier).save(provider);
            }
        }
        if (material.hasFluid() && !(fluidStack = material.getProperty(PropertyKey.FLUID).solidifiesFrom(144 * (isSmall ? 1 : 4))).isEmpty()) {
            GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_" + prefix.name).notConsumable((Supplier<? extends Item>)(isSmall ? GTItems.SHAPE_MOLD_GEAR_SMALL : GTItems.SHAPE_MOLD_GEAR)).inputFluids(fluidStack).outputItems(stack).duration(isSmall ? 20 : 100).EUt(GTValues.VA[0]).save(provider);
        }
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE) && material.hasFlag(MaterialFlags.GENERATE_ROD)) {
            if (isSmall) {
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("small_gear_%s", material.getName()), stack, " R ", "hPx", " R ", Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, material), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material));
                GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_small_gear").inputItems(TagPrefix.ingot, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_GEAR_SMALL).outputItems(stack).duration((int)material.getMass()).EUt(material.getBlastTemperature() >= 2800 ? 256L : 64L).save(provider);
                GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("alloy_smelt_" + material.getName() + "_ingot_to_small_gear").duration((int)material.getMass()).EUt(GTValues.VA[1]).inputItems(TagPrefix.ingot, material, 2).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_GEAR_SMALL).outputItems(stack).category(GTRecipeCategories.INGOT_MOLDING).save(provider);
                if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                    GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_small_gear").inputItems(TagPrefix.dust, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_GEAR_SMALL).outputItems(stack).duration((int)material.getMass()).EUt(material.getBlastTemperature() >= 2800 ? 256L : 64L).save(provider);
                }
            } else {
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("gear_%s", material.getName()), stack, "RPR", "PwP", "RPR", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material), Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, material));
            }
        }
    }

    private static void processLens(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.lens) || !material.hasProperty(PropertyKey.GEM)) {
            return;
        }
        GTRecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_" + material.getName() + "_plate_to_lens").inputItems(TagPrefix.plate, material).outputItems(TagPrefix.lens, material).outputItems(TagPrefix.dustSmall, material).duration(1200).EUt(120L).save(provider);
        if (!ChemicalHelper.get(TagPrefix.gemExquisite, material).m_41619_()) {
            GTRecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_" + material.getName() + "_gem_to_lens").inputItems(TagPrefix.gemExquisite, material).outputItems(TagPrefix.lens, material).outputItems(TagPrefix.dust, material, 2).duration(2400).EUt(30L).save(provider);
        }
    }

    private static void processPlate(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        FluidStack stack;
        if (!material.shouldGenerateRecipesFor(TagPrefix.plate) || !material.hasProperty(PropertyKey.DUST)) {
            return;
        }
        if (material.hasFluid() && !(stack = material.getProperty(PropertyKey.FLUID).solidifiesFrom(144)).isEmpty()) {
            GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_to_plate").notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_PLATE).inputFluids(stack).outputItems(TagPrefix.plate, material).duration(40).EUt(GTValues.VA[0]).save(provider);
        }
    }

    private static void processPlateDouble(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        Material magMaterial;
        if (!material.shouldGenerateRecipesFor(TagPrefix.plateDouble) || !material.hasProperty(PropertyKey.INGOT)) {
            return;
        }
        Material material2 = magMaterial = material.hasFlag(MaterialFlags.IS_MAGNETIC) ? material.getProperty(PropertyKey.INGOT).getMacerateInto() : material;
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("plate_double_%s", material.getName()), ChemicalHelper.get(TagPrefix.plateDouble, magMaterial), "h", "P", "P", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material));
            }
            GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_plate_to_double_plate").EUt(96L).duration((int)material.getMass() * 2).inputItems(TagPrefix.plate, material, 2).outputItems(TagPrefix.plateDouble, magMaterial).circuitMeta(2).save(provider);
            GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_ingot_to_double_plate").inputItems(TagPrefix.ingot, material, 2).circuitMeta(2).outputItems(TagPrefix.plateDouble, magMaterial).duration((int)material.getMass() * 2).EUt(96L).save(provider);
        }
    }

    private static void processPlateDense(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.plateDense) || !material.hasProperty(PropertyKey.DUST)) {
            return;
        }
        Material magMaterial = material.hasFlag(MaterialFlags.IS_MAGNETIC) && material.hasProperty(PropertyKey.INGOT) ? material.getProperty(PropertyKey.INGOT).getMacerateInto() : material;
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_plate_to_dense_plate").inputItems(TagPrefix.plate, material, 9).circuitMeta(9).outputItems(TagPrefix.plateDense, magMaterial).duration((int)Math.max(material.getMass() * 9L, 1L)).EUt(96L).save(provider);
        if (material.hasProperty(PropertyKey.INGOT)) {
            GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_ingot_to_dense_plate").inputItems(TagPrefix.ingot, material, 9).circuitMeta(9).outputItems(TagPrefix.plateDense, magMaterial).duration((int)Math.max(material.getMass() * 9L, 1L)).EUt(96L).save(provider);
        }
    }

    private static void processRing(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.ring) || !material.hasProperty(PropertyKey.INGOT)) {
            return;
        }
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_ring").inputItems(TagPrefix.ingot, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_RING).outputItems(TagPrefix.ring, material, 4).duration((int)material.getMass() * 2).EUt(6L * (long)PartsRecipeHandler.getVoltageMultiplier(material)).save(provider);
        if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("ring_%s", material.getName()), ChemicalHelper.get(TagPrefix.ring, material), "h ", "fX", Character.valueOf('X'), new MaterialEntry(TagPrefix.rod, material));
        } else {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_ring").inputItems(TagPrefix.dust, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_RING).outputItems(TagPrefix.ring, material, 4).duration((int)material.getMass() * 2).EUt(6L * (long)PartsRecipeHandler.getVoltageMultiplier(material)).save(provider);
        }
    }

    private static void processSpring(@NotNull Consumer<FinishedRecipe> provider, @NotNull TagPrefix prefix, @NotNull Material material) {
        boolean isSmall;
        if (!material.shouldGenerateRecipesFor(prefix) || !material.hasProperty(PropertyKey.INGOT)) {
            return;
        }
        boolean bl = isSmall = prefix == TagPrefix.springSmall;
        if (isSmall) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("spring_small_%s", material.getName()), ChemicalHelper.get(TagPrefix.springSmall, material), " s ", "fRx", Character.valueOf('R'), new MaterialEntry(TagPrefix.rod, material));
            GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_rod_to_small_spring").duration((int)(material.getMass() / 2L)).EUt(GTValues.VA[0]).inputItems(TagPrefix.rod, material).outputItems(TagPrefix.springSmall, material, 2).circuitMeta(1).save(provider);
        } else {
            GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_long_rod_to_spring").inputItems(TagPrefix.rodLong, material).outputItems(TagPrefix.spring, material).circuitMeta(1).duration(200).EUt(16L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("spring_%s", material.getName()), ChemicalHelper.get(TagPrefix.spring, material), " s ", "fRx", " R ", Character.valueOf('R'), new MaterialEntry(TagPrefix.rodLong, material));
        }
    }

    private static void processRotor(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        FluidStack fluidStack;
        if (!material.shouldGenerateRecipesFor(TagPrefix.rotor) || !material.hasProperty(PropertyKey.INGOT)) {
            return;
        }
        ItemStack stack = ChemicalHelper.get(TagPrefix.rotor, material);
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("rotor_%s", material.getName()), stack, "ChC", "SRf", "CdC", Character.valueOf('C'), new MaterialEntry(TagPrefix.plate, material), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, material), Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, material));
        if (material.hasFluid() && !(fluidStack = material.getProperty(PropertyKey.FLUID).solidifiesFrom(576)).isEmpty()) {
            GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_to_rotor").notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_ROTOR).inputFluids(fluidStack).outputItems(stack.m_41777_()).duration(120).EUt(20L).save(provider);
        }
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_rotor").inputItems(TagPrefix.ingot, material, 4).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_ROTOR).outputItems(stack.m_41777_()).duration((int)material.getMass() * 4).EUt(material.getBlastTemperature() >= 2800 ? 256L : 64L).save(provider);
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_rotor").inputItems(TagPrefix.dust, material, 4).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_ROTOR).outputItems(stack.m_41777_()).duration((int)material.getMass() * 4).EUt(material.getBlastTemperature() >= 2800 ? 256L : 64L).save(provider);
        }
    }

    private static void processRod(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.rod) || !material.hasProperty(PropertyKey.DUST)) {
            return;
        }
        if (material.hasProperty(PropertyKey.GEM) || material.hasProperty(PropertyKey.INGOT)) {
            Material materialOutput;
            GTRecipeBuilder builder = GTRecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_" + material.getName() + "_to_rod").inputItems(material.hasProperty(PropertyKey.GEM) ? TagPrefix.gem : TagPrefix.ingot, material).duration((int)Math.max(material.getMass() * 2L, 1L)).EUt(16L);
            Material material2 = materialOutput = material.hasFlag(MaterialFlags.IS_MAGNETIC) && material.hasProperty(PropertyKey.INGOT) ? material.getProperty(PropertyKey.INGOT).getMacerateInto() : material;
            if (ConfigHolder.INSTANCE.recipes.harderRods) {
                builder.outputItems(TagPrefix.rod, materialOutput);
                builder.outputItems(TagPrefix.dustSmall, materialOutput, 2);
            } else {
                builder.outputItems(TagPrefix.rod, materialOutput, 2);
            }
            builder.save(provider);
        }
        if (material.hasFlag(MaterialFlags.GENERATE_BOLT_SCREW)) {
            ItemStack boltStack = ChemicalHelper.get(TagPrefix.bolt, material.hasFlag(MaterialFlags.IS_MAGNETIC) ? material.getProperty(PropertyKey.INGOT).getMacerateInto() : material);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + material.getName() + "_rod_to_bolt").inputItems(TagPrefix.rod, material).outputItems(boltStack.m_255036_(4)).duration((int)Math.max(material.getMass() * 2L, 1L)).EUt(4L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("bolt_saw_%s", material.getName()), boltStack.m_255036_(2), "s ", " X", Character.valueOf('X'), new MaterialEntry(TagPrefix.rod, material));
        }
    }

    private static void processLongRod(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.rodLong) || !material.hasProperty(PropertyKey.DUST)) {
            return;
        }
        ItemStack stack = ChemicalHelper.get(TagPrefix.rodLong, material.hasFlag(MaterialFlags.IS_MAGNETIC) && material.hasProperty(PropertyKey.INGOT) ? material.getProperty(PropertyKey.INGOT).getMacerateInto() : material);
        ItemStack stickStack = ChemicalHelper.get(TagPrefix.rod, material.hasFlag(MaterialFlags.IS_MAGNETIC) && material.hasProperty(PropertyKey.INGOT) ? material.getProperty(PropertyKey.INGOT).getMacerateInto() : material);
        GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + material.getName() + "_long_rod_to_rod").inputItems(TagPrefix.rodLong, material).outputItems(stickStack.m_255036_(2)).duration((int)Math.max(material.getMass(), 1L)).EUt(4L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("stick_long_%s", material.getName()), stickStack.m_255036_(2), "s", "X", Character.valueOf('X'), new MaterialEntry(TagPrefix.rodLong, material));
        if (material.hasProperty(PropertyKey.GEM)) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("stick_long_gem_flawless_%s", material.getName()), stickStack, "sf", "G ", Character.valueOf('G'), new MaterialEntry(TagPrefix.gemFlawless, material));
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("stick_long_gem_exquisite_%s", material.getName()), stickStack.m_255036_(2), "sf", "G ", Character.valueOf('G'), new MaterialEntry(TagPrefix.gemExquisite, material));
        }
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("stick_long_stick_%s", material.getName()), stack, "ShS", Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, material));
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + material.getName() + "_rod_to_long_rod").inputItems(TagPrefix.rod, material, 2).outputItems(stack).duration((int)Math.max(material.getMass(), 1L)).EUt(16L).save(provider);
    }

    private static void processTurbine(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.turbineBlade) || !material.hasProperty(PropertyKey.INGOT)) {
            return;
        }
        ItemStack rotorStack = GTItems.TURBINE_ROTOR.asStack();
        TurbineRotorBehaviour.getBehaviour(rotorStack).setPartMaterial(rotorStack, material);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("assemble_" + material.getName() + "_turbine_blade").inputItems(TagPrefix.turbineBlade, material, 8).inputItems(TagPrefix.rodLong, GTMaterials.Magnalium).outputItems(rotorStack).duration(200).EUt(400L).save(provider);
        GTRecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("press_" + material.getName() + "_turbine_rotor").inputItems(TagPrefix.plateDouble, material, 5).inputItems(TagPrefix.screw, material, 2).outputItems(TagPrefix.turbineBlade, material).duration(20).EUt(256L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("turbine_blade_%s", material.getName()), ChemicalHelper.get(TagPrefix.turbineBlade, material), "PPP", "SPS", "fPd", Character.valueOf('P'), new MaterialEntry(TagPrefix.plateDouble, material), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, material));
    }

    private static void processRound(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        Material outputMaterial;
        if (!material.shouldGenerateRecipesFor(TagPrefix.round) || !material.hasProperty(PropertyKey.INGOT)) {
            return;
        }
        Material material2 = outputMaterial = material.hasFlag(MaterialFlags.IS_MAGNETIC) ? material.getProperty(PropertyKey.INGOT).getMacerateInto() : material;
        if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("round_%s", material.getName()), ChemicalHelper.get(TagPrefix.round, outputMaterial), "fN", "Nh", Character.valueOf('N'), new MaterialEntry(TagPrefix.nugget, material));
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("round_from_ingot_%s", material.getName()), ChemicalHelper.get(TagPrefix.round, outputMaterial, 4), "fIh", Character.valueOf('I'), new MaterialEntry(TagPrefix.ingot, material));
        }
        GTRecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_" + material.getName() + "_nugget_to_round").EUt(GTValues.VA[0]).duration(100).inputItems(TagPrefix.nugget, material).outputItems(TagPrefix.round, outputMaterial).save(provider);
    }

    private static int getVoltageMultiplier(@NotNull Material material) {
        return material.getBlastTemperature() > 2800 ? GTValues.VA[1] : GTValues.VA[0];
    }
}

