/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.create;

import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.placeholder.IPlaceholderInfoProviderCover;
import com.gregtechceu.gtceu.api.placeholder.MultiLineComponent;
import com.gregtechceu.gtceu.api.placeholder.Placeholder;
import com.gregtechceu.gtceu.api.placeholder.PlaceholderContext;
import com.gregtechceu.gtceu.api.placeholder.PlaceholderHandler;
import com.gregtechceu.gtceu.api.placeholder.PlaceholderUtils;
import com.gregtechceu.gtceu.api.placeholder.exceptions.InvalidArgsException;
import com.gregtechceu.gtceu.api.placeholder.exceptions.MissingItemException;
import com.gregtechceu.gtceu.api.placeholder.exceptions.NotSupportedException;
import com.gregtechceu.gtceu.api.placeholder.exceptions.PlaceholderException;
import com.gregtechceu.gtceu.api.registry.registrate.GTRegistrate;
import com.gregtechceu.gtceu.integration.create.GTCreateDisplaySources;
import com.gregtechceu.gtceu.integration.create.GTCreateDisplayTargets;
import com.gregtechceu.gtceu.utils.GTStringUtils;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.api.behaviour.display.DisplayTarget;
import com.simibubi.create.api.registry.CreateRegistries;
import com.simibubi.create.api.registry.registrate.SimpleBuilder;
import com.simibubi.create.content.redstone.link.IRedstoneLinkable;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.content.redstone.link.controller.LinkedControllerItem;
import com.tterrag.registrate.AbstractRegistrate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.createmod.catnip.data.Couple;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class GTCreateIntegration {
    private GTCreateIntegration() {
    }

    public static void init() {
        GTCreateDisplaySources.init();
        GTCreateDisplayTargets.init();
        PlaceholderHandler.addPlaceholder(new Placeholder("redstone", 1){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                return GTCreateIntegration.processRedstonePlaceholder(ctx, args);
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("displayTarget"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 1);
                CoverBehavior coverBehavior = ctx.cover();
                if (!(coverBehavior instanceof IPlaceholderInfoProviderCover)) {
                    throw new NotSupportedException();
                }
                IPlaceholderInfoProviderCover cover = (IPlaceholderInfoProviderCover)((Object)coverBehavior);
                int i = PlaceholderUtils.toInt(args.get(0));
                PlaceholderUtils.checkRange("line number", 1, 100, i);
                return MultiLineComponent.of(cover.getCreateDisplayTargetBuffer().get(i - 1));
            }
        });
    }

    private static int getRedstoneLinkPower(final PlaceholderContext ctx, final Couple<RedstoneLinkNetworkHandler.Frequency> freq) {
        IRedstoneLinkable linkable = new IRedstoneLinkable(){

            public int getTransmittedStrength() {
                return 0;
            }

            public void setReceivedStrength(int power) {
            }

            public boolean isListening() {
                return true;
            }

            public boolean isAlive() {
                return true;
            }

            public Couple<RedstoneLinkNetworkHandler.Frequency> getNetworkKey() {
                return freq;
            }

            public BlockPos getLocation() {
                return ctx.pos();
            }
        };
        Set network = Create.REDSTONE_LINK_NETWORK_HANDLER.getNetworkOf((LevelAccessor)ctx.level(), linkable);
        int power = 0;
        for (IRedstoneLinkable i : network) {
            if (!i.isAlive() || !RedstoneLinkNetworkHandler.withinRange((IRedstoneLinkable)i, (IRedstoneLinkable)linkable)) continue;
            power = Math.max(power, i.getTransmittedStrength());
        }
        return power;
    }

    private static void setRedstoneLinkPower(PlaceholderContext ctx, Couple<RedstoneLinkNetworkHandler.Frequency> freq, int power) {
        TemporaryRedstoneLinkTransmitter linkable = new TemporaryRedstoneLinkTransmitter(freq, power, ctx.pos(), ctx.level());
        Create.REDSTONE_LINK_NETWORK_HANDLER.addToNetwork((LevelAccessor)ctx.level(), (IRedstoneLinkable)linkable);
    }

    private static MultiLineComponent processRedstonePlaceholder(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
        PlaceholderUtils.checkArgs(args, 1, true);
        if (GTStringUtils.equals(args.get(0), "get")) {
            PlaceholderUtils.checkArgs(args, 2, true);
            if (GTStringUtils.equals(args.get(1), "link")) {
                PlaceholderUtils.checkArgs(args, 4);
                int slot = PlaceholderUtils.toInt(args.get(2));
                int freq_slot = PlaceholderUtils.toInt(args.get(3));
                PlaceholderUtils.checkRange("slot index", 1, 8, slot);
                if (ctx.itemStackHandler() == null) {
                    throw new NotSupportedException();
                }
                ItemStack item = ctx.itemStackHandler().getStackInSlot(slot - 1);
                if (item.m_150930_((Item)AllItems.LINKED_CONTROLLER.get())) {
                    Couple freq = LinkedControllerItem.toFrequency((ItemStack)item, (int)freq_slot);
                    return MultiLineComponent.literal(GTCreateIntegration.getRedstoneLinkPower(ctx, (Couple<RedstoneLinkNetworkHandler.Frequency>)freq));
                }
                throw new MissingItemException("redstone link", slot);
            }
            Direction direction = Direction.m_122402_((String)args.get(1).toString());
            if (direction == null) {
                throw new InvalidArgsException();
            }
            return MultiLineComponent.literal(ctx.level().m_277185_(ctx.pos().m_121945_(direction), direction));
        }
        if (GTStringUtils.equals(args.get(0), "set")) {
            PlaceholderUtils.checkArgs(args, 2, true);
            if (GTStringUtils.equals(args.get(1), "link")) {
                PlaceholderUtils.checkArgs(args, 5);
                int slot = PlaceholderUtils.toInt(args.get(2));
                int freq_slot = PlaceholderUtils.toInt(args.get(3));
                int power = PlaceholderUtils.toInt(args.get(4));
                PlaceholderUtils.checkRange("redstone power", 0, 15, power);
                PlaceholderUtils.checkRange("slot", 1, 8, slot);
                if (ctx.itemStackHandler() == null) {
                    throw new NotSupportedException();
                }
                ItemStack item = ctx.itemStackHandler().getStackInSlot(slot - 1);
                if (item.m_150930_((Item)AllItems.LINKED_CONTROLLER.get())) {
                    Couple freq = LinkedControllerItem.toFrequency((ItemStack)item, (int)freq_slot);
                    GTCreateIntegration.setRedstoneLinkPower(ctx, (Couple<RedstoneLinkNetworkHandler.Frequency>)freq, power);
                    return MultiLineComponent.empty();
                }
                throw new MissingItemException("redstone link", slot);
            }
            int power = PlaceholderUtils.toInt(args.get(1));
            PlaceholderUtils.checkRange("redstone power", 0, 15, power);
            if (ctx.cover() == null) {
                throw new NotSupportedException();
            }
            ctx.cover().setRedstoneSignalOutput(power);
            return MultiLineComponent.empty();
        }
        throw new InvalidArgsException();
    }

    public static <T extends DisplaySource> SimpleBuilder<DisplaySource, T, GTRegistrate> displaySource(GTRegistrate registrate, String name, Supplier<T> supplier) {
        return (SimpleBuilder)registrate.entry(name, callback -> new SimpleBuilder((AbstractRegistrate)registrate, (Object)registrate, name, callback, CreateRegistries.DISPLAY_SOURCE, supplier).byBlock(DisplaySource.BY_BLOCK).byBlockEntity(DisplaySource.BY_BLOCK_ENTITY));
    }

    public static <T extends DisplayTarget> SimpleBuilder<DisplayTarget, T, GTRegistrate> displayTarget(GTRegistrate registrate, String name, Supplier<T> supplier) {
        return (SimpleBuilder)registrate.entry(name, callback -> new SimpleBuilder((AbstractRegistrate)registrate, (Object)registrate, name, callback, CreateRegistries.DISPLAY_TARGET, supplier).byBlock(DisplayTarget.BY_BLOCK).byBlockEntity(DisplayTarget.BY_BLOCK_ENTITY));
    }

    public static class TemporaryRedstoneLinkTransmitter
    implements IRedstoneLinkable {
        private static final ArrayList<TemporaryRedstoneLinkTransmitter> transmitters = new ArrayList();
        private final int power;
        private final Couple<RedstoneLinkNetworkHandler.Frequency> freq;
        private final BlockPos pos;
        private final Level level;
        private boolean alive;

        public TemporaryRedstoneLinkTransmitter(Couple<RedstoneLinkNetworkHandler.Frequency> frequency, int power, BlockPos pos, Level level) {
            this.power = power;
            this.freq = frequency;
            this.alive = true;
            this.pos = pos;
            this.level = level;
            transmitters.add(this);
        }

        public int getTransmittedStrength() {
            return this.power;
        }

        public void setReceivedStrength(int power) {
        }

        public boolean isListening() {
            return false;
        }

        public boolean isAlive() {
            return this.alive;
        }

        public Couple<RedstoneLinkNetworkHandler.Frequency> getNetworkKey() {
            return this.freq;
        }

        public BlockPos getLocation() {
            return this.pos;
        }

        public void destroy() {
            this.alive = false;
            Create.REDSTONE_LINK_NETWORK_HANDLER.updateNetworkOf((LevelAccessor)this.level, (IRedstoneLinkable)this);
        }

        public static void destroyAll() {
            while (!transmitters.isEmpty()) {
                transmitters.get(transmitters.size() - 1).destroy();
                transmitters.remove(transmitters.size() - 1);
            }
        }
    }
}

