/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.events;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.data.recipe.CraftingComponent;
import com.gregtechceu.gtceu.utils.GTUtil;
import dev.latvian.mods.kubejs.event.StartupEventJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.Map;
import lombok.Generated;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CraftingComponentsEventJS
extends StartupEventJS {
    private ComponentWrapper create(String id, Object fallback) {
        return ComponentWrapper.of(id, fallback);
    }

    public ComponentWrapper createItem(String id, ItemStack stack) {
        return this.create(id, stack);
    }

    public ComponentWrapper createTag(String id, ResourceLocation tag) {
        return this.create(id, TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tag));
    }

    public ComponentWrapper createMaterialEntry(String id, MaterialEntry entry) {
        return this.create(id, entry);
    }

    private void set(CraftingComponent craftingComponent, int tier, Object value) {
        craftingComponent.add(tier, value);
    }

    public void setItem(CraftingComponent craftingComponent, int tier, ItemStack item) {
        this.set(craftingComponent, tier, item);
    }

    public void setTag(CraftingComponent craftingComponent, int tier, ResourceLocation tag) {
        this.set(craftingComponent, tier, TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tag));
    }

    public void setMaterialEntry(CraftingComponent craftingComponent, int tier, MaterialEntry matEntry) {
        this.set(craftingComponent, tier, matEntry);
    }

    public void set(CraftingComponent craftingComponent, Map<Object, Object> map) {
        for (Map.Entry<Object, Object> val : map.entrySet()) {
            int tier = CraftingComponentsEventJS.parseTier(val.getKey());
            if (tier == -1) {
                return;
            }
            Object obj = CraftingComponentsEventJS.parseObject(val.getValue());
            if (obj == null) {
                return;
            }
            craftingComponent.add(tier, obj);
        }
    }

    public void setItems(CraftingComponent craftingComponent, Map<Object, Object> map) {
        for (Map.Entry<Object, Object> val : map.entrySet()) {
            int tier = CraftingComponentsEventJS.parseTier(val.getKey());
            if (tier == -1) {
                return;
            }
            ItemStack stack = CraftingComponentsEventJS.parseItemStack(val.getValue());
            if (stack == null) {
                ConsoleJS.STARTUP.errorf("Invalid ItemStack %s passed to setItems!", new Object[]{val.getValue()});
                return;
            }
            craftingComponent.add(tier, stack);
        }
    }

    public void setTags(CraftingComponent craftingComponent, Map<Object, Object> map) {
        for (Map.Entry<Object, Object> val : map.entrySet()) {
            int tier = CraftingComponentsEventJS.parseTier(val.getKey());
            if (tier == -1) {
                return;
            }
            TagKey<Item> tagKey = CraftingComponentsEventJS.parseTag(val.getValue());
            if (tagKey == null) {
                ConsoleJS.STARTUP.error((Object)"Invalid TagKey passed to setTags");
                return;
            }
            craftingComponent.add(tier, tagKey);
        }
    }

    public void setMaterialEntries(CraftingComponent craftingComponent, Map<Object, Object> map) {
        for (Map.Entry<Object, Object> val : map.entrySet()) {
            int tier = CraftingComponentsEventJS.parseTier(val.getKey());
            if (tier == -1) {
                return;
            }
            MaterialEntry entry = MaterialEntry.of(val.getValue());
            if (entry == null) {
                ConsoleJS.STARTUP.error((Object)"Invalid MaterialEntry passed to setMaterialEntries");
                return;
            }
            craftingComponent.add(tier, entry);
        }
    }

    public void setFallbackItem(CraftingComponent craftingComponent, ItemStack stack) {
        craftingComponent.setFallback(stack);
    }

    public void setFallbackTag(CraftingComponent craftingComponent, ResourceLocation tag) {
        craftingComponent.setFallback(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tag));
    }

    public void setFallbackMaterialEntry(CraftingComponent craftingComponent, MaterialEntry materialEntry) {
        craftingComponent.setFallback(materialEntry);
    }

    public void removeTier(CraftingComponent craftingComponent, int tier) {
        craftingComponent.remove(tier);
    }

    public void removeTiers(CraftingComponent craftingComponent, int ... tiers) {
        for (int t : tiers) {
            craftingComponent.remove(t);
        }
    }

    private static ItemStack parseItemStack(Object o) {
        ItemStack stack = ItemStackJS.of((Object)o);
        if (stack == null || stack.m_41619_()) {
            return null;
        }
        return stack;
    }

    private static TagKey<Item> parseTag(Object o) {
        TagKey key;
        if (o instanceof TagKey && (key = (TagKey)o).m_207645_(Registries.f_256913_)) {
            return key;
        }
        ResourceLocation rl = UtilsJS.getMCID(null, (Object)o);
        if (rl != null) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)rl);
        }
        return null;
    }

    private static Object parseObject(Object o) {
        Object obj = CraftingComponentsEventJS.parseItemStack(o);
        if (obj == null) {
            obj = CraftingComponentsEventJS.parseTag(o);
        }
        if (obj == null) {
            obj = MaterialEntry.of(o);
        }
        if (obj == null) {
            ConsoleJS.STARTUP.errorf("%s is not of type ItemStack, MaterialEntry or TagKey<Item>", new Object[]{o});
        }
        return obj;
    }

    private static int parseTier(Object o) {
        Number number;
        int tier;
        int ret = -1;
        if (o instanceof CharSequence) {
            CharSequence cs = (CharSequence)o;
            String str = cs.toString();
            try {
                int tier2 = Integer.parseUnsignedInt(str);
                if (tier2 >= 0 && tier2 < GTValues.TIER_COUNT) {
                    ret = tier2;
                }
            }
            catch (NumberFormatException ignored) {
                ret = GTUtil.getTierByName(str);
            }
        } else if (o instanceof Number && (tier = (number = (Number)o).intValue()) >= 0 && tier < GTValues.TIER_COUNT) {
            ret = tier;
        }
        if (ret == -1) {
            ConsoleJS.STARTUP.errorf("%s is not a valid tier!", new Object[]{o});
        }
        return ret;
    }

    @Generated
    public CraftingComponentsEventJS() {
    }

    public static class ComponentWrapper
    extends CraftingComponent {
        private final String id;

        private ComponentWrapper(String id, Object fallback) {
            super(fallback);
            this.id = id;
        }

        public static ComponentWrapper of(@NotNull String id, @NotNull Object fallback) {
            if (ALL_COMPONENTS.containsKey(id)) {
                throw new IllegalArgumentException("Duplicate crafting component: " + id);
            }
            ComponentWrapper ret = new ComponentWrapper(id, fallback);
            ALL_COMPONENTS.put(id, ret);
            return ret;
        }

        @Override
        @NotNull
        public ComponentWrapper add(int tier, @NotNull Object value) {
            try {
                super.add(tier, value);
            }
            catch (RuntimeException e) {
                ConsoleJS.STARTUP.error("Problem with component " + this.id, (Throwable)e);
            }
            return this;
        }

        public ComponentWrapper addItem(int tier, ItemStack stack) {
            return this.add(tier, stack);
        }

        public ComponentWrapper addTag(int tier, ResourceLocation tag) {
            return this.add(tier, TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tag));
        }

        public ComponentWrapper addMaterialEntry(int tier, MaterialEntry entry) {
            return this.add(tier, entry);
        }

        public ComponentWrapper addMaterialEntry(int tier, TagPrefix prefix, Material mat) {
            return this.add(tier, new MaterialEntry(prefix, mat));
        }
    }
}

