/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.recipe.components;

import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import dev.latvian.mods.kubejs.core.IngredientKJS;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.OutputReplacement;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.ReplacementMatch;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Wrapper;
import java.util.Map;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class ExtendedOutputItem
extends OutputItem
implements OutputReplacement {
    public SizedIngredient ingredient;

    public ExtendedOutputItem(Ingredient ingredient, int count, IntProvider rolls) {
        super(((IngredientKJS)ingredient).kjs$getFirst().m_255036_(count), Double.NaN, rolls);
        this.ingredient = SizedIngredient.create(ingredient, count);
    }

    public ExtendedOutputItem(ItemStack stack, IntProvider rolls) {
        super(stack, Double.NaN, rolls);
        this.ingredient = SizedIngredient.create(stack);
    }

    public static ExtendedOutputItem of(Ingredient ingredient, int count) {
        if (ingredient instanceof SizedIngredient) {
            SizedIngredient sized = (SizedIngredient)ingredient;
            ingredient = sized.getInner();
            if (count == 1) {
                return ExtendedOutputItem.of(ingredient, sized.getAmount());
            }
        }
        IntProvider rolls = null;
        if (ingredient instanceof IntProviderIngredient) {
            IntProviderIngredient intProvider = (IntProviderIngredient)ingredient;
            rolls = intProvider.getCountProvider();
            ingredient = intProvider.getInner();
        }
        return new ExtendedOutputItem(ingredient, count, rolls);
    }

    public static ExtendedOutputItem of(Object o) {
        return ExtendedOutputItem.of(o, null);
    }

    public static ExtendedOutputItem of(Object o, @Nullable RecipeJS recipe) {
        ConstantInt c;
        IntProvider intProvider;
        if (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            o = w.unwrap();
        }
        if (o instanceof ExtendedOutputItem) {
            ExtendedOutputItem extendedOutput = (ExtendedOutputItem)((Object)o);
            return extendedOutput;
        }
        if (o instanceof InputItem) {
            InputItem input = (InputItem)o;
            return ExtendedOutputItem.of(input.ingredient, input.count);
        }
        if (o instanceof IntProviderIngredient) {
            IntProviderIngredient intProvider2 = (IntProviderIngredient)((Object)o);
            return new ExtendedOutputItem(intProvider2.getInner(), 1, intProvider2.getCountProvider());
        }
        OutputItem item = recipe != null ? recipe.readOutputItem(o) : OutputItem.of((Object)o);
        IntProvider rolls = item.rolls;
        Map map = MapJS.of((Object)o);
        if (map != null && map.containsKey("count_provider") && (!((intProvider = UtilsJS.intProviderOf(map.get("count_provider"))) instanceof ConstantInt) || (c = (ConstantInt)intProvider).m_146499_() != 0)) {
            rolls = intProvider;
        }
        return new ExtendedOutputItem(item.item, rolls);
    }

    public static ExtendedOutputItem fromOutputItem(OutputItem item) {
        if (item instanceof ExtendedOutputItem) {
            ExtendedOutputItem extended = (ExtendedOutputItem)item;
            return extended;
        }
        return new ExtendedOutputItem(item.item, item.rolls);
    }

    public OutputItem withCount(int count) {
        return new ExtendedOutputItem(this.ingredient.getInner(), count, this.rolls);
    }

    public OutputItem withRolls(IntProvider rolls) {
        Ingredient ingredient = this.ingredient.getInner();
        if (ingredient instanceof IntProviderIngredient) {
            IntProviderIngredient intProvider = (IntProviderIngredient)ingredient;
            ingredient = intProvider.getInner();
        }
        return new ExtendedOutputItem(ingredient, 1, rolls);
    }

    public int getCount() {
        return this.ingredient.getAmount();
    }

    public Object replaceOutput(RecipeJS recipe, ReplacementMatch match, OutputReplacement original) {
        if (original instanceof OutputItem) {
            OutputItem o = (OutputItem)original;
            return new ExtendedOutputItem(this.ingredient.getInner(), o.getCount(), o.rolls);
        }
        return new ExtendedOutputItem(this.ingredient.getInner(), this.getCount(), this.rolls);
    }

    public InputItem ignoreNBT() {
        ConsoleJS console = ConsoleJS.getCurrent((ConsoleJS)ConsoleJS.SERVER);
        console.warn((Object)"You don't need to call .ignoreNBT() anymore, all item ingredients ignore NBT by default!");
        return InputItem.of((Ingredient)this.ingredient.getInner(), (int)this.ingredient.getAmount());
    }
}

