/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map.layer.builtin;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.client.ClientProxy;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.map.GenericMapRenderer;
import com.gregtechceu.gtceu.integration.map.layer.MapRenderLayer;
import com.gregtechceu.gtceu.integration.xei.widgets.GTOreVeinWidget;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class OreRenderLayer
extends MapRenderLayer {
    public OreRenderLayer(String key, GenericMapRenderer renderer) {
        super(key, renderer);
    }

    public static String getId(GeneratedVeinMetadata vein) {
        BlockPos center = vein.center();
        return "ore_veins@[" + center.m_123341_() + "," + center.m_123342_() + "," + center.m_123343_() + "]";
    }

    public static MutableComponent getName(GeneratedVeinMetadata vein) {
        if (vein == null || vein.definition() == null || ClientProxy.CLIENT_ORE_VEINS.inverse().get((Object)vein.definition()) == null) {
            return Component.m_237115_((String)"gtceu.minimap.ore_vein.depleted");
        }
        return Component.m_237115_((String)("gtceu.jei.ore_vein." + GTOreVeinWidget.getOreName(vein.definition())));
    }

    @NotNull
    public static Material getMaterial(@NotNull GeneratedVeinMetadata vein) {
        Material firstMaterial = null;
        if (!vein.definition().indicatorGenerators().isEmpty()) {
            Either<BlockState, Material> blockOrMaterial = vein.definition().indicatorGenerators().get(0).block();
            Material material = firstMaterial = blockOrMaterial == null ? null : (Material)blockOrMaterial.map(state -> {
                MaterialStack matStack = ChemicalHelper.getMaterialStack((ItemLike)state.m_60734_());
                return matStack.isEmpty() ? GTMaterials.NULL : matStack.material();
            }, Function.identity());
        }
        if (firstMaterial == null) {
            firstMaterial = vein.definition().veinGenerator().getAllMaterials().get(0);
        }
        return firstMaterial;
    }

    public static List<Component> getTooltip(String name, GeneratedVeinMetadata vein) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        MutableComponent title = Component.m_237113_((String)name);
        if (vein.depleted()) {
            title.m_130946_(" (").m_7220_((Component)Component.m_237115_((String)"gtceu.minimap.ore_vein.depleted")).m_130946_(")");
        }
        tooltip.add((Component)title);
        for (VeinGenerator.VeinEntry filler : vein.definition().veinGenerator().getAllEntries()) {
            filler.vein().ifLeft(state -> tooltip.add((Component)Component.m_237113_((String)ConfigHolder.INSTANCE.compat.minimap.oreNamePrefix).m_7220_((Component)state.m_60734_().m_49954_()))).ifRight(material -> tooltip.add((Component)Component.m_237113_((String)ConfigHolder.INSTANCE.compat.minimap.oreNamePrefix).m_7220_((Component)TagPrefix.ore.getLocalizedName((Material)material))));
        }
        return tooltip;
    }
}

