/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.utils.GTMath;
import java.math.BigInteger;

public class RedstoneUtil {
    public static int computeRedstoneBetweenValues(float value, float maxValue, float minValue, boolean isInverted) {
        if (value >= maxValue) {
            return isInverted ? 0 : 15;
        }
        if (value <= minValue) {
            return isInverted ? 15 : 0;
        }
        float ratio = isInverted ? 15.0f * (maxValue - value) / (maxValue - minValue) : 15.0f * (value - minValue) / (maxValue - minValue);
        return Math.round(ratio);
    }

    public static int computeRedstoneBetweenValues(BigInteger value, BigInteger maxValue, BigInteger minValue, boolean isInverted) {
        if (value.compareTo(maxValue) >= 0) {
            return isInverted ? 0 : 15;
        }
        if (value.compareTo(maxValue) <= 0) {
            return isInverted ? 15 : 0;
        }
        float ratio = isInverted ? 15.0f * GTMath.ratio(maxValue.subtract(value), maxValue.subtract(minValue)) : 15.0f * GTMath.ratio(value.subtract(minValue), maxValue.subtract(minValue));
        return Math.round(ratio);
    }

    public static int computeLatchedRedstoneBetweenValues(float value, float maxValue, float minValue, boolean isInverted, int output) {
        if (value >= maxValue) {
            output = isInverted ? 15 : 0;
        } else if (value <= minValue) {
            output = isInverted ? 0 : 15;
        }
        return output;
    }

    public static int computeLatchedRedstoneBetweenValues(BigInteger value, BigInteger maxValue, BigInteger minValue, boolean isInverted, int output) {
        if (value.compareTo(maxValue) >= 0) {
            output = isInverted ? 15 : 0;
        } else if (value.compareTo(minValue) <= 0) {
            output = isInverted ? 0 : 15;
        }
        return output;
    }

    public static int computeRedstoneValue(long current, long max, boolean isInverted) throws ArithmeticException {
        int output = (int)(14.0f * (float)current / (float)max) + (current > 0L ? 1 : 0);
        return isInverted ? 15 - output : output;
    }

    public static int computeRedstoneValue(BigInteger current, BigInteger max, boolean isInverted) throws ArithmeticException {
        boolean isNotEmpty = current.compareTo(BigInteger.ZERO) > 0;
        int output = (int)(14.0f * GTMath.ratio(current, max)) + (isNotEmpty ? 1 : 0);
        return isInverted ? 15 - output : output;
    }
}

