/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils.memoization;

import com.gregtechceu.gtceu.utils.memoization.ConcurrentWeakIdentityHashMap;
import com.gregtechceu.gtceu.utils.memoization.MemoizedBlockSupplier;
import com.gregtechceu.gtceu.utils.memoization.MemoizedSupplier;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;

public class GTMemoizer {
    public static <T> MemoizedSupplier<T> memoize(Supplier<T> delegate) {
        return new MemoizedSupplier<T>(delegate);
    }

    public static <T extends Block> MemoizedBlockSupplier<T> memoizeBlockSupplier(Supplier<T> delegate) {
        return new MemoizedBlockSupplier<T>(delegate);
    }

    public static <T, R> Function<T, R> memoizeFunctionWeakIdent(final Function<T, R> memoFunction) {
        return new Function<T, R>(){
            private final Map<T, R> cache = new ConcurrentWeakIdentityHashMap();

            @Override
            public R apply(T key) {
                return this.cache.computeIfAbsent(key, memoFunction);
            }

            public String toString() {
                return "memoizeFunctionWeakIdent/1[function=" + String.valueOf(memoFunction) + ", size=" + this.cache.size() + "]";
            }
        };
    }
}

