/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.feature;

import dev.worldgen.lithostitched.LithostitchedCommon;
import dev.worldgen.lithostitched.worldgen.feature.config.DungeonConfig;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.StructurePiece;

public class DungeonFeature
extends Feature<DungeonConfig> {
    public static final DungeonFeature FEATURE = new DungeonFeature();

    public DungeonFeature() {
        super(DungeonConfig.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<DungeonConfig> context) {
        BlockPos currentPos;
        int z;
        int y;
        int x;
        BlockPos startPos = context.m_159777_();
        RandomSource random = context.m_225041_();
        WorldGenLevel world = context.m_159774_();
        DungeonConfig config = (DungeonConfig)context.m_159778_();
        Predicate<BlockState> predicate = state -> !state.m_204336_(config.dungeonInvalidBlocks());
        int xRadius = config.radius().m_214085_(random);
        int minX = -xRadius - 1;
        int maxX = xRadius + 1;
        int zRadius = config.radius().m_214085_(random);
        int minZ = -zRadius - 1;
        int maxZ = zRadius + 1;
        int openings = 0;
        for (x = minX; x <= maxX; ++x) {
            for (y = -1; y <= 4; ++y) {
                for (z = minZ; z <= maxZ; ++z) {
                    currentPos = startPos.m_7918_(x, y, z);
                    boolean bl = world.m_8055_(currentPos).m_280296_();
                    if (y == -1 && !bl) {
                        return false;
                    }
                    if (y == 4 && !bl) {
                        return false;
                    }
                    if (x != minX && x != maxX && z != minZ && z != maxZ || y != 0 || !world.m_46859_(currentPos) || !world.m_46859_(currentPos.m_7494_())) continue;
                    ++openings;
                }
            }
        }
        if (openings >= config.minOpenings() && openings <= config.maxOpenings()) {
            for (x = minX; x <= maxX; ++x) {
                for (y = 3; y >= -1; --y) {
                    for (z = minZ; z <= maxZ; ++z) {
                        currentPos = startPos.m_7918_(x, y, z);
                        BlockState currentState = world.m_8055_(currentPos);
                        if (x != minX && y != -1 && z != minZ && x != maxX && y != 4 && z != maxZ) {
                            if (currentState.m_60713_(Blocks.f_50087_) || currentState.m_60713_(Blocks.f_50085_)) continue;
                            this.m_159742_(world, currentPos, Blocks.f_50627_.m_49966_(), predicate);
                            continue;
                        }
                        if (currentPos.m_123342_() >= world.m_141937_() && !world.m_8055_(currentPos.m_7495_()).m_280296_()) {
                            world.m_7731_(currentPos, Blocks.f_50627_.m_49966_(), 2);
                            continue;
                        }
                        if (!currentState.m_280296_() || currentState.m_60713_(Blocks.f_50087_)) continue;
                        this.m_159742_(world, currentPos, y == -1 ? config.floorProvider().m_213972_(random, currentPos) : config.wallProvider().m_213972_(random, currentPos), predicate);
                    }
                }
            }
            block6: for (x = 0; x < config.maxChests(); ++x) {
                for (y = 0; y < 3; ++y) {
                    int w;
                    int v;
                    z = startPos.m_123341_() + random.m_188503_(xRadius * 2 + 1) - xRadius;
                    BlockPos chestPos = new BlockPos(z, v = startPos.m_123342_(), w = startPos.m_123343_() + random.m_188503_(zRadius * 2 + 1) - zRadius);
                    if (!world.m_46859_(chestPos)) continue;
                    int solidFaces = 0;
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        if (!world.m_8055_(chestPos.m_121945_(direction)).m_280296_()) continue;
                        ++solidFaces;
                    }
                    if (solidFaces != true) continue;
                    this.m_159742_(world, chestPos, StructurePiece.m_73407_((BlockGetter)world, (BlockPos)chestPos, (BlockState)Blocks.f_50087_.m_49966_()), predicate);
                    Optional chestEntity = world.m_141902_(chestPos, BlockEntityType.f_58918_);
                    chestEntity.ifPresent(chestBlockEntity -> chestBlockEntity.m_59626_(config.lootTable(), random.m_188505_()));
                    continue block6;
                }
            }
            this.m_159742_(world, startPos, Blocks.f_50085_.m_49966_(), predicate);
            BlockEntity blockEntity = world.m_7702_(startPos);
            if (blockEntity instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity;
                spawner.m_252803_(config.spawnerMobs().m_216820_(random).orElse(EntityType.f_20510_), random);
            } else {
                LithostitchedCommon.LOGGER.error(String.format("Failed to get spawner block entity for dungeon at block position (%s)", startPos));
            }
            return true;
        }
        return false;
    }
}

