/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.inventory;

import com.buuz135.functionalstorage.inventory.HandlerSlotSelector;
import com.buuz135.functionalstorage.util.ConnectedDrawers;
import java.util.ArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class ControllerInventoryHandler
implements IItemHandler {
    HandlerSlotSelector[] selectors;
    private int slots = 0;

    public ControllerInventoryHandler() {
        this.invalidateSlots();
    }

    public int getSlots() {
        return this.slots;
    }

    public void invalidateSlots() {
        ArrayList<HandlerSlotSelector> selectors = new ArrayList<HandlerSlotSelector>();
        this.slots = 0;
        for (IItemHandler handler : this.getDrawers().getItemHandlers()) {
            if (handler instanceof ControllerInventoryHandler) continue;
            int handlerSlots = handler.getSlots();
            for (int i = 0; i < handlerSlots; ++i) {
                selectors.add(new HandlerSlotSelector(handler, i));
            }
            this.slots += handlerSlots;
        }
        this.selectors = selectors.toArray(new HandlerSlotSelector[selectors.size()]);
    }

    private HandlerSlotSelector selectorForSlot(int slot) {
        return slot >= 0 && slot < this.selectors.length ? this.selectors[slot] : null;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        HandlerSlotSelector selector = this.selectorForSlot(slot);
        return null != selector ? selector.getStackInSlot() : ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        HandlerSlotSelector selector = this.selectorForSlot(slot);
        return null != selector ? selector.insertItem(stack, simulate) : ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        HandlerSlotSelector selector = this.selectorForSlot(slot);
        return null != selector ? selector.extractItem(amount, simulate) : ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        HandlerSlotSelector selector = this.selectorForSlot(slot);
        return null != selector ? selector.getSlotLimit() : 0;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        HandlerSlotSelector selector = this.selectorForSlot(slot);
        return null != selector ? selector.isItemValid(stack) : false;
    }

    public abstract ConnectedDrawers getDrawers();
}

