/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.conduit.type.energy;

import com.enderio.api.conduit.ConduitData;
import com.enderio.api.conduit.ConduitType;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyConduitData
implements ConduitData<EnergyConduitData> {
    private final Map<Direction, EnergySidedData> energySidedData = new EnumMap<Direction, EnergySidedData>(Direction.class);
    private int capacity = 500;
    private int stored = 0;
    private LazyOptional<IEnergyStorage> selfCap = LazyOptional.of(() -> new ConduitEnergyStorage(this));

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        for (Direction direction : Direction.values()) {
            @Nullable EnergySidedData sidedData = this.energySidedData.get(direction);
            if (sidedData == null) continue;
            tag.m_128365_(direction.name(), (Tag)sidedData.toNbt());
        }
        tag.m_128405_("MaxEnergyStored", this.capacity);
        tag.m_128405_("EnergyStored", this.stored);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.energySidedData.clear();
        for (Direction direction : Direction.values()) {
            if (!nbt.m_128441_(direction.name())) continue;
            this.energySidedData.put(direction, EnergySidedData.fromNbt(nbt.m_128469_(direction.name())));
        }
        if (nbt.m_128441_("MaxEnergyStored")) {
            this.capacity = Math.max(nbt.m_128451_("MaxEnergyStored"), 500);
        }
        if (nbt.m_128441_("EnergyStored")) {
            this.stored = nbt.m_128451_("EnergyStored");
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public int getStored() {
        return this.stored;
    }

    public void setStored(int stored) {
        this.stored = stored;
    }

    @Override
    public void onRemoved(ConduitType<?> type, Level level, BlockPos pos) {
        this.selfCap.invalidate();
    }

    public EnergySidedData compute(Direction direction) {
        return this.energySidedData.computeIfAbsent(direction, dir -> new EnergySidedData());
    }

    LazyOptional<IEnergyStorage> getSelfCap() {
        if (!this.selfCap.isPresent()) {
            this.selfCap = LazyOptional.of(() -> new ConduitEnergyStorage(this));
        }
        return this.selfCap;
    }

    public static class EnergySidedData {
        public int rotatingIndex = 0;
        private static final String KEY_ROTATING_INDEX = "RotatingIndex";

        private CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_(KEY_ROTATING_INDEX, this.rotatingIndex);
            return nbt;
        }

        private static EnergySidedData fromNbt(CompoundTag nbt) {
            EnergySidedData sidedData = new EnergySidedData();
            if (nbt.m_128425_(KEY_ROTATING_INDEX, 3)) {
                sidedData.rotatingIndex = nbt.m_128451_(KEY_ROTATING_INDEX);
            }
            return sidedData;
        }
    }

    private record ConduitEnergyStorage(EnergyConduitData data) implements IEnergyStorage
    {
        public int receiveEnergy(int maxReceive, boolean simulate) {
            int receivable = Math.min(this.data.getCapacity() - this.data().getStored(), maxReceive);
            if (!simulate) {
                this.data.setStored(this.data.getStored() + receivable);
            }
            return receivable;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int extractable = Math.min(this.data().getStored(), maxExtract);
            if (!simulate) {
                this.data.setStored(this.data.getStored() - extractable);
            }
            return extractable;
        }

        public int getEnergyStored() {
            return this.data.getStored();
        }

        public int getMaxEnergyStored() {
            return this.data().getCapacity();
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

