/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.spawner;

import com.mojang.serialization.DynamicOps;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.SpawnData;

public class MobSpawnerData {
    public final int spawnDelay;
    public final SimpleWeightedRandomList<SpawnData> spawnPotentials;
    public final SpawnData nextSpawnData;
    public final int minSpawnDelay;
    public final int maxSpawnDelay;
    public final int spawnCount;
    public final int maxNearbyEntities;
    public final int requiredPlayerRange;
    public final int spawnRange;

    public MobSpawnerData(Builder builder) {
        this.spawnDelay = builder.spawnDelay;
        this.spawnPotentials = builder.spawnPotentials;
        this.nextSpawnData = builder.nextSpawnData;
        this.minSpawnDelay = builder.minSpawnDelay;
        this.maxSpawnDelay = builder.maxSpawnDelay;
        this.spawnCount = builder.spawnCount;
        this.maxNearbyEntities = builder.maxNearbyEntities;
        this.requiredPlayerRange = builder.requiredPlayerRange;
        this.spawnRange = builder.spawnRange;
    }

    public CompoundTag save() {
        return this.save(new CompoundTag());
    }

    public CompoundTag save(CompoundTag compoundTag) {
        compoundTag.m_128376_("Delay", (short)this.spawnDelay);
        compoundTag.m_128376_("MinSpawnDelay", (short)this.minSpawnDelay);
        compoundTag.m_128376_("MaxSpawnDelay", (short)this.maxSpawnDelay);
        compoundTag.m_128376_("SpawnCount", (short)this.spawnCount);
        compoundTag.m_128376_("MaxNearbyEntities", (short)this.maxNearbyEntities);
        compoundTag.m_128376_("RequiredPlayerRange", (short)this.requiredPlayerRange);
        compoundTag.m_128376_("SpawnRange", (short)this.spawnRange);
        compoundTag.m_128365_("SpawnData", (Tag)SpawnData.f_186559_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.nextSpawnData).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData")));
        compoundTag.m_128365_("SpawnPotentials", (Tag)SpawnData.f_186560_.encodeStart((DynamicOps)NbtOps.f_128958_, this.spawnPotentials).result().orElseThrow());
        return compoundTag;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int spawnDelay = 20;
        private SimpleWeightedRandomList<SpawnData> spawnPotentials = SimpleWeightedRandomList.m_185864_();
        private SpawnData nextSpawnData = new SpawnData();
        private int minSpawnDelay = 200;
        private int maxSpawnDelay = 800;
        private int spawnCount = 4;
        private int maxNearbyEntities = 6;
        private int requiredPlayerRange = 16;
        private int spawnRange = 4;

        public MobSpawnerData build() {
            return new MobSpawnerData(this);
        }

        public Builder spawnDelay(int spawnDelay) {
            this.spawnDelay = spawnDelay;
            return this;
        }

        public Builder spawnPotentials(SimpleWeightedRandomList<SpawnData> spawnPotentials) {
            this.spawnPotentials = spawnPotentials;
            return this;
        }

        public Builder setEntityType(EntityType<?> entityType) {
            this.nextSpawnData.m_186567_().m_128359_("id", BuiltInRegistries.f_256780_.m_7981_(entityType).toString());
            return this;
        }

        public Builder minSpawnDelay(int minSpawnDelay) {
            this.minSpawnDelay = minSpawnDelay;
            return this;
        }

        public Builder maxSpawnDelay(int maxSpawnDelay) {
            this.maxSpawnDelay = maxSpawnDelay;
            return this;
        }

        public Builder spawnCount(int spawnCount) {
            this.spawnCount = spawnCount;
            return this;
        }

        public Builder maxNearbyEntities(int maxNearbyEntities) {
            this.maxNearbyEntities = maxNearbyEntities;
            return this;
        }

        public Builder requiredPlayerRange(int requiredPlayerRange) {
            this.requiredPlayerRange = requiredPlayerRange;
            return this;
        }

        public Builder spawnRange(int spawnRange) {
            this.spawnRange = spawnRange;
            return this;
        }
    }
}

