/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.loader;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.api.registry.ICropRegistry;
import com.blakebr0.mysticalcustomization.MysticalCustomization;
import com.blakebr0.mysticalcustomization.create.CropCreator;
import com.blakebr0.mysticalcustomization.modify.CropModifier;
import com.blakebr0.mysticalcustomization.util.ErrorManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;

public final class CropLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String CATEGORY = "Crops";
    public static final Map<Crop, ResourceLocation> CRUX_MAP = new HashMap<Crop, ResourceLocation>();
    public static final Map<Crop, ResourceLocation> CROP_TIER_MAP = new HashMap<Crop, ResourceLocation>();
    public static final Map<Crop, ResourceLocation> CROP_TYPE_MAP = new HashMap<Crop, ResourceLocation>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRegisterCrops(ICropRegistry registry) {
        File[] files;
        File dir = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/crops/").toFile();
        if (!dir.exists() && dir.mkdirs()) {
            MysticalCustomization.LOGGER.info("Created /config/mysticalcustomization/crops/ directory");
        }
        if ((files = dir.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"))) == null) {
            return;
        }
        for (File file : files) {
            InputStreamReader reader = null;
            ResourceLocation id = null;
            Crop crop = null;
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                String name = file.getName().replace(".json", "");
                id = new ResourceLocation("mysticalcustomization", name);
                try {
                    crop = CropCreator.create(id, json);
                }
                catch (JsonSyntaxException e) {
                    ErrorManager.INSTANCE.addError(CATEGORY, e.getMessage());
                }
                reader.close();
            }
            catch (Exception e) {
                try {
                    ErrorManager.INSTANCE.addFatalError(CATEGORY, "An error occurred creating crop with id %s.".formatted(id), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
            IOUtils.closeQuietly((Reader)reader);
            if (crop == null) continue;
            registry.register(crop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPostRegisterCrops(ICropRegistry registry) {
        block16: {
            File file;
            block17: {
                CROP_TIER_MAP.forEach((crop, id) -> {
                    CropTier tier = registry.getTierById(id);
                    if (tier == null) {
                        ErrorManager.INSTANCE.addError(CATEGORY, "Creating %s: %s".formatted(crop.getId(), "Invalid crop tier: %s".formatted(id)));
                    } else {
                        crop.setTier(tier);
                    }
                });
                CROP_TYPE_MAP.forEach((crop, id) -> {
                    CropType type = registry.getTypeById(id);
                    if (type == null) {
                        ErrorManager.INSTANCE.addError(CATEGORY, "Creating %s: %s".formatted(crop.getId(), "Invalid crop type: %s".formatted(id)));
                    } else {
                        crop.setType(type);
                    }
                });
                File dir = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/").toFile();
                if (!dir.exists() && dir.mkdirs()) {
                    MysticalCustomization.LOGGER.info("Created /config/mysticalcustomization/ directory");
                }
                if (!(file = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/configure-crops.json").toFile()).exists() || !file.isFile()) break block17;
                FileReader reader = null;
                try {
                    reader = new FileReader(file);
                    JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    for (Map.Entry entry : json.entrySet()) {
                        String id2 = (String)entry.getKey();
                        JsonObject changes = ((JsonElement)entry.getValue()).getAsJsonObject();
                        Crop crop2 = registry.getCropById(ResourceLocation.m_135820_((String)id2));
                        try {
                            if (crop2 == null) {
                                throw new JsonSyntaxException("Unknown crop id: %s".formatted(id2));
                            }
                            CropModifier.modify(crop2, changes);
                        }
                        catch (JsonSyntaxException e) {
                            ErrorManager.INSTANCE.addError(CATEGORY, "Modifying %s: %s".formatted(id2, e.getMessage()));
                        }
                    }
                    reader.close();
                }
                catch (Exception e) {
                    try {
                        ErrorManager.INSTANCE.addFatalError(CATEGORY, "An error occurred while reading configure-crops.json.", e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)reader);
                    break block16;
                }
                IOUtils.closeQuietly((Reader)reader);
                break block16;
            }
            try (FileWriter writer = new FileWriter(file);){
                JsonObject object = new JsonObject();
                GSON.toJson((JsonElement)object, (Appendable)writer);
            }
            catch (IOException e) {
                MysticalCustomization.LOGGER.error("An error occurred while creating configure-crops.json", (Throwable)e);
            }
        }
    }

    public static void onCommonSetup() {
        CRUX_MAP.forEach((crop, crux) -> {
            if (crux == null) {
                crop.setCruxBlock(null);
            } else {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(crux);
                if (block != Blocks.f_50016_) {
                    crop.setCruxBlock(() -> block);
                } else {
                    ErrorManager.INSTANCE.addError(CATEGORY, "Modifying %s: %s".formatted(crop.getId(), "Invalid crux block: %s".formatted(crux)));
                }
            }
        });
    }
}

