/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.materials;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.gson.ResourceLocationSerializer;
import slimeknights.mantle.data.loadable.common.GsonLoadable;
import slimeknights.mantle.data.loadable.field.LegacyField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.client.data.spritetransformer.IColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;

public class MaterialGeneratorInfo {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(MaterialStatsId.class, (Object)new ResourceLocationSerializer(MaterialStatsId::new, "tconstruct")).registerTypeHierarchyAdapter(ISpriteTransformer.class, ISpriteTransformer.SERIALIZER).registerTypeHierarchyAdapter(IColorMapping.class, IColorMapping.SERIALIZER).create();
    public static final RecordLoadable<MaterialGeneratorInfo> LOADABLE = RecordLoadable.create((RecordField)new GsonLoadable(GSON, ISpriteTransformer.class).requiredField("transformer", g -> g.transformer), (RecordField)new LegacyField(MaterialStatsId.PARSER.set(0).requiredField("supported_stats", g -> g.supportedStats), "supportedStats"), (RecordField)new LegacyField(BooleanLoadable.INSTANCE.defaultField("ignore_material_stats", (Object)false, false, g -> g.ignoreMaterialStats), "ignoreMaterialStats"), (RecordField)BooleanLoadable.INSTANCE.defaultField("variant", (Object)false, false, g -> g.variant), MaterialGeneratorInfo::new);
    private final ISpriteTransformer transformer;
    private final Set<MaterialStatsId> supportedStats;
    protected final boolean ignoreMaterialStats;
    private final boolean variant;

    public MaterialGeneratorInfo(MaterialGeneratorInfo other) {
        this(other.transformer, other.supportedStats, other.ignoreMaterialStats, other.variant);
    }

    public boolean supportStatType(MaterialStatsId statType) {
        return this.supportedStats.contains((Object)statType);
    }

    public MaterialGeneratorInfo(ISpriteTransformer transformer, Set<MaterialStatsId> supportedStats, boolean ignoreMaterialStats, boolean variant) {
        this.transformer = transformer;
        this.supportedStats = supportedStats;
        this.ignoreMaterialStats = ignoreMaterialStats;
        this.variant = variant;
    }

    public ISpriteTransformer getTransformer() {
        return this.transformer;
    }

    public boolean isVariant() {
        return this.variant;
    }
}

