/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.client.ClientRegistry;
import elucent.eidolon.common.entity.ChantCasterEntity;
import elucent.eidolon.common.item.ItemBase;
import elucent.eidolon.registries.Signs;
import elucent.eidolon.util.ClientInfo;
import elucent.eidolon.util.RenderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ChantScrollItem
extends ItemBase {
    public ChantScrollItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        List<Sign> spell;
        if (!pLevel.m_5776_() && this.hasSpell(pPlayer.m_21120_(pUsedHand)) && !(spell = ChantScrollItem.getSpell(pPlayer.m_21120_(pUsedHand))).isEmpty()) {
            ChantCasterEntity.createChanter(pPlayer, pLevel, spell);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public boolean hasSpell(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_("spell");
    }

    public static void setSpell(ItemStack stack, List<Sign> spell) {
        CompoundTag tag = stack.m_41784_();
        ListTag list = new ListTag();
        for (Sign sign : spell) {
            CompoundTag signTag = new CompoundTag();
            signTag.m_128359_("id", sign.getRegistryName().toString());
            list.add((Object)signTag);
        }
        tag.m_128365_("spell", (Tag)list);
    }

    public static List<Sign> getSpell(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("spell")) {
            ListTag list = tag.m_128437_("spell", 10);
            return list.stream().map(signTag -> Signs.find(ResourceLocation.m_135820_((String)((CompoundTag)signTag).m_128461_("id")))).toList();
        }
        return new ArrayList<Sign>();
    }

    public record ChantTooltipInfo(ItemStack stack, int maxWidth) implements TooltipComponent
    {
    }

    public static class ChantTooltipComponent
    implements ClientTooltipComponent {
        final ItemStack stack;
        final int maxWidth;

        public ChantTooltipComponent(ChantTooltipInfo info) {
            this.stack = info.stack;
            this.maxWidth = info.maxWidth;
        }

        public int m_142103_() {
            int charge = ChantScrollItem.getSpell(this.stack).size();
            int rows = (charge + 15) / 8;
            return charge == 0 ? 0 : 12 * rows;
        }

        public int m_142069_(@NotNull Font font) {
            return this.maxWidth;
        }

        public void m_183452_(@NotNull Font pFont, int pX, int pY, @NotNull GuiGraphics pGuiGraphics) {
            List<Sign> spell = ChantScrollItem.getSpell(this.stack);
            if (spell.isEmpty()) {
                return;
            }
            int spellSize = spell.size();
            for (int i = 0; i < spellSize; ++i) {
                Sign sign = spell.get(i);
                PoseStack mStack = pGuiGraphics.m_280168_();
                MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                RenderSystem.setShader(ClientRegistry::getGlowingSpriteShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
                float flicker = 0.75f + 0.05f * (float)Math.sin(Math.toRadians(12.0f * ClientInfo.getClientPartialTicks() - 360.0f * (float)i / (float)spell.size()));
                for (int j = 0; j < 2; ++j) {
                    RenderUtil.litQuad(mStack, (MultiBufferSource)bufferSource, 2 + pX + 17 * (i % 7), pY + 16 * (int)((float)i / 7.0f), 16.0, 16.0, sign.getRed() * flicker, sign.getGreen() * flicker, sign.getBlue() * flicker, (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(sign.getSprite()));
                    bufferSource.m_109911_();
                }
                RenderSystem.disableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.setShader(GameRenderer::m_172817_);
            }
        }
    }
}

