/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.ritual;

import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.common.tile.BrazierTileEntity;
import elucent.eidolon.util.ColorUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CraftingRitual
extends Ritual {
    final ItemStack result;
    private final boolean keepNbtOfReagent;

    public CraftingRitual(ResourceLocation symbol, int color, ItemStack result) {
        this(symbol, color, result, true);
    }

    public CraftingRitual(ResourceLocation symbol, int color, ItemStack result, boolean keepNBT) {
        super(symbol, color);
        this.result = result;
        this.keepNbtOfReagent = keepNBT;
    }

    @Override
    public Component getName() {
        return Component.m_237110_((String)"eidolon.ritual.crafting", (Object[])new Object[]{this.result.m_41611_().getString()});
    }

    @Override
    public Ritual cloneRitual() {
        return new CraftingRitual(this.getSymbol(), this.getColor(), this.result);
    }

    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public Ritual.RitualResult start(Level world, BlockPos pos) {
        BlockEntity blockEntity;
        if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof BrazierTileEntity) {
            BrazierTileEntity inv = (BrazierTileEntity)blockEntity;
            ItemStack result = this.getResult().m_41777_();
            if (this.keepNbtOfReagent && inv.getStack().m_41782_()) {
                result.m_41751_(inv.getStack().m_41783_());
                result.m_41721_(0);
            }
            world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 2.5, (double)pos.m_123343_() + 0.5, result));
        }
        return Ritual.RitualResult.TERMINATE;
    }

    public static class SanguineRitual
    extends CraftingRitual {
        public static final ResourceLocation SYMBOL = new ResourceLocation("eidolon", "particle/sanguine_ritual");

        public SanguineRitual(ItemStack result) {
            super(SYMBOL, ColorUtil.packColor(255, 255, 51, 85), result);
        }
    }
}

